/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Arrays;
import java.util.Comparator;
import org.netbeans.modules.cnd.utils.cache.TinyCharSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharSequenceKey
implements TinyCharSequence,
Comparable<CharSequence> {
    private static final TinyCharSequence EMPTY = new CharSequenceKey(new byte[0]);
    public static final Comparator<CharSequence> Comparator = new CharSequenceComparator();
    public static final Comparator<CharSequence> ComparatorIgnoreCase = new CharSequenceComparatorIgnoreCase();
    private final Object value;
    private int hash;

    public static CharSequence create(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        int n3 = n2;
        if (n3 == 0) {
            return EMPTY;
        }
        byte[] byArray = new byte[n3];
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[n + i];
            if ((c & 0xFF) != c) {
                bl = false;
                break;
            }
            byArray[i] = (byte)c;
        }
        if (bl) {
            return CharSequenceKey.createFromBytes(byArray, n3);
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return new CharSequenceKey(cArray2);
    }

    public static CharSequence create(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence instanceof TinyCharSequence) {
            return charSequence;
        }
        int n = charSequence.length();
        if (n == 0) {
            return EMPTY;
        }
        byte[] byArray = new byte[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ((c & 0xFF) != c) {
                bl = false;
                break;
            }
            byArray[i] = (byte)c;
        }
        if (bl) {
            return CharSequenceKey.createFromBytes(byArray, n);
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = charSequence.charAt(i);
        }
        return new CharSequenceKey(cArray);
    }

    public static CharSequence empty() {
        return EMPTY;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        return CharSequenceKey.indexOf(charSequence, charSequence2, 0);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        if (n >= n2) {
            return n3 == 0 ? n2 : -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 == 0) {
            return n;
        }
        char c = charSequence2.charAt(0);
        int n4 = n2 - n3;
        for (int i = n; i <= n4; ++i) {
            if (charSequence.charAt(i) != c) {
                while (++i <= n4 && charSequence.charAt(i) != c) {
                }
            }
            if (i > n4) continue;
            int n5 = i + 1;
            int n6 = n5 + n3 - 1;
            int n7 = 1;
            while (n5 < n6 && charSequence.charAt(n5) == charSequence2.charAt(n7)) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }

    private static TinyCharSequence createFromBytes(byte[] byArray, int n) {
        assert (byArray != null);
        if (n < 8) {
            return new Fixed7CharSequenceKey(byArray, n);
        }
        if (n < 16) {
            return new Fixed15CharSequenceKey(byArray, n);
        }
        return new CharSequenceKey(byArray);
    }

    private CharSequenceKey(byte[] byArray) {
        this.value = byArray;
    }

    private CharSequenceKey(char[] cArray) {
        this.value = cArray;
    }

    @Override
    public int length() {
        if (this.value instanceof byte[]) {
            return ((byte[])this.value).length;
        }
        return ((char[])this.value).length;
    }

    @Override
    public char charAt(int n) {
        if (this.value instanceof byte[]) {
            int n2 = ((byte[])this.value)[n] & 0xFF;
            return (char)n2;
        }
        return ((char[])this.value)[n];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CharSequenceKey) {
            CharSequenceKey charSequenceKey = (CharSequenceKey)object;
            if (this.hash != 0 && charSequenceKey.hash != 0 && this.hash != charSequenceKey.hash) {
                return false;
            }
            if (this.value instanceof byte[] && charSequenceKey.value instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])charSequenceKey.value);
            }
            if (this.value instanceof char[] && charSequenceKey.value instanceof char[]) {
                return Arrays.equals((char[])this.value, (char[])charSequenceKey.value);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            if (this.value instanceof byte[]) {
                byte[] byArray = (byte[])this.value;
                int n2 = byArray.length;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + byArray[i];
                }
            } else {
                char[] cArray = (char[])this.value;
                int n3 = cArray.length;
                for (int i = 0; i < n3; ++i) {
                    n = 31 * n + cArray[i];
                }
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return CharSequenceKey.create(this.toString().substring(n, n2));
    }

    @Override
    public String toString() {
        if (this.value instanceof byte[]) {
            byte[] byArray = (byte[])this.value;
            int n = byArray.length;
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i] & 0xFF;
                cArray[i] = (char)n2;
            }
            return new String(cArray);
        }
        char[] cArray = (char[])this.value;
        return new String(cArray);
    }

    @Override
    public int compareTo(CharSequence charSequence) {
        return Comparator.compare(this, charSequence);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Fixed15CharSequenceKey
    implements TinyCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;
        private final int i3;
        private final int i4;

        private Fixed15CharSequenceKey(byte[] byArray, int n) {
            int n2 = n;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            switch (n) {
                case 15: {
                    n5 += (byArray[14] & 0xFF) << 24;
                }
                case 14: {
                    n5 += (byArray[13] & 0xFF) << 16;
                }
                case 13: {
                    n5 += (byArray[12] & 0xFF) << 8;
                }
                case 12: {
                    n5 += byArray[11] & 0xFF;
                }
                case 11: {
                    n4 += (byArray[10] & 0xFF) << 24;
                }
                case 10: {
                    n4 += (byArray[9] & 0xFF) << 16;
                }
                case 9: {
                    n4 += (byArray[8] & 0xFF) << 8;
                }
                case 8: {
                    n4 += byArray[7] & 0xFF;
                }
                case 7: {
                    n3 += (byArray[6] & 0xFF) << 24;
                }
                case 6: {
                    n3 += (byArray[5] & 0xFF) << 16;
                }
                case 5: {
                    n3 += (byArray[4] & 0xFF) << 8;
                }
                case 4: {
                    n3 += byArray[3] & 0xFF;
                }
                case 3: {
                    n2 += (byArray[2] & 0xFF) << 24;
                }
                case 2: {
                    n2 += (byArray[1] & 0xFF) << 16;
                }
                case 1: {
                    n2 += (byArray[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = n2;
            this.i2 = n3;
            this.i3 = n4;
            this.i4 = n5;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    n2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    n2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    n2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    n2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    n2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    n2 = this.i2 >> 24 & 0xFF;
                    break;
                }
                case 7: {
                    n2 = this.i3 & 0xFF;
                    break;
                }
                case 8: {
                    n2 = (this.i3 & 0xFF00) >> 8;
                    break;
                }
                case 9: {
                    n2 = (this.i3 & 0xFF0000) >> 16;
                    break;
                }
                case 10: {
                    n2 = this.i3 >> 24 & 0xFF;
                    break;
                }
                case 11: {
                    n2 = this.i4 & 0xFF;
                    break;
                }
                case 12: {
                    n2 = (this.i4 & 0xFF00) >> 8;
                    break;
                }
                case 13: {
                    n2 = (this.i4 & 0xFF0000) >> 16;
                    break;
                }
                case 14: {
                    n2 = this.i4 >> 24 & 0xFF;
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this);
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed15CharSequenceKey) {
                Fixed15CharSequenceKey fixed15CharSequenceKey = (Fixed15CharSequenceKey)object;
                return this.i1 == fixed15CharSequenceKey.i1 && this.i2 == fixed15CharSequenceKey.i2 && this.i3 == fixed15CharSequenceKey.i3 && this.i4 == fixed15CharSequenceKey.i4;
            }
            return false;
        }

        public int hashCode() {
            return this.i1 + 31 * (this.i2 + 31 * (this.i3 + 31 * this.i4));
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequenceKey.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Fixed7CharSequenceKey
    implements TinyCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;

        private Fixed7CharSequenceKey(byte[] byArray, int n) {
            int n2 = n;
            int n3 = 0;
            switch (n) {
                case 7: {
                    n3 += (byArray[6] & 0xFF) << 24;
                }
                case 6: {
                    n3 += (byArray[5] & 0xFF) << 16;
                }
                case 5: {
                    n3 += (byArray[4] & 0xFF) << 8;
                }
                case 4: {
                    n3 += byArray[3] & 0xFF;
                }
                case 3: {
                    n2 += (byArray[2] & 0xFF) << 24;
                }
                case 2: {
                    n2 += (byArray[1] & 0xFF) << 16;
                }
                case 1: {
                    n2 += (byArray[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = n2;
            this.i2 = n3;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    n2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    n2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    n2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    n2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    n2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    n2 = this.i2 >> 24 & 0xFF;
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this);
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed7CharSequenceKey) {
                Fixed7CharSequenceKey fixed7CharSequenceKey = (Fixed7CharSequenceKey)object;
                return this.i1 == fixed7CharSequenceKey.i1 && this.i2 == fixed7CharSequenceKey.i2;
            }
            return false;
        }

        public int hashCode() {
            return this.i1 + 31 * this.i2;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequenceKey.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharSequenceComparatorIgnoreCase
    implements Comparator<CharSequence> {
        private CharSequenceComparatorIgnoreCase() {
        }

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            int n = charSequence.length();
            int n2 = charSequence2.length();
            int n3 = 0;
            for (int i = 0; n3 < n && i < n2; ++n3, ++i) {
                char c;
                char c2 = charSequence.charAt(n3);
                if (c2 == (c = charSequence2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
                return c2 - c;
            }
            return n - n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            CharSequenceKey charSequenceKey;
            if (charSequence instanceof CharSequenceKey) {
                if (charSequence2 instanceof CharSequenceKey) {
                    charSequenceKey = (CharSequenceKey)charSequence;
                    CharSequenceKey charSequenceKey2 = (CharSequenceKey)charSequence2;
                    if (charSequenceKey.value instanceof byte[] && charSequenceKey2.value instanceof byte[]) {
                        byte[] byArray = (byte[])charSequenceKey.value;
                        byte[] byArray2 = (byte[])charSequenceKey2.value;
                        int n = byArray.length;
                        int n2 = byArray2.length;
                        int n3 = Math.min(n, n2);
                        for (int i = 0; i < n3; ++i) {
                            if (byArray[i] == byArray2[i]) continue;
                            return (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
                        }
                        return n - n2;
                    }
                } else {
                    charSequenceKey = (CharSequenceKey)charSequence;
                    if (charSequenceKey.value instanceof byte[]) {
                        byte[] byArray = (byte[])charSequenceKey.value;
                        int n = byArray.length;
                        int n4 = charSequence2.length();
                        int n5 = Math.min(n, n4);
                        for (int i = 0; i < n5; ++i) {
                            int n6 = byArray[i] & 0xFF;
                            char c = charSequence2.charAt(i);
                            if (n6 == c) continue;
                            return n6 - c;
                        }
                        return n - n4;
                    }
                }
            } else if (charSequence2 instanceof CharSequenceKey && (charSequenceKey = (CharSequenceKey)charSequence2).value instanceof byte[]) {
                byte[] byArray = (byte[])charSequenceKey.value;
                int n = charSequence.length();
                int n7 = byArray.length;
                int n8 = Math.min(n, n7);
                for (int i = 0; i < n8; ++i) {
                    int n9;
                    char c = charSequence.charAt(i);
                    if (c == (n9 = byArray[i] & 0xFF)) continue;
                    return c - n9;
                }
                return n - n7;
            }
            int n = charSequence.length();
            int n10 = charSequence2.length();
            int n11 = Math.min(n, n10);
            for (int i = 0; i < n11; ++i) {
                char c;
                char c2 = charSequence.charAt(i);
                if (c2 == (c = charSequence2.charAt(i))) continue;
                return c2 - c;
            }
            return n - n10;
        }
    }
}

