/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class CndUtils {
    private static Logger LOG = Logger.getLogger("cnd.logger");
    private static boolean releaseMode;

    private CndUtils() {
    }

    public static boolean isStandalone() {
        return !CndUtils.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public static boolean isReleaseMode() {
        return releaseMode;
    }

    public static boolean isDebugMode() {
        return !CndUtils.isReleaseMode();
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public static void assertTrue(boolean bl) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(bl, "Assertion error");
        }
    }

    public static void assertFalse(boolean bl) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(!bl, "Assertion error");
        }
    }

    public static void assertFalse(boolean bl, String string) {
        CndUtils.assertTrue(!bl, string);
    }

    public static void assertTrue(boolean bl, String string) {
        if (CndUtils.isDebugMode() && !bl) {
            LOG.log(Level.SEVERE, string, new Exception(string));
        }
    }

    public static void assertTrueInConsole(boolean bl, String string) {
        if (CndUtils.isDebugMode() && !bl) {
            LOG.log(Level.INFO, string, new Exception(string));
        }
    }

    public static final void assertNonUiThread() {
        CndUtils.assertFalse(SwingUtilities.isEventDispatchThread(), "Should not be called from UI thread");
    }

    static {
        String string = System.getProperty("cnd.release.mode");
        if (string == null) {
            releaseMode = true;
            if (!$assertionsDisabled) {
                releaseMode = false;
                if (false) {
                    throw new AssertionError();
                }
            }
        } else {
            releaseMode = Boolean.parseBoolean(string);
        }
    }
}

