/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public class RadioButtonTag
extends AbstractHtmlInputElementTag {
    private Object value;
    private Object label;

    public void setValue(Object value) {
        this.value = value;
    }

    protected Object getValue() {
        return this.value;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    protected Object getLabel() {
        return this.label;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "radio");
        Object value = this.getValue();
        Object resolvedValue = this.evaluate("value", value);
        tagWriter.writeAttribute("value", this.getDisplayString(resolvedValue, this.getPropertyEditor()));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue)) {
            tagWriter.writeAttribute("checked", "checked");
        }
        if (this.getLabel() != null) {
            tagWriter.appendValue(this.getLabel().toString());
        }
        tagWriter.endTag();
        return 6;
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(this.getName(), this.pageContext);
    }
}

