/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanel<G extends JComponent, L extends JComponent>
extends JLayeredPane {
    private static final int PADDING = 12;
    private final G graph;
    private final L legend;
    private final JComponent hAxis;
    private final JComponent vAxis;
    private final JComponent graphPanel;
    private JComponent overlay;

    public GraphPanel(String string, G g, L l, JComponent jComponent, JComponent jComponent2) {
        this.graph = g;
        this.legend = l;
        this.hAxis = jComponent;
        this.vAxis = jComponent2;
        this.graphPanel = GraphPanel.createGraphPanel(string, g, l, jComponent, jComponent2);
        this.setOpaque(true);
        this.setMinimumSize(this.graphPanel.getMinimumSize());
        this.setPreferredSize(this.graphPanel.getPreferredSize());
        this.add((Component)this.graphPanel, (Object)0);
    }

    private static JPanel createGraphPanel(String string, JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle() | 1));
        jLabel.setForeground(GraphConfig.TEXT_COLOR);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        jPanel.add((Component)jLabel, gridBagConstraints);
        if (jComponent4 != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(6, 12, jComponent3 == null ? 12 : 0, 0);
            jPanel.add((Component)jComponent4, gridBagConstraints);
        }
        jComponent.setBorder(BorderFactory.createLineBorder(GraphConfig.BORDER_COLOR));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, jComponent4 == null ? 12 : 0, jComponent3 == null ? 12 : 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        jComponent2.setBackground(Color.WHITE);
        jComponent2.setBorder(BorderFactory.createLineBorder(GraphConfig.BORDER_COLOR));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, -1, jComponent3 == null ? 12 : 0, 12);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        if (jComponent3 != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = jComponent4 == null ? 0 : 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, jComponent4 == null ? 12 : 0, 12, 0);
            jPanel.add((Component)jComponent3, gridBagConstraints);
        }
        return jPanel;
    }

    protected final G getGraph() {
        return this.graph;
    }

    protected final L getLegend() {
        return this.legend;
    }

    protected final JComponent getHorizontalAxis() {
        return this.hAxis;
    }

    protected final JComponent getVerticalAxis() {
        return this.vAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        this.graphPanel.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        GraphPanel graphPanel = this;
        synchronized (graphPanel) {
            if (this.overlay != null) {
                this.graphPanel.validate();
                Rectangle rectangle = ((Component)this.graph).getBounds();
                this.overlay.setBounds(insets.left + rectangle.x + 6, insets.top + rectangle.y + 6, rectangle.width - 12, rectangle.height - 12);
            }
        }
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        ((JComponent)this.graph).setEnabled(bl);
        ((JComponent)this.legend).setEnabled(bl);
        if (this.vAxis != null) {
            this.vAxis.setEnabled(bl);
        }
        if (this.hAxis != null) {
            this.hAxis.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public final synchronized void setOverlay(JComponent jComponent) {
        if (this.overlay == jComponent) {
            return;
        }
        if (this.overlay != null) {
            this.remove(this.overlay);
        }
        if (jComponent != null) {
            this.add((Component)jComponent, (Object)1);
        }
        this.overlay = jComponent;
        this.revalidate();
        this.repaint();
    }
}

