/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.Graphics;
import javax.swing.JComponent;
import org.netbeans.modules.dlight.indicators.graph.GraphDescriptor;
import org.netbeans.modules.dlight.indicators.graph.GraphPainter;

public class Graph
extends JComponent {
    private final GraphPainter graph;
    private int upperLimit;
    private Axis hAxis;
    private Axis vAxis;

    public Graph(int n, LabelRenderer labelRenderer, GraphDescriptor ... graphDescriptorArray) {
        this.upperLimit = n;
        this.graph = new GraphPainter(labelRenderer, graphDescriptorArray);
        this.setOpaque(true);
    }

    public synchronized JComponent getVerticalAxis() {
        if (this.vAxis == null) {
            this.vAxis = new Axis(AxisOrientation.VERTICAL);
        }
        return this.vAxis;
    }

    public synchronized void setUpperLimit(int n) {
        if (n != this.upperLimit) {
            this.upperLimit = n;
            this.repaint();
            if (this.vAxis != null) {
                this.vAxis.repaint();
            }
        }
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    protected void paintComponent(Graphics graphics) {
        this.graph.paint(graphics, this.upperLimit, 0, 0, this.getWidth(), this.getHeight(), this.isEnabled());
    }

    public void addData(int ... nArray) {
        this.graph.addData(nArray);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    protected String formatValue(int n) {
        return String.format("%d", n);
    }

    private class Axis
    extends JComponent {
        private final AxisOrientation orientation;

        public Axis(AxisOrientation axisOrientation) {
            this.orientation = axisOrientation;
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isEnabled()) {
                Graph.this.graph.paintVerticalAxis(graphics, 0, 0, this.getWidth(), this.getHeight(), Graph.this.upperLimit, this.getBackground());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AxisOrientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static interface LabelRenderer {
        public String render(int var1);
    }
}

