/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.identity.profile.api.configurator.Configurator;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.ProviderConfigurator;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.ui.support.J2eeProjectHelper;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WSCSecurityPanel
extends SectionNodeInnerPanel {
    private static final String JKS_EXTENSION = ".jks";
    private static final String URN = "urn:";
    private Collection<ProviderConfigurator> configurators;
    private J2eeProjectHelper helper;
    private boolean disabled = false;
    private JButton browseButton;
    private JLabel certSettingsLabel;
    private JCheckBox enableSecurityCB;
    private JLabel errorLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel keyAliasLabel;
    private JLabel keyAliasPasswordLabel;
    private JTextField keyAliasTF;
    private JPasswordField keyPasswordTF;
    private JLabel keystoreLocationLabel;
    private JTextField keystoreLocationTF;
    private JLabel keystorePasswordLabel;
    private JPasswordField keystorePasswordTF;
    private JLabel passwordLabel;
    private JPasswordField passwordTF;
    private JLabel requestLabel;
    private JComboBox requestSecMechCB;
    private JLabel responseLabel;
    private JLabel secMechLabel;
    private JCheckBox signResponseCB;
    private JCheckBox useDefaultKeyStoreCB;
    private JLabel userNameLabel;
    private JTextField userNameTF;

    public WSCSecurityPanel(SectionNodeView sectionNodeView, J2eeProjectHelper j2eeProjectHelper) {
        super(sectionNodeView);
        this.initComponents();
        this.errorLabel.setText("");
        this.configurators = new ArrayList<ProviderConfigurator>();
        try {
            List<String> list = j2eeProjectHelper.getAllServiceNames();
            ProviderConfigurator providerConfigurator = list.iterator();
            while (providerConfigurator.hasNext()) {
                String string = providerConfigurator.next();
                this.configurators.add(ProviderConfigurator.getConfigurator((String)string, (ProviderConfigurator.Type)ProviderConfigurator.Type.WSC, (Configurator.AccessMethod)Configurator.AccessMethod.FILE, (Object)j2eeProjectHelper.getConfigPath(), (String)j2eeProjectHelper.getServerID()));
            }
        }
        catch (ConfiguratorException configuratorException) {
            this.errorLabel.setText(configuratorException.getMessage());
            this.disabled = true;
        }
        this.helper = j2eeProjectHelper;
        if (!this.disabled) {
            if (j2eeProjectHelper.isSecurityEnabled()) {
                this.enableSecurityCB.setSelected(true);
            } else {
                this.enableSecurityCB.setSelected(false);
            }
            for (ProviderConfigurator providerConfigurator : this.configurators) {
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.SECURITY_MECH, (Object)this.requestSecMechCB, (Object)(j2eeProjectHelper.getProjectType() == J2eeProjectHelper.ProjectType.WEB ? providerConfigurator.getSecMechHelper().getAllWSCSecurityMechanisms() : providerConfigurator.getSecMechHelper().getAllMessageLevelSecurityMechanisms()));
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.SIGN_RESPONSE, (Object)this.signResponseCB);
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.USE_DEFAULT_KEYSTORE, (Object)this.useDefaultKeyStoreCB);
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.KEYSTORE_LOCATION, (Object)this.keystoreLocationTF);
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.KEYSTORE_PASSWORD, (Object)this.keystorePasswordTF);
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.KEY_ALIAS, (Object)this.keyAliasTF);
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.KEY_PASSWORD, (Object)this.keyPasswordTF);
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.USERNAME, (Object)this.userNameTF);
                providerConfigurator.addModifier(ProviderConfigurator.Configurable.PASSWORD, (Object)this.passwordTF);
                providerConfigurator.addErrorComponent(this.errorLabel);
            }
        }
        this.updateVisualState();
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    private void updateVisualState() {
        if (this.disabled) {
            this.disableAll();
            this.enableSecurityCB.setEnabled(false);
            return;
        }
        if (this.helper.isWsitSecurityEnabled()) {
            this.enableSecurityCB.setEnabled(false);
            this.errorLabel.setText(NbBundle.getMessage(WSCSecurityPanel.class, (String)"MSG_WsitEnabled"));
        } else {
            this.enableSecurityCB.setEnabled(true);
            this.errorLabel.setText("");
        }
        if (this.enableSecurityCB.isSelected() && this.enableSecurityCB.isEnabled()) {
            this.secMechLabel.setEnabled(true);
            this.requestLabel.setEnabled(true);
            this.requestSecMechCB.setEnabled(true);
            this.userNameLabel.setEnabled(true);
            this.userNameTF.setEnabled(true);
            this.passwordLabel.setEnabled(true);
            this.passwordTF.setEnabled(true);
            this.responseLabel.setEnabled(true);
            this.signResponseCB.setEnabled(true);
            this.certSettingsLabel.setEnabled(true);
            this.useDefaultKeyStoreCB.setEnabled(true);
            if (!this.useDefaultKeyStoreCB.isSelected()) {
                this.keystoreLocationLabel.setEnabled(true);
                this.keystoreLocationTF.setEnabled(true);
                this.keystorePasswordLabel.setEnabled(true);
                this.keystorePasswordTF.setEnabled(true);
                this.keyAliasLabel.setEnabled(true);
                this.keyAliasTF.setEnabled(true);
                this.keyAliasPasswordLabel.setEnabled(true);
                this.keyPasswordTF.setEnabled(true);
                this.browseButton.setEnabled(true);
            } else {
                this.keystoreLocationLabel.setEnabled(false);
                this.keystoreLocationTF.setEnabled(false);
                this.keystorePasswordLabel.setEnabled(false);
                this.keystorePasswordTF.setEnabled(false);
                this.keyAliasLabel.setEnabled(false);
                this.keyAliasTF.setEnabled(false);
                this.keyAliasPasswordLabel.setEnabled(false);
                this.keyPasswordTF.setEnabled(false);
                this.browseButton.setEnabled(false);
            }
        } else {
            this.disableAll();
        }
        SecurityMechanism securityMechanism = (SecurityMechanism)this.requestSecMechCB.getSelectedItem();
        if (securityMechanism.isPasswordCredentialRequired() && this.requestSecMechCB.isEnabled()) {
            this.userNameLabel.setVisible(true);
            this.userNameTF.setVisible(true);
            this.passwordLabel.setVisible(true);
            this.passwordTF.setVisible(true);
        } else {
            this.userNameLabel.setVisible(false);
            this.userNameTF.setVisible(false);
            this.passwordLabel.setVisible(false);
            this.passwordTF.setVisible(false);
        }
    }

    private void disableAll() {
        this.secMechLabel.setEnabled(false);
        this.requestLabel.setEnabled(false);
        this.requestSecMechCB.setEnabled(false);
        this.userNameLabel.setEnabled(false);
        this.userNameTF.setEnabled(false);
        this.passwordLabel.setEnabled(false);
        this.passwordTF.setEnabled(false);
        this.responseLabel.setEnabled(false);
        this.signResponseCB.setEnabled(false);
        this.certSettingsLabel.setEnabled(false);
        this.useDefaultKeyStoreCB.setEnabled(false);
        this.keystoreLocationLabel.setEnabled(false);
        this.keystoreLocationTF.setEnabled(false);
        this.keystorePasswordLabel.setEnabled(false);
        this.keystorePasswordTF.setEnabled(false);
        this.keyAliasLabel.setEnabled(false);
        this.keyAliasTF.setEnabled(false);
        this.keyAliasPasswordLabel.setEnabled(false);
        this.keyPasswordTF.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.userNameLabel.setVisible(false);
        this.userNameTF.setVisible(false);
        this.passwordLabel.setVisible(false);
        this.passwordTF.setVisible(false);
    }

    public void save() {
        if (!this.disabled) {
            if (this.enableSecurityCB.isSelected()) {
                for (ProviderConfigurator providerConfigurator : this.configurators) {
                    providerConfigurator.save();
                }
                this.helper.enableWSCSecurity(this.isLiberty());
            } else {
                this.helper.disableWSCSecurity();
                for (ProviderConfigurator providerConfigurator : this.configurators) {
                    providerConfigurator.disable();
                    providerConfigurator.save();
                }
            }
        }
        for (ProviderConfigurator providerConfigurator : this.configurators) {
            providerConfigurator.close();
        }
        this.helper.clearTransientState();
    }

    public void cancel() {
        for (ProviderConfigurator providerConfigurator : this.configurators) {
            providerConfigurator.close();
        }
        this.helper.clearTransientState();
    }

    private boolean isLiberty() {
        SecurityMechanism securityMechanism = (SecurityMechanism)this.requestSecMechCB.getSelectedItem();
        return securityMechanism.isLiberty();
    }

    private void initComponents() {
        this.jSeparator2 = new JSeparator();
        this.enableSecurityCB = new JCheckBox();
        this.secMechLabel = new JLabel();
        this.requestLabel = new JLabel();
        this.requestSecMechCB = new JComboBox();
        this.userNameLabel = new JLabel();
        this.userNameTF = new JTextField();
        this.passwordLabel = new JLabel();
        this.responseLabel = new JLabel();
        this.signResponseCB = new JCheckBox();
        this.certSettingsLabel = new JLabel();
        this.keystoreLocationLabel = new JLabel();
        this.keystoreLocationTF = new JTextField();
        this.keystorePasswordLabel = new JLabel();
        this.keyAliasLabel = new JLabel();
        this.keyAliasTF = new JTextField();
        this.keyAliasPasswordLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.browseButton = new JButton();
        this.keystorePasswordTF = new JPasswordField();
        this.keyPasswordTF = new JPasswordField();
        this.useDefaultKeyStoreCB = new JCheckBox();
        this.passwordTF = new JPasswordField();
        this.errorLabel = new JLabel();
        this.setEnabled(false);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WSCSecurityPanel.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                WSCSecurityPanel.this.formAncestorAdded(ancestorEvent);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/identity/profile/ui/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.enableSecurityCB, (String)resourceBundle.getString("LBL_EnableSecurity"));
        this.enableSecurityCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableSecurityCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableSecurityCB.setOpaque(false);
        this.enableSecurityCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WSCSecurityPanel.this.enableSecurityCBActionPerformed(actionEvent);
            }
        });
        this.secMechLabel.setText(resourceBundle.getString("LBL_SecurityMechanisms"));
        this.requestLabel.setLabelFor(this.requestSecMechCB);
        Mnemonics.setLocalizedText((JLabel)this.requestLabel, (String)resourceBundle.getString("LBL_Request"));
        this.requestSecMechCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WSCSecurityPanel.this.requestSecMechCBActionPerformed(actionEvent);
            }
        });
        this.userNameLabel.setLabelFor(this.userNameTF);
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)resourceBundle.getString("LBL_UserName"));
        this.passwordLabel.setLabelFor(this.passwordTF);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)resourceBundle.getString("LBL_Password"));
        this.responseLabel.setText(resourceBundle.getString("LBL_Response"));
        Mnemonics.setLocalizedText((AbstractButton)this.signResponseCB, (String)resourceBundle.getString("LBL_VerifyResponse"));
        this.signResponseCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.signResponseCB.setMargin(new Insets(0, 0, 0, 0));
        this.signResponseCB.setOpaque(false);
        this.certSettingsLabel.setText(resourceBundle.getString("LBL_CertificateSettings"));
        this.keystoreLocationLabel.setLabelFor(this.keystoreLocationTF);
        Mnemonics.setLocalizedText((JLabel)this.keystoreLocationLabel, (String)resourceBundle.getString("LBL_KeyStoreLocation"));
        this.keystorePasswordLabel.setLabelFor(this.keystorePasswordTF);
        Mnemonics.setLocalizedText((JLabel)this.keystorePasswordLabel, (String)resourceBundle.getString("LBL_KeystorePassword"));
        this.keyAliasLabel.setLabelFor(this.keyAliasTF);
        Mnemonics.setLocalizedText((JLabel)this.keyAliasLabel, (String)resourceBundle.getString("LBL_KeyAlias"));
        this.keyAliasPasswordLabel.setLabelFor(this.keyPasswordTF);
        Mnemonics.setLocalizedText((JLabel)this.keyAliasPasswordLabel, (String)resourceBundle.getString("LBL_KeyAliasPassword"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)resourceBundle.getString("LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WSCSecurityPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.useDefaultKeyStoreCB, (String)resourceBundle.getString("LBL_UseDefaultKeyStore"));
        this.useDefaultKeyStoreCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useDefaultKeyStoreCB.setMargin(new Insets(0, 0, 0, 0));
        this.useDefaultKeyStoreCB.setOpaque(false);
        this.useDefaultKeyStoreCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WSCSecurityPanel.this.useDefaultKeyStoreCBActionPerformed(actionEvent);
            }
        });
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setText("Error:");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.secMechLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.requestLabel).addPreferredGap(0).add((Component)this.requestSecMechCB, 0, 343, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.passwordLabel).add((Component)this.userNameLabel)).add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.passwordTF, -1, 320, Short.MAX_VALUE).add((Component)this.userNameTF, -1, 320, Short.MAX_VALUE)).addPreferredGap(0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.responseLabel).addPreferredGap(0).add((Component)this.signResponseCB)))).add((Component)this.certSettingsLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.keystoreLocationLabel).add(10, 10, 10).add((Component)this.keystoreLocationTF, -1, 202, Short.MAX_VALUE)).add((Component)this.useDefaultKeyStoreCB).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.keystorePasswordLabel).add((Component)this.keyAliasLabel).add((Component)this.keyAliasPasswordLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.keyPasswordTF, -1, 197, Short.MAX_VALUE)).add((Component)this.keyAliasTF, -1, 197, Short.MAX_VALUE).add((Component)this.keystorePasswordTF, -1, 197, Short.MAX_VALUE)))).addPreferredGap(0).add((Component)this.browseButton)).add((Component)this.enableSecurityCB).add((Component)this.jSeparator1, -1, 409, Short.MAX_VALUE).add((Component)this.errorLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.enableSecurityCB, -2, 15, -2).addPreferredGap(0).add((Component)this.secMechLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.requestLabel).add((Component)this.requestSecMechCB, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.userNameTF, -2, 19, -2).add((Component)this.userNameLabel)).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.responseLabel).add((Component)this.signResponseCB)).addPreferredGap(0).add((Component)this.certSettingsLabel).addPreferredGap(0).add((Component)this.useDefaultKeyStoreCB).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keystoreLocationTF, -2, -1, -2).add((Component)this.browseButton).add((Component)this.keystoreLocationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keystorePasswordLabel).add((Component)this.keystorePasswordTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyAliasLabel).add((Component)this.keyAliasTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyAliasPasswordLabel).add((Component)this.keyPasswordTF, -2, -1, -2)).add(11, 11, 11).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.errorLabel, -2, 14, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.updateVisualState();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
    }

    private void useDefaultKeyStoreCBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isFile()) {
                    return file.getName().endsWith(WSCSecurityPanel.JKS_EXTENSION);
                }
                return true;
            }

            public String getDescription() {
                return NbBundle.getMessage(WSCSecurityPanel.class, (String)"TXT_JavaKeyStore");
            }
        });
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.keystoreLocationTF.setText(jFileChooser.getSelectedFile().getPath());
        }
    }

    private void requestSecMechCBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState();
        if (this.isLiberty()) {
            List<String> list = this.helper.getEndpointURI();
            int n = 0;
            for (ProviderConfigurator providerConfigurator : this.configurators) {
                providerConfigurator.setValue((Enum)ProviderConfigurator.Configurable.SERVICE_TYPE, (Object)(URN + list.get(n)));
                ++n;
            }
        } else {
            for (ProviderConfigurator providerConfigurator : this.configurators) {
                providerConfigurator.setValue((Enum)ProviderConfigurator.Configurable.SERVICE_TYPE, null);
            }
        }
    }

    private void enableSecurityCBActionPerformed(ActionEvent actionEvent) {
        if (this.enableSecurityCB.isSelected()) {
            this.helper.setTransientState(true);
        } else {
            this.helper.setTransientState(false);
        }
        this.updateVisualState();
    }
}

