/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.hierarchy.ContextUtils;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionTopComponent;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;

public final class MacroExpansionViewUtils {
    public static final String MACRO_EXPANSION_START_OFFSET = "macro-expansion-start-offset";
    public static final String MACRO_EXPANSION_END_OFFSET = "macro-expansion-end-offset";

    public static boolean updateView(int n) {
        Object object;
        final MacroExpansionTopComponent macroExpansionTopComponent = MacroExpansionTopComponent.findInstance();
        boolean bl = MacroExpansionTopComponent.isLocalContext();
        Document document = macroExpansionTopComponent.getExpandedContextDoc();
        if (document == null) {
            return false;
        }
        Document document2 = (Document)document.getProperty(Document.class);
        if (document2 == null) {
            return false;
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document2, (boolean)true);
        if (csmFile == null) {
            return false;
        }
        int n2 = 0;
        int n3 = document2.getLength();
        if (bl && CsmKindUtilities.isOffsetable((Object)(object = ContextUtils.findInnerFileScope(csmFile, n)))) {
            n2 = ((CsmOffsetable)object).getStartOffset();
            n3 = ((CsmOffsetable)object).getEndOffset();
        }
        if (!MacroExpansionViewUtils.isOffsetChanged(document, n2, n3)) {
            return false;
        }
        object = MacroExpansionViewUtils.createExpandedContextDocument(document2, csmFile);
        if (object == null) {
            return false;
        }
        int n4 = CsmMacroExpansion.expand((Document)document2, (int)n2, (int)n3, (Document)object);
        MacroExpansionViewUtils.setOffset((Document)object, n2, n3);
        MacroExpansionViewUtils.saveDocumentAndMarkAsReadOnly((Document)object);
        Document document3 = MacroExpansionViewUtils.createExpandedMacroDocument(document2, csmFile);
        if (document3 == null) {
            return false;
        }
        CsmDeclaration csmDeclaration = ContextUtils.findInnerFileDeclaration(csmFile, n);
        if (csmDeclaration != null) {
            try {
                document3.insertString(0, ((Object)csmDeclaration.getName()).toString(), null);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        MacroExpansionViewUtils.saveDocumentAndMarkAsReadOnly(document3);
        Runnable runnable = new Runnable((Document)object, document3, n4){
            final /* synthetic */ Document val$newExpandedContextDoc;
            final /* synthetic */ Document val$expandedMacroDoc;
            final /* synthetic */ int val$expansionsNumber;
            {
                this.val$newExpandedContextDoc = document;
                this.val$expandedMacroDoc = document2;
                this.val$expansionsNumber = n;
            }

            public void run() {
                if (!macroExpansionTopComponent.isOpened()) {
                    macroExpansionTopComponent.open();
                }
                macroExpansionTopComponent.setDocuments(this.val$newExpandedContextDoc, this.val$expandedMacroDoc);
                macroExpansionTopComponent.setStatusBarText(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionStatusBarLine", (Object)this.val$expansionsNumber));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
        return true;
    }

    private static boolean isOffsetChanged(Document document, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Object object = document.getProperty(MACRO_EXPANSION_START_OFFSET);
        if (object instanceof Integer) {
            n3 = (Integer)object;
        }
        if ((object = document.getProperty(MACRO_EXPANSION_END_OFFSET)) instanceof Integer) {
            n4 = (Integer)object;
        }
        return n3 != n || n4 != n2;
    }

    public static void setOffset(Document document, int n, int n2) {
        document.putProperty(MACRO_EXPANSION_START_OFFSET, n);
        document.putProperty(MACRO_EXPANSION_END_OFFSET, n2);
    }

    public static Document createExpandedContextDocument(Document document, CsmFile csmFile) {
        FileObject fileObject = MacroExpansionViewUtils.createMemoryFile(CsmUtilities.getFile((Document)document).getName());
        if (fileObject == null) {
            return null;
        }
        Document document2 = MacroExpansionViewUtils.openFileDocument(fileObject);
        if (document2 == null) {
            return null;
        }
        document2.putProperty("title", document.getProperty("title"));
        document2.putProperty(CsmFile.class, csmFile);
        document2.putProperty(FileObject.class, fileObject);
        document2.putProperty("beforeSaveRunnable", null);
        document2.putProperty("macro-expansion-view-document", true);
        document.putProperty(Document.class, document2);
        document2.putProperty(Document.class, document);
        MacroExpansionViewUtils.setupMimeType(document2);
        return document2;
    }

    public static Document createExpandedMacroDocument(Document document, CsmFile csmFile) {
        FileObject fileObject = MacroExpansionViewUtils.createMemoryFile(CsmUtilities.getFile((Document)document).getName());
        if (fileObject == null) {
            return null;
        }
        Document document2 = MacroExpansionViewUtils.openFileDocument(fileObject);
        if (document2 == null) {
            return null;
        }
        document2.putProperty(FileObject.class, fileObject);
        MacroExpansionViewUtils.setupMimeType(document2);
        return document2;
    }

    public static int getFileOffset(Document document, int n) {
        return CsmMacroExpansion.getOffsetInOriginalText((Document)document, (int)n);
    }

    public static int getDocumentOffset(Document document, int n) {
        return CsmMacroExpansion.getOffsetInExpandedText((Document)document, (int)n);
    }

    public static JEditorPane getEditor(Document document) {
        EditorCookie editorCookie;
        JEditorPane[] jEditorPaneArray;
        Object object = document.getProperty(JEditorPane.class);
        if (object != null) {
            return (JEditorPane)object;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        if (dataObject != null && (jEditorPaneArray = CsmUtilities.getOpenedPanesInEQ((EditorCookie)(editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)))) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    public static void setupMimeType(Document document) {
        Object object = document.getProperty("mimeType");
        if (object != null && "text/plain".equals(object)) {
            document.putProperty("mimeType", "text/x-c++");
        }
    }

    public static FileObject createMemoryFile(String string) {
        FileObject fileObject = null;
        try {
            FileObject fileObject2 = FileUtil.createMemoryFileSystem().getRoot();
            fileObject = FileUtil.createData((FileObject)fileObject2, (String)string);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return fileObject;
    }

    public static Document openFileDocument(FileObject fileObject) {
        StyledDocument styledDocument = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (UserQuestionException userQuestionException) {
                userQuestionException.confirmed();
                styledDocument = editorCookie.openDocument();
            }
            if (styledDocument != null) {
                styledDocument.putProperty("stream", dataObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return styledDocument;
    }

    public static void saveDocumentAndMarkAsReadOnly(Document document) {
        FileObject fileObject = CsmUtilities.getFileObject((Document)document);
        if (fileObject != null) {
            MacroExpansionViewUtils.saveFileAndMarkAsReadOnly(fileObject);
        }
    }

    private static void saveFileAndMarkAsReadOnly(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            editorCookie.saveDocument();
            ReadOnlySupport readOnlySupport = (ReadOnlySupport)dataObject.getLookup().lookup(ReadOnlySupport.class);
            if (readOnlySupport != null) {
                readOnlySupport.setReadOnly(true);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static void lockFile(FileObject fileObject) {
        try {
            fileObject.lock();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

