/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionTopComponent;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MacroExpansionPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/macroview/resources/macroexpansion.png";
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private JToggleButton autoRefresh;
    private JToggleButton fileContext;
    private JEditorPane jCodeExpansionEditorPane;
    private JScrollPane jCodeExpansionPane;
    private JEditorPane jMacroExpansionEditorPane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator4;
    private JSplitPane jSplitPane1;
    private JLabel jStatusBar;
    private JToolBar jToolBar1;
    private JToggleButton localContext;
    private JButton nextMacro;
    private JButton prevMacro;

    public MacroExpansionPanel(boolean bl) {
        this.initComponents();
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_MacroExpansionTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_MacroExpansionTopComponent"));
    }

    public void setMacroExpansionDocument(Document document) {
        Object object = document.getProperty("mimeType");
        String string = "text/x-c++";
        if (object != null) {
            string = (String)object;
        }
        this.jMacroExpansionEditorPane.setContentType(string);
        this.jMacroExpansionEditorPane.setDocument(document);
    }

    public void setContextExpansionDocument(Document document) {
        Object object = document.getProperty("mimeType");
        String string = "text/x-c++";
        if (object != null) {
            string = (String)object;
        }
        this.jCodeExpansionEditorPane.setContentType(string);
        this.jCodeExpansionEditorPane.setDocument(document);
        document.putProperty(JEditorPane.class, this.jCodeExpansionEditorPane);
    }

    public int getDividerLocation() {
        return this.jSplitPane1.getDividerLocation();
    }

    public void setDividerLocation(int n) {
        this.jSplitPane1.setDividerLocation(n);
    }

    public boolean isLocalContext() {
        return this.localContext.isSelected();
    }

    public void setLocalContext(boolean bl) {
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return;
        }
        document.putProperty("macro-expansion-sync-context", this.isSyncCaretAndContext() && bl);
        this.localContext.setSelected(bl);
        this.fileContext.setSelected(!bl);
    }

    public boolean isSyncCaretAndContext() {
        return this.autoRefresh.isSelected();
    }

    public void setSyncCaretAndContext(boolean bl) {
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return;
        }
        document.putProperty("macro-expansion-sync-caret", bl);
        document.putProperty("macro-expansion-sync-context", bl && this.isLocalContext());
        this.autoRefresh.setSelected(bl);
    }

    public void setStatusBarText(String string) {
        this.jStatusBar.setText(string);
    }

    public void updateCaretPosition() {
        this.jCodeExpansionEditorPane.setCaretPosition(this.getCursorPositionFromMainDocument());
    }

    private int getCursorPositionFromMainDocument() {
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return 0;
        }
        Document document2 = (Document)document.getProperty(Document.class);
        if (document2 == null) {
            return 0;
        }
        int n = MacroExpansionViewUtils.getDocumentOffset(document, MacroExpansionViewUtils.getFileOffset(document2, this.getMainDocumentCursorPosition()));
        if (n >= 0 && n < document.getLength()) {
            return n;
        }
        return 0;
    }

    private int getMainDocumentCursorPosition() {
        JEditorPane jEditorPane;
        FileObject fileObject;
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return 0;
        }
        Document document2 = (Document)document.getProperty(Document.class);
        if (document2 != null && (fileObject = CsmUtilities.getFileObject((Document)document2)) != null && (jEditorPane = MacroExpansionViewUtils.getEditor(document2)) != null) {
            int n = jEditorPane.getCaretPosition();
            return n;
        }
        return 0;
    }

    private void update() {
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return;
        }
        Document document2 = (Document)document.getProperty(Document.class);
        if (document2 == null) {
            return;
        }
        JEditorPane jEditorPane = MacroExpansionViewUtils.getEditor(document);
        if (jEditorPane == null) {
            return;
        }
        int n = MacroExpansionViewUtils.getDocumentOffset(document2, MacroExpansionViewUtils.getFileOffset(document, jEditorPane.getCaretPosition()));
        CsmMacroExpansion.showMacroExpansionView((Document)document2, (int)n);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jMacroExpansionEditorPane = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jCodeExpansionPane = new JScrollPane();
        this.jCodeExpansionEditorPane = new JEditorPane();
        this.jStatusBar = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.autoRefresh = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.localContext = new JToggleButton();
        this.fileContext = new JToggleButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.prevMacro = new JButton();
        this.nextMacro = new JButton();
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setFocusable(false);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jScrollPane1.setBorder(null);
        this.jMacroExpansionEditorPane.setBorder(null);
        this.jMacroExpansionEditorPane.setEditable(false);
        this.jScrollPane1.setViewportView(this.jMacroExpansionEditorPane);
        this.setLayout(new BorderLayout());
        this.jPanel1.setMaximumSize(new Dimension(100, 100));
        this.jPanel1.setMinimumSize(new Dimension(100, 100));
        this.jPanel1.setLayout(new BorderLayout());
        this.jCodeExpansionPane.setBorder(null);
        this.jCodeExpansionEditorPane.setBorder(null);
        this.jCodeExpansionPane.setViewportView(this.jCodeExpansionEditorPane);
        this.jPanel1.add((Component)this.jCodeExpansionPane, "Center");
        this.jStatusBar.setText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.jStatusBar.text"));
        this.jPanel1.add((Component)this.jStatusBar, "Last");
        this.add((Component)this.jPanel1, "Center");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(28, 240));
        this.jToolBar1.setPreferredSize(new Dimension(28, 240));
        this.autoRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/sync.png")));
        this.autoRefresh.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.autoRefresh.toolTipText"));
        this.autoRefresh.setFocusable(false);
        this.autoRefresh.setHorizontalTextPosition(0);
        this.autoRefresh.setMaximumSize(new Dimension(24, 24));
        this.autoRefresh.setMinimumSize(new Dimension(24, 24));
        this.autoRefresh.setPreferredSize(new Dimension(24, 24));
        this.autoRefresh.setVerticalTextPosition(3);
        this.autoRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroExpansionPanel.this.autoRefreshActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.autoRefresh);
        this.jSeparator1.setSeparatorSize(new Dimension(0, 4));
        this.jToolBar1.add(this.jSeparator1);
        this.localContext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/declscope.png")));
        this.localContext.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.localContext.toolTipText"));
        this.localContext.setFocusable(false);
        this.localContext.setHorizontalTextPosition(0);
        this.localContext.setMaximumSize(new Dimension(24, 24));
        this.localContext.setMinimumSize(new Dimension(24, 24));
        this.localContext.setPreferredSize(new Dimension(24, 24));
        this.localContext.setVerticalTextPosition(3);
        this.localContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroExpansionPanel.this.localContextActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.localContext);
        this.fileContext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/filescope.png")));
        this.fileContext.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.fileContext.toolTipText"));
        this.fileContext.setFocusable(false);
        this.fileContext.setHorizontalTextPosition(0);
        this.fileContext.setMaximumSize(new Dimension(24, 24));
        this.fileContext.setMinimumSize(new Dimension(24, 24));
        this.fileContext.setPreferredSize(new Dimension(24, 24));
        this.fileContext.setVerticalTextPosition(3);
        this.fileContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroExpansionPanel.this.fileContextActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.fileContext);
        this.fileContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.localContext.AccessibleContext.accessibleDescription"));
        this.jSeparator4.setSeparatorSize(new Dimension(0, 4));
        this.jToolBar1.add(this.jSeparator4);
        this.prevMacro.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/prevmacro.png")));
        this.prevMacro.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.prevMacro.toolTipText"));
        this.prevMacro.setFocusable(false);
        this.prevMacro.setHorizontalTextPosition(0);
        this.prevMacro.setMaximumSize(new Dimension(24, 24));
        this.prevMacro.setMinimumSize(new Dimension(24, 24));
        this.prevMacro.setPreferredSize(new Dimension(24, 24));
        this.prevMacro.setVerticalTextPosition(3);
        this.prevMacro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroExpansionPanel.this.prevMacroActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.prevMacro);
        this.prevMacro.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.prevMacro.AccessibleContext.accessibleDescription"));
        this.nextMacro.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/nextmacro.png")));
        this.nextMacro.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.nextMacro.toolTipText"));
        this.nextMacro.setFocusable(false);
        this.nextMacro.setHorizontalTextPosition(0);
        this.nextMacro.setMaximumSize(new Dimension(24, 24));
        this.nextMacro.setMinimumSize(new Dimension(24, 24));
        this.nextMacro.setPreferredSize(new Dimension(24, 24));
        this.nextMacro.setVerticalTextPosition(3);
        this.nextMacro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroExpansionPanel.this.nextMacroActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.nextMacro);
        this.nextMacro.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.nextMacro.AccessibleContext.accessibleDescription"));
        this.add((Component)this.jToolBar1, "Before");
    }

    private void nextMacroActionPerformed(ActionEvent actionEvent) {
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return;
        }
        int n = CsmMacroExpansion.getNextMacroExpansionStartOffset((Document)document, (int)this.jCodeExpansionEditorPane.getCaretPosition());
        if (n >= 0 && n < document.getLength()) {
            this.jCodeExpansionEditorPane.setCaretPosition(n);
        }
    }

    private void prevMacroActionPerformed(ActionEvent actionEvent) {
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return;
        }
        int n = CsmMacroExpansion.getPrevMacroExpansionStartOffset((Document)document, (int)this.jCodeExpansionEditorPane.getCaretPosition());
        if (n >= 0 && n < document.getLength()) {
            this.jCodeExpansionEditorPane.setCaretPosition(n);
        }
    }

    private void localContextActionPerformed(ActionEvent actionEvent) {
        this.fileContext.setSelected(false);
        this.localContext.setSelected(true);
        MacroExpansionTopComponent.setLocalContext(true);
        this.update();
    }

    private void fileContextActionPerformed(ActionEvent actionEvent) {
        this.fileContext.setSelected(true);
        this.localContext.setSelected(false);
        MacroExpansionTopComponent.setLocalContext(false);
        this.update();
    }

    private void autoRefreshActionPerformed(ActionEvent actionEvent) {
        Document document = this.jCodeExpansionEditorPane.getDocument();
        if (document == null) {
            return;
        }
        if (this.isSyncCaretAndContext()) {
            document.putProperty("macro-expansion-sync-caret", true);
            document.putProperty("macro-expansion-sync-context", this.isLocalContext());
            this.update();
        } else {
            document.putProperty("macro-expansion-sync-caret", false);
            document.putProperty("macro-expansion-sync-context", false);
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.jCodeExpansionPane.requestFocusInWindow();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("MacroExpansionView");
    }
}

