/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.openide.filesystems.FileObject;

public class MacroExpansionCaretAwareFactory
extends CaretAwareCsmFileTaskFactory {
    protected CsmFileTaskFactory.PhaseRunner createTask(final FileObject fileObject) {
        return new CsmFileTaskFactory.PhaseRunner(){

            public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
                Document document;
                boolean bl = false;
                Document document2 = CsmUtilities.getDocument((FileObject)fileObject);
                if (document2 == null) {
                    return;
                }
                Object object = document2.getProperty("use-own-caret-position");
                if (object != null && !((Boolean)object).booleanValue()) {
                    return;
                }
                if (!MacroExpansionCaretAwareFactory.isMacroExpansionDoc(document2) && (document = (Document)document2.getProperty(Document.class)) != null && MacroExpansionCaretAwareFactory.isContextSuncEnabled(document)) {
                    bl = MacroExpansionViewUtils.updateView(CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fileObject));
                }
                if (!bl) {
                    MacroExpansionCaretAwareFactory.syncRelatedDocumentCaretPosition(fileObject);
                }
            }

            public boolean isValid() {
                return true;
            }

            public void cancel() {
            }

            public boolean isHighPriority() {
                return false;
            }
        };
    }

    private static boolean isMacroExpansionDoc(Document document) {
        return document.getProperty("macro-expansion-view-document") != null;
    }

    private static boolean isCaretSuncEnabledOnCurrentDoc(Document document) {
        Object object;
        boolean bl = true;
        if (document.getProperty("macro-expansion-view-document") != null && (object = document.getProperty("macro-expansion-sync-caret")) instanceof Boolean) {
            bl &= ((Boolean)object).booleanValue();
        }
        if ((object = document.getProperty("use-own-caret-position")) != null) {
            bl &= ((Boolean)object).booleanValue();
        }
        return bl;
    }

    private static boolean isCaretSuncEnabledOnRelatedDoc(Document document) {
        Object object;
        boolean bl = true;
        if (document.getProperty("macro-expansion-view-document") != null && (object = document.getProperty("macro-expansion-sync-caret")) instanceof Boolean) {
            bl &= ((Boolean)object).booleanValue();
        }
        return bl;
    }

    private static boolean isContextSuncEnabled(Document document) {
        Object object;
        if (document.getProperty("macro-expansion-view-document") != null && (object = document.getProperty("macro-expansion-sync-context")) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private static void syncRelatedDocumentCaretPosition(FileObject fileObject) {
        FileObject fileObject2;
        Document document;
        Document document2 = CsmUtilities.getDocument((FileObject)fileObject);
        if (document2 != null && MacroExpansionCaretAwareFactory.isCaretSuncEnabledOnCurrentDoc(document2) && (document = (Document)document2.getProperty(Document.class)) != null && MacroExpansionCaretAwareFactory.isCaretSuncEnabledOnRelatedDoc(document) && (fileObject2 = CsmUtilities.getFileObject((Document)document)) != null) {
            JEditorPane jEditorPane;
            int n = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fileObject2);
            int n2 = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fileObject);
            int n3 = MacroExpansionViewUtils.getDocumentOffset(document, MacroExpansionViewUtils.getFileOffset(document2, n2));
            int n4 = MacroExpansionViewUtils.getDocumentOffset(document2, MacroExpansionViewUtils.getFileOffset(document, n));
            if (n3 >= 0 && n3 < document.getLength() && (jEditorPane = MacroExpansionViewUtils.getEditor(document)) != null && n != n3 && n2 != n4 && !jEditorPane.hasFocus()) {
                MacroExpansionCaretAwareFactory.setCaretPosition(jEditorPane, n3);
            }
        }
    }

    private static void setCaretPosition(final JEditorPane jEditorPane, final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                jEditorPane.setCaretPosition(n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected int taskDelay() {
        return 0;
    }

    protected int rescheduleDelay() {
        return 0;
    }
}

