/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.hierarchy;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.navigation.classhierarchy.ClassHierarchyPanel;
import org.netbeans.modules.cnd.navigation.includeview.IncludeHierarchyPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class HierarchyTopComponent
extends TopComponent
implements CsmModelListener {
    private static HierarchyTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.gif";
    private static final String PREFERRED_ID = "HierarchyTopComponent";
    private JComponent last = null;
    private JButton jButton1;

    private HierarchyTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_HierarchyTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    void setClass(CsmClass csmClass, boolean bl) {
        this.setName(csmClass.getName() + " - " + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_TypeHierarchyTopComponent"));
        if (!(this.last instanceof ClassHierarchyPanel)) {
            this.removeAll();
            ClassHierarchyPanel classHierarchyPanel = new ClassHierarchyPanel(true);
            this.add(classHierarchyPanel, "Center");
            this.validate();
            classHierarchyPanel.setClass(csmClass);
            this.last = classHierarchyPanel;
        }
        if (bl) {
            ((ClassHierarchyPanel)this.last).setClose();
        } else {
            ((ClassHierarchyPanel)this.last).clearClose();
        }
        ((ClassHierarchyPanel)this.last).setClass(csmClass);
        this.last.requestFocusInWindow();
    }

    void setFile(CsmFile csmFile, boolean bl) {
        this.setName(csmFile.getName() + " - " + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_IncludeHierarchyTopComponent"));
        if (!(this.last instanceof IncludeHierarchyPanel)) {
            this.removeAll();
            IncludeHierarchyPanel includeHierarchyPanel = new IncludeHierarchyPanel(true);
            this.add(includeHierarchyPanel, "Center");
            this.validate();
            this.last = includeHierarchyPanel;
        }
        if (bl) {
            ((IncludeHierarchyPanel)this.last).setClose();
        } else {
            ((IncludeHierarchyPanel)this.last).clearClose();
        }
        ((IncludeHierarchyPanel)this.last).setFile(csmFile);
        this.last.requestFocusInWindow();
    }

    public void requestActive() {
        super.requestActive();
        if (this.last != null) {
            this.last.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        this.jButton1.setBackground(new JTextArea().getBackground());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(HierarchyTopComponent.class, (String)"NoViewAvailable"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setEnabled(false);
        this.add(this.jButton1, "Center");
    }

    public static synchronized HierarchyTopComponent getDefault() {
        if (instance == null) {
            instance = new HierarchyTopComponent();
        }
        return instance;
    }

    public static synchronized HierarchyTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(HierarchyTopComponent.class.getName()).warning("Cannot find HierarchyTopComponent component. It will not be located properly in the window system.");
            return HierarchyTopComponent.getDefault();
        }
        if (topComponent instanceof HierarchyTopComponent) {
            return (HierarchyTopComponent)topComponent;
        }
        Logger.getLogger(HierarchyTopComponent.class.getName()).warning("There seem to be multiple components with the 'HierarchyTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return HierarchyTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        CsmListeners.getDefault().addModelListener((CsmModelListener)this);
    }

    public void componentClosed() {
        this.removeAll();
        this.initComponents();
        this.last = null;
        CsmListeners.getDefault().removeModelListener((CsmModelListener)this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void projectOpened(CsmProject csmProject) {
    }

    public void projectClosed(CsmProject csmProject) {
        if (CsmModelAccessor.getModel().projects().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HierarchyTopComponent hierarchyTopComponent = HierarchyTopComponent.findInstance();
                    if (hierarchyTopComponent.isOpened()) {
                        hierarchyTopComponent.close();
                    }
                }
            });
        }
    }

    public void modelChanged(CsmChangeEvent csmChangeEvent) {
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return HierarchyTopComponent.getDefault();
        }
    }
}

