/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.annotations.CallStackAnnotation;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.models.CallStackModel;
import org.netbeans.modules.php.dbgp.packets.ContextNamesCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.EvalCommand;
import org.netbeans.modules.php.dbgp.packets.Stack;
import org.netbeans.modules.php.dbgp.packets.StackGetCommand;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackGetResponse
extends DbgpResponse {
    private static final String STACK = "stack";

    StackGetResponse(Node node) {
        super(node);
    }

    public List<Stack> getStackElements() {
        LinkedList<Stack> linkedList = new LinkedList<Stack>();
        List<Node> list = StackGetResponse.getChildren(this.getNode(), STACK);
        for (Node node : list) {
            linkedList.add(new Stack(node));
        }
        return linkedList;
    }

    @Override
    public void process(DebugSession debugSession, DbgpCommand dbgpCommand) {
        if (!(dbgpCommand instanceof StackGetCommand)) {
            return;
        }
        List<Stack> list = this.getStackElements();
        this.annotateStackTrace(debugSession, list);
        DebugSession debugSession2 = SessionManager.getInstance().getCurrentSession(debugSession.getSessionId());
        if (debugSession2 != debugSession) {
            return;
        }
        this.updateUIViews(debugSession, list);
    }

    private void updateUIViews(DebugSession debugSession, List<Stack> list) {
        CallStackModel callStackModel;
        DebugSession.IDESessionBridge iDESessionBridge = debugSession.getBridge();
        if (iDESessionBridge != null && (callStackModel = iDESessionBridge.getCallStackModel()) != null) {
            callStackModel.setCallStack(list);
        }
        this.requestContextNames(debugSession);
        StackGetResponse.updateWatchView(debugSession);
        this.updateBreakpointsView(debugSession, list);
    }

    private void updateBreakpointsView(DebugSession debugSession, List<Stack> list) {
        BreakpointModel breakpointModel;
        if (list.size() == 0) {
            return;
        }
        DebugSession.IDESessionBridge iDESessionBridge = debugSession.getBridge();
        if (iDESessionBridge != null && (breakpointModel = iDESessionBridge.getBreakpointModel()) != null) {
            breakpointModel.setCurrentStack(list.get(0), debugSession);
        }
    }

    public static void updateWatchView(DebugSession debugSession) {
        Watch[] watchArray;
        for (Watch watch : watchArray = DebuggerManager.getDebuggerManager().getWatches()) {
            String string = watch.getExpression();
            EvalCommand evalCommand = new EvalCommand(debugSession.getTransactionId());
            evalCommand.setData(string);
            debugSession.sendCommandLater(evalCommand);
        }
    }

    private void requestContextNames(DebugSession debugSession) {
        ContextNamesCommand contextNamesCommand = new ContextNamesCommand(debugSession.getTransactionId());
        debugSession.sendCommandLater(contextNamesCommand);
    }

    private void annotateStackTrace(DebugSession debugSession, List<Stack> list) {
        debugSession.getBridge().hideAnnotations();
        for (Stack stack : list) {
            int n = stack.getLevel();
            int n2 = stack.getLine();
            Line line = Utils.getLine(n2 > 0 ? n2 : 1, stack.getFileName(), debugSession.getSessionId());
            if (line == null) continue;
            if (n == 0) {
                debugSession.getBridge().showCurrentDebuggerLine(line);
                continue;
            }
            debugSession.getBridge().annotate(new CallStackAnnotation((Annotatable)line));
        }
    }
}

