/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api.ui;

import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.api.project.Project;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactViewerFactory;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactViewer {
    public static final String HINT_ARTIFACT = "art";
    public static final String HINT_PROJECT = "prj";
    public static final String HINT_DEPENDENCIES = "dep";
    public static final String HINT_GRAPH = "grf";

    private ArtifactViewer() {
    }

    public static void showArtifactViewer(NBVersionInfo nBVersionInfo, String string) {
        ArtifactViewer.showArtifactViewer(null, nBVersionInfo, null, null, string);
    }

    public static void showArtifactViewer(NBVersionInfo nBVersionInfo) {
        ArtifactViewer.showArtifactViewer(null, nBVersionInfo, null, null, null);
    }

    public static void showArtifactViewer(Artifact artifact, List<ArtifactRepository> list, String string) {
        ArtifactViewer.showArtifactViewer(null, null, artifact, list, string);
    }

    public static void showArtifactViewer(Artifact artifact, List<ArtifactRepository> list) {
        ArtifactViewer.showArtifactViewer(null, null, artifact, list, null);
    }

    public static void showArtifactViewer(Project project, String string) {
        ArtifactViewer.showArtifactViewer(project, null, null, null, string);
    }

    private static void showArtifactViewer(Project project, NBVersionInfo nBVersionInfo, Artifact artifact, List<ArtifactRepository> list, String string) {
        ArtifactViewerFactory artifactViewerFactory = (ArtifactViewerFactory)Lookup.getDefault().lookup(ArtifactViewerFactory.class);
        if (artifactViewerFactory == null) {
            Logger.getLogger(ArtifactViewer.class.getName()).info("No implementation of ArtifactViewerFactory available.");
            return;
        }
        TopComponent topComponent = project != null ? artifactViewerFactory.createTopComponent(project) : (nBVersionInfo != null ? artifactViewerFactory.createTopComponent(nBVersionInfo) : artifactViewerFactory.createTopComponent(artifact, list));
        topComponent.open();
        topComponent.requestActive();
        if (string != null) {
            MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
            if (multiViewHandler == null) {
                return;
            }
            for (MultiViewPerspective multiViewPerspective : multiViewHandler.getPerspectives()) {
                if (!string.equals(multiViewPerspective.preferredID())) continue;
                multiViewHandler.requestVisible(multiViewPerspective);
                return;
            }
        }
    }
}

