/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VariablesViewButtons {
    public static final String PREFERENCES_NAME = "variables_view";
    public static final String SHOW_AUTOS = "show_autos";
    private static JToggleButton showAutosToggle = null;

    public static synchronized JToggleButton createShowAutosButton() {
        if (showAutosToggle != null) {
            return showAutosToggle;
        }
        showAutosToggle = VariablesViewButtons.createToggleButton(SHOW_AUTOS, "org/netbeans/modules/cnd/debugger/gdb/resources/autos.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Autos"));
        showAutosToggle.addActionListener(new ShowAutosActionListener(showAutosToggle));
        return showAutosToggle;
    }

    private static JToggleButton createToggleButton(String string, String string2, String string3) {
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)string2, (boolean)false);
        boolean bl = VariablesViewButtons.isButtonSelected(string);
        JToggleButton jToggleButton = new JToggleButton(imageIcon, bl);
        Dimension dimension = new Dimension(imageIcon.getIconWidth() + 8, imageIcon.getIconHeight() + 8);
        jToggleButton.setPreferredSize(dimension);
        jToggleButton.setMargin(new Insets(1, 1, 1, 1));
        jToggleButton.setToolTipText(string3);
        jToggleButton.setFocusable(false);
        return jToggleButton;
    }

    public static boolean isShowAutos() {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_AUTOS, true);
    }

    private static boolean isButtonSelected(String string) {
        if (string.equals(SHOW_AUTOS)) {
            return VariablesViewButtons.isShowAutos();
        }
        return false;
    }

    private static void setButtonSelected(String string, boolean bl) {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        preferences.putBoolean(string, bl);
    }

    private static class ShowAutosActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowAutosActionListener(JToggleButton jToggleButton) {
            this.button = jToggleButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_AUTOS, bl);
        }
    }
}

