/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.cnd.debugger.gdb.attach.GdbAttachPanel;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class SelectCorePanel
extends JPanel {
    private final JButton okButton;
    private JButton coreBrowseButton;
    private JTextField corePathText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox projectCB;

    public SelectCorePanel(JButton jButton) {
        this.okButton = jButton;
        this.initComponents();
        GdbAttachPanel.fillProjectsCombo(this.projectCB);
        this.corePathText.getDocument().addDocumentListener(new GdbAttachPanel.AnyChangeDocumentListener(){

            public void documentChanged(DocumentEvent documentEvent) {
                SelectCorePanel.this.setValid();
            }
        });
        this.setValid();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.corePathText = new JTextField();
        this.coreBrowseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.projectCB = new JComboBox();
        this.jLabel1.setText(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.jLabel1.text"));
        this.coreBrowseButton.setText(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.coreBrowseButton.text"));
        this.coreBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectCorePanel.this.coreBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.jLabel2.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.corePathText, -2, 337, -2).addPreferredGap(0).add((Component)this.coreBrowseButton)).add((Component)this.projectCB, 0, 429, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.corePathText, -2, -1, -2).add((Component)this.coreBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.projectCB, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void coreBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = new FileChooserBuilder(SelectCorePanel.class).setTitle(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.coreBrowse.title")).setFilesOnly(true).showOpenDialog();
        if (file != null) {
            this.corePathText.setText(file.getAbsolutePath());
        }
    }

    public String getCorePath() {
        return this.corePathText.getText();
    }

    private void setValid() {
        String string = this.corePathText.getText();
        this.okButton.setEnabled(string != null && string.length() > 0 && this.projectCB.getSelectedItem() != null);
    }

    public ProjectInformation getProjectInformation() {
        GdbAttachPanel.ProjectCBItem projectCBItem = (GdbAttachPanel.ProjectCBItem)this.projectCB.getSelectedItem();
        if (projectCBItem == null) {
            return null;
        }
        return projectCBItem.getProjectInformation();
    }
}

