/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.timer;

public class TimerRecord {
    private final RecordType type;
    private final long time;
    private final String message;

    public TimerRecord(RecordType recordType, String string) {
        this.type = recordType;
        this.time = System.currentTimeMillis();
        this.message = string != null && string.length() > 0 ? string + ": " : "";
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return this.toString(-1L);
    }

    public String toString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == RecordType.Title) {
            stringBuilder.append("\n\nGdbTimer Report: " + this.message);
        } else {
            stringBuilder.append("    ");
            stringBuilder.append(this.message);
            if (this.type == RecordType.Start) {
                stringBuilder.append("Started at ");
            } else if (this.type == RecordType.Mark) {
                stringBuilder.append("Marked at ");
            } else if (this.type == RecordType.Stop) {
                stringBuilder.append("Stopped at ");
            } else if (this.type == RecordType.Restart) {
                stringBuilder.append("Restarteded at ");
            }
            if (l < 0L) {
                stringBuilder.append(this.time);
            } else {
                stringBuilder.append(this.time - l);
                stringBuilder.append(" ms");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RecordType {
        Title,
        Start,
        Mark,
        Stop,
        Restart;

    }
}

