/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class WatchesTreeModel
implements TreeModel,
PropertyChangeListener {
    private final GdbDebugger debugger;
    private Listener listener;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private final Map<Watch, AbstractVariable> watchToVariable = new WeakHashMap<Watch, AbstractVariable>();
    private static final Logger log = Logger.getLogger("gdb.logger");

    public WatchesTreeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("var_value".equals(propertyChangeEvent.getPropertyName())) {
            this.fireNodeChanged(propertyChangeEvent.getSource());
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            n2 = Math.min(watchArray.length, n2);
            n = Math.min(watchArray.length, n);
            Watch[] watchArray2 = new Watch[n2 - n];
            System.arraycopy(watchArray, n, watchArray2, 0, n2 - n);
            int n3 = watchArray2.length;
            Object[] objectArray = new AbstractVariable[n3];
            for (int i = 0; i < n3; ++i) {
                AbstractVariable abstractVariable = this.watchToVariable.get(watchArray2[i]);
                if (abstractVariable == null) {
                    abstractVariable = new GdbWatchVariable(this.debugger, watchArray2[i]);
                    this.watchToVariable.put(watchArray2[i], abstractVariable);
                    abstractVariable.addPropertyChangeListener(this);
                }
                objectArray[i] = abstractVariable;
            }
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return objectArray;
        }
        if (object instanceof AbstractVariable) {
            return ((AbstractVariable)object).getFields();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Watch) {
            return true;
        }
        if (object instanceof AbstractVariable) {
            return ((AbstractVariable)object).getFieldsCount() == 0;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return Integer.MAX_VALUE;
        }
        if (object instanceof AbstractVariable) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTreeChanged() {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableValueChanged(Object object, String string) {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object object) {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, object));
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private final WeakReference<WatchesTreeModel> model;
        private final WeakReference<GdbDebugger> debugger;
        private RequestProcessor.Task task;

        private Listener(WatchesTreeModel watchesTreeModel, GdbDebugger gdbDebugger) {
            this.model = new WeakReference<WatchesTreeModel>(watchesTreeModel);
            this.debugger = new WeakReference<GdbDebugger>(gdbDebugger);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            gdbDebugger.addPropertyChangeListener(this);
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            int n = watchArray.length;
            for (int i = 0; i < n; ++i) {
                watchArray[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesTreeModel getModel() {
            WatchesTreeModel watchesTreeModel = (WatchesTreeModel)this.model.get();
            if (watchesTreeModel == null) {
                this.destroy();
            }
            return watchesTreeModel;
        }

        public void watchAdded(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireTreeChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            Object v = watchesTreeModel.watchToVariable.remove(watch);
            if (v != null && v instanceof GdbWatchVariable) {
                ((GdbWatchVariable)v).remove();
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireTreeChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("watches".equals(string)) {
                return;
            }
            final WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            if (watchesTreeModel.debugger.getState() == GdbDebugger.State.EXITED) {
                this.destroy();
                return;
            }
            if (watchesTreeModel.debugger.getState() == GdbDebugger.State.RUNNING) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Watch) {
                Object v;
                Map map = watchesTreeModel.watchToVariable;
                synchronized (map) {
                    v = watchesTreeModel.watchToVariable.get((Watch)propertyChangeEvent.getSource());
                }
                if (v != null) {
                    if (v instanceof AbstractVariable && ((AbstractVariable)v).getFieldsCount() > 0) {
                        watchesTreeModel.fireTreeChanged();
                    } else {
                        watchesTreeModel.fireTableValueChanged(v, null);
                    }
                    return;
                }
            }
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        watchesTreeModel.fireTreeChanged();
                    }
                });
            }
            this.task.schedule(100);
        }

        private void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            GdbDebugger gdbDebugger = (GdbDebugger)this.debugger.get();
            if (gdbDebugger != null) {
                gdbDebugger.removePropertyChangeListener(this);
            }
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            int n = watchArray.length;
            for (int i = 0; i < n; ++i) {
                watchArray[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

