/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.gdb.Field;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbErrorException;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.TypeInfo;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVariable
implements LocalVariable {
    public static final String PROP_VALUE = "var_value";
    private final GdbDebugger debugger;
    protected String value = null;
    protected final List<Field> fields = new CopyOnWriteArrayList<Field>();
    protected TypeInfo tinfo = null;
    private static final Logger log = Logger.getLogger("gdb.logger");
    private final Set<PropertyChangeListener> listeners = Collections.synchronizedSet(new HashSet());

    public AbstractVariable(GdbDebugger gdbDebugger, String string) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        assert (!SwingUtilities.isEventDispatchThread());
        this.debugger = gdbDebugger;
        this.value = Utilities.getOperatingSystem() != 4096 ? string : GdbUtils.mackHack(string);
    }

    protected TypeInfo getTypeInfo() {
        if (this.tinfo == null) {
            this.tinfo = TypeInfo.getTypeInfo(this.getDebugger(), this);
        }
        return this.tinfo;
    }

    protected void emptyFields() {
        for (Field field : this.fields) {
            if (!(field instanceof AbstractField)) continue;
            this.getDebugger().removePropertyChangeListener("valueChanged", (AbstractField)field);
        }
        this.fields.clear();
    }

    @Override
    public String getValue() {
        if (this.value != null && this.value.length() > 0) {
            if (this.value.charAt(0) == '>' && this.value.endsWith(".\"<")) {
                return '>' + this.value.substring(2, this.value.length() - 3).replace("\\\"", "\"") + '<';
            }
            return this.value.replace("\\\"", "\"");
        }
        return "";
    }

    protected String getResolvedType() {
        return this.getTypeInfo().getResolvedType(this);
    }

    @Override
    public void setValue(String string) {
        Object object;
        if (string.equals(this.value)) {
            return;
        }
        String string2 = null;
        String string3 = this.getResolvedType();
        if (this.getDebugger() != null) {
            int n;
            if ((string = string.trim()).length() > 0 && string.charAt(0) == '(' && (n = GdbUtils.findMatchingParen(string, 0)) != -1) {
                string = string.substring(n + 1).trim();
            }
            if (string3.equals("char") || string3.equals("unsigned char")) {
                if ((string = AbstractVariable.setValueChar(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char");
                }
            } else if (string3.equals("char *") || string3.equals("unsigned char *") || string3.equals("const char *")) {
                if (string.replace("\"", "\\\"").equals(this.value)) {
                    return;
                }
                if ((string = AbstractVariable.setValueCharStar(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char*");
                }
            } else if (string3.equals("int") || string3.equals("long")) {
                if ((string = AbstractVariable.setValueNumber(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Number");
                }
            } else if (string3.equals("bool") || !this.debugger.isCplusPlus() && string3.equals("_Bool")) {
                if (!(string.equals("true") || string.equals("false") || AbstractVariable.isNumberInRange(string, 0L, 1L))) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_CplusPlus_Bool");
                }
            } else if (string3.startsWith("enum ")) {
                if ((string = this.setValueEnum(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Enum");
                }
            } else if (string.charAt(0) == '\"' || string.startsWith("0x") && string.endsWith("\"")) {
                if (string.replace("\"", "\\\"").equals(this.value)) {
                    return;
                }
                if ((string = AbstractVariable.setValueCharStar(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char*");
                }
            } else if (GdbUtils.isPointer(string3)) {
                // empty if block
            }
            if (string != null && string.charAt(0) == '(' && (n = GdbUtils.findMatchingParen(string, 0)) != -1) {
                string = string.substring(n + 1).trim();
            }
            if (string2 == null) {
                object = this instanceof GdbWatchVariable ? ((GdbWatchVariable)this).getWatch().getExpression() : this.getFullName();
                if (!this.debugger.isCplusPlus() && string3.equals("_Bool") && !AbstractVariable.isNumber(string)) {
                    string = string.equals("true") ? "1" : "0";
                }
                this.value = this.getDebugger().updateVariable((String)object, string);
                if (this instanceof AbstractField) {
                    AbstractVariable abstractVariable = ((AbstractField)this).parent;
                    while (abstractVariable instanceof AbstractField) {
                        abstractVariable.value = this.getDebugger().requestValue(abstractVariable.getFullName());
                        this.getDebugger().variableChanged(abstractVariable);
                        abstractVariable = ((AbstractField)abstractVariable).parent;
                    }
                    abstractVariable.value = this.getDebugger().requestValue(abstractVariable.getName());
                    this.getDebugger().variableChanged(abstractVariable);
                    this.getDebugger().updateGdbVariable(abstractVariable.getName(), abstractVariable.value);
                }
                this.getDebugger().variableChanged(this);
            }
        }
        if (string2 != null) {
            object = new NotifyDescriptor.Message(string2);
            object.setTitle(NbBundle.getMessage(AbstractVariable.class, (String)"TITLE_SetValue_Warning"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
        }
    }

    private synchronized void setModifiedValue(String string) {
        String string2 = this.value;
        this.value = string;
        if (this.fields.size() > 0) {
            this.emptyFields();
            if (string.length() > 0) {
                this.expandChildren();
            }
        }
        this.notifyValueChanged(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyValueChanged(String string, String string2) {
        ArrayList<PropertyChangeListener> arrayList;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_VALUE, string, string2);
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            arrayList = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    private static String setValueChar(String string) {
        int n;
        if (string.startsWith("0x") && (n = string.indexOf(" '")) != -1 && string.endsWith("'")) {
            string = string.substring(n + 1);
        } else if (string.charAt(0) != '\'' || string.charAt(string.length() - 1) != '\'') {
            string = null;
        }
        return string;
    }

    private static String setValueCharStar(String string) {
        int n;
        string = string.startsWith("0x") && (n = string.indexOf(" \\\"")) != -1 && string.endsWith("\\\"") ? '\"' + string.substring(n + 3, string.length() - 2) + '\"' : (string.startsWith("0x") && (n = string.indexOf(" \"")) != -1 && string.endsWith("\"") ? string.substring(n + 1).replace("\"", "\\\"") : (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' ? string.replace("\"", "\\\"") : null));
        return string;
    }

    private String setValueEnum(String string) {
        block3: {
            int n;
            int n2;
            String string2;
            block2: {
                string2 = this.getResolvedType();
                n2 = string2.indexOf(123);
                n = string2.indexOf(125);
                if (n2 <= 0 || n <= 0) break block2;
                String string3 = string2.substring(n2 + 1, n);
                for (String string4 : string3.split(", ")) {
                    if (!string.equals(string4)) continue;
                    return string;
                }
                break block3;
            }
            string2 = this.getTypeInfo().getDetailedType(this);
            n2 = string2.indexOf(123);
            n = string2.indexOf(125);
            if (n2 <= 0 || n <= 0) break block3;
            String string5 = string2.substring(n2 + 1, n);
            for (String string6 : string5.split(", ")) {
                if (!string.equals(string6)) continue;
                return string;
            }
        }
        return null;
    }

    private static String setValueNumber(String string) {
        if (!AbstractVariable.isNumber(string)) {
            string = null;
        }
        return string;
    }

    public int getFieldsCount() {
        if (this.getDebugger() == null || !this.getDebugger().isStopped()) {
            return 0;
        }
        if (this.fields.size() > 0) {
            return this.fields.size();
        }
        if (this.mightHaveFields()) {
            return this.estimateFieldCount();
        }
        return 0;
    }

    private boolean mightHaveFields() {
        this.getValue();
        String string = this.getResolvedType();
        if (string != null && string.length() > 0) {
            if (GdbUtils.isArray(string) && !AbstractVariable.isCharString(string) && this.value != null && this.value.length() > 0) {
                return true;
            }
            if (this.isValidPointerAddress()) {
                return !GdbUtils.isFunctionPointer(string) && !string.equals("void *") && (!AbstractVariable.isCharString(string) || GdbUtils.isMultiPointer(string));
            }
        }
        return this.value != null && this.value.length() > 0 && (this.value.charAt(0) == '{' || this.value.charAt(this.value.length() - 1) == '}');
    }

    private int estimateFieldCount() {
        return 100;
    }

    private boolean isValidPointerAddress() {
        String string = "";
        if (this.value != null) {
            if (this.value.length() > 0 && this.value.charAt(0) == '(') {
                int n = this.value.indexOf("*) 0x");
                if (n == -1) {
                    n = this.value.indexOf("* const) 0x");
                    if (n != -1) {
                        string = this.value.substring(n + 11);
                    }
                } else {
                    string = this.value.substring(n + 5);
                }
                if (n != -1) {
                    long l;
                    try {
                        l = Long.parseLong(string, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return l > 0L;
                }
            } else if (this.value.startsWith("0x")) {
                long l;
                try {
                    l = Long.parseLong(this.value.substring(2), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return l > 0L;
            }
        }
        return false;
    }

    public Field[] getFields() {
        if (this.fields.size() == 0) {
            this.expandChildren();
        }
        return this.fields.toArray(new Field[this.fields.size()]);
    }

    protected final GdbDebugger getDebugger() {
        return this.debugger;
    }

    private synchronized boolean expandChildren() {
        if (this.fields.size() == 0) {
            this.createChildren();
        }
        return this.fields.size() > 0;
    }

    private void createChildren() {
        String string = this.getResolvedType();
        String string2 = null;
        String string3 = null;
        this.getValue();
        if (GdbUtils.isPointer(string) && !AbstractVariable.isCharString(string) && !GdbUtils.isMultiPointer(string)) {
            if (this.value.endsWith(" 0") || this.value.endsWith(" 0x0")) {
                string2 = null;
                string3 = null;
            } else {
                string2 = GdbUtils.getBaseType(string);
                try {
                    string3 = this.getDebugger().requestValueEx('*' + this.getFullName(false));
                }
                catch (GdbErrorException gdbErrorException) {
                    this.fields.add(new ErrorField(gdbErrorException.getMessage()));
                    return;
                }
            }
        } else {
            string2 = string;
            string3 = this.value;
        }
        if (string3 != null) {
            if (GdbUtils.isArray(string2)) {
                this.createChildrenForArray(string2, string3);
            } else if (GdbUtils.isMultiPointer(string2)) {
                this.createChildrenForMultiPointer(string2);
            } else {
                Map<String, Object> map = this.getTypeInfo().getMap();
                if (map != null) {
                    if (string3.indexOf(123) == -1) {
                        this.fields.add(new AbstractField(this, '*' + this.getName(), string2, string3));
                    } else if (string3.equals("<incomplete type>")) {
                        this.fields.add(new AbstractField(this, "", string2, string3));
                    } else if (string3.length() > 0) {
                        int n = string3.indexOf(123);
                        assert (n != -1);
                        String string4 = string3.substring(n + 1, string3.length() - 1);
                        int n2 = 0;
                        int n3 = GdbUtils.findNextComma(string4, 0);
                        int n4 = 1;
                        while (n3 != -1) {
                            String string5 = string4.substring(n2, n3).trim();
                            n4 = this.completeFieldDefinition(this, map, string5, n4);
                            n2 = n3 + 1;
                            n3 = GdbUtils.findNextComma(string4, n3 + 1);
                        }
                        this.completeFieldDefinition(this, map, string4.substring(n2).trim(), n4);
                    } else {
                        log.fine("AV.createChildren: 0 length value for " + this.getFullName(false));
                    }
                }
            }
        }
    }

    private void createChildrenForMultiPointer(String string) {
        int n = 0;
        String string2 = this.getFullName(false);
        String string3 = string.substring(0, string.length() - 1);
        int n2 = string3.startsWith("char *") ? 20 : 10;
        int n3 = GdbUtils.log10(n2 - 1);
        while (n2-- > 0) {
            String string4 = this.getDebugger().requestValue(string2 + '[' + n + ']');
            if (string4 == null || string4.length() < 1 || string4.endsWith("0x0")) {
                return;
            }
            this.fields.add(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(n3, n++), string3, string4));
        }
    }

    private static boolean isCharString(String string) {
        return string != null && string.endsWith("*") && !string.endsWith("**") && ((string = GdbUtils.getBaseType(string)).equals("char") || string.equals("unsigned char"));
    }

    private int completeFieldDefinition(AbstractVariable abstractVariable, Map<String, Object> map, String string, int n) {
        if (string.charAt(0) == '{') {
            Map map2 = (Map)map.get("<anonymous" + n + ">");
            if (map2 != null) {
                String string2 = (String)map2.get("<name>");
                this.fields.add(new AbstractField(abstractVariable, "", string2, string));
                return ++n;
            }
            log.warning("GdbDebugger.completeFieldDefinition: Missing type information for " + string);
        } else {
            int n2 = string.indexOf(61);
            if (n2 != -1) {
                String string3;
                String string4;
                String string5;
                if (string.charAt(0) == '<') {
                    string5 = NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass");
                    string4 = string.substring(1, n2 - 2).trim();
                    string3 = string.substring(n2 + 1).trim();
                    if (string4.length() == 0) {
                        string4 = (String)map.get("<super1>");
                    }
                    if (string5.startsWith("_vptr")) {
                        return n;
                    }
                } else {
                    string5 = string.substring(0, n2 - 1).trim();
                    string3 = string.substring(n2 + 1).trim();
                    if (string5.startsWith("_vptr")) {
                        return n;
                    }
                    Object object = map.get(string5);
                    if (object instanceof String) {
                        string4 = object.toString();
                    } else if (object instanceof Map) {
                        string4 = (String)((Map)object).get("<name>");
                        if (string4 == null) {
                            log.warning("GdbDebugger.completeFieldDefinition: Missing <name> from map");
                            return n;
                        }
                    } else if (AbstractVariable.isNumber(string3)) {
                        string4 = "int";
                    } else {
                        log.warning("Cannot determine field type for " + string5);
                        return n;
                    }
                }
                this.fields.add(new AbstractField(abstractVariable, string5, string4, string3));
            } else if (string.trim().equals("<No data fields>")) {
                this.fields.add(new AbstractField(abstractVariable, "", "", string.trim()));
            }
        }
        return n;
    }

    private static void parseCharArray(AbstractVariable abstractVariable, String string, String string2, int n, String string3) {
        int n2 = 0;
        boolean bl = false;
        int n3 = GdbUtils.log10(n - 1);
        while (n2 < string3.length()) {
            String string4;
            int n4;
            if (string3.substring(n2).startsWith("\\\"")) {
                String string5;
                n4 = string3.indexOf("\\\",", n2);
                if (n4 >= 0) {
                    string4 = string3.substring(n2 + 2, n4);
                    n2 += string4.length() + 4;
                } else {
                    if (string3.endsWith("\\\"...")) {
                        string4 = string3.substring(n2 + 2, string3.length() - 5);
                        bl = true;
                    } else {
                        string4 = string3.substring(n2 + 2, string3.length() - 2);
                    }
                    n2 = string3.length();
                }
                AbstractVariable.parseCharArrayFragment(abstractVariable, string, string2, n3, string4);
                if (abstractVariable.fields.size() < n && n2 >= string3.length()) {
                    abstractVariable.fields.add(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n3, n - 1), string2.substring(0, string2.indexOf(91)).trim(), "'\\000'"));
                }
                if (!bl) continue;
                try {
                    string5 = string2.substring(string2.indexOf(91) + 1, string2.indexOf(93));
                    Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    string5 = "...";
                }
                abstractVariable.fields.add(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n3, abstractVariable.fields.size(), "-" + string5), "", "..."));
                continue;
            }
            if (string3.charAt(n2) == ' ' || string3.charAt(n2) == ',') {
                ++n2;
                continue;
            }
            n4 = GdbUtils.findNextComma(string3, n2);
            string4 = n4 > 0 ? string3.substring(n2, n4) : string3.substring(n2);
            AbstractVariable.parseRepeatArrayFragment(abstractVariable, string, string2, n3, string4);
            n2 += string4.length();
        }
    }

    private static void parseRepeatArrayFragment(AbstractVariable abstractVariable, String string, String string2, int n, String string3) {
        int n2;
        String string4 = string2.substring(0, string2.indexOf(91)).trim();
        int n3 = abstractVariable.fields.size();
        int n4 = string3.indexOf(32);
        String string5 = string3.substring(0, n4).replace("\\\\", "\\");
        int n5 = string3.indexOf("<repeats ");
        int n6 = string3.indexOf(" times>");
        try {
            n2 = Integer.parseInt(string3.substring(n5 + 9, n6));
        }
        catch (Exception exception) {
            return;
        }
        while (--n2 >= 0) {
            abstractVariable.fields.add(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n, n3++), string4, string5));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseCharArrayFragment(AbstractVariable abstractVariable, String string, String string2, int n, String string3) {
        String string4 = string2.substring(0, string2.indexOf(91)).trim();
        int n2 = 0;
        string3 = string3.replace("\\\\", "\\");
        int n3 = string3.length();
        int n4 = abstractVariable.fields.size();
        while (true) {
            String string5;
            block8: {
                int n5;
                StringBuilder stringBuilder;
                char c;
                block12: {
                    block11: {
                        int n6;
                        block9: {
                            block10: {
                                if (n2 >= n3) {
                                    return;
                                }
                                n6 = n2;
                                if ((c = string3.charAt(n2++)) != '\\' || n2 >= n3) break block9;
                                if ((c = string3.charAt(n2++)) < '0' || c > '7') break block10;
                                stringBuilder = new StringBuilder();
                                stringBuilder.append('\\');
                                stringBuilder.append(c);
                                break block11;
                            }
                            if (c == 'x' || c == 'X') {
                                stringBuilder = new StringBuilder();
                                stringBuilder.append('\\');
                                stringBuilder.append(c);
                                break block12;
                            } else if (string3.substring(n2 - 1, n2).matches("['\"?abfnrt]") || c == '\\') {
                                string5 = '\\' + string3.substring(n2 - 1, n2);
                                break block8;
                            } else {
                                log.warning("AV.parseCharArrayFragment: Ignoring invalid character array fragment");
                                continue;
                            }
                        }
                        string5 = string3.substring(n6, n2);
                        break block8;
                    }
                    for (n5 = 0; n5 < 2 && n2 < n3 && (c = string3.charAt(n2)) >= '0' && c <= '7'; ++n2, ++n5) {
                        stringBuilder.append(c);
                    }
                    string5 = stringBuilder.toString();
                    break block8;
                }
                for (n5 = 0; !(n5 >= 2 || n2 >= n3 || (c = string3.charAt(n2)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F'); ++n2, ++n5) {
                    stringBuilder.append(c);
                }
                string5 = stringBuilder.toString();
            }
            abstractVariable.fields.add(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n, n4++), string4, '\'' + string5 + '\''));
        }
    }

    private void createChildrenForArray(String string, String string2) {
        int n;
        int n2;
        if (string2.length() == 0) {
            return;
        }
        int n3 = string.lastIndexOf(125);
        if (n3 == -1) {
            n2 = string.indexOf(91);
        } else {
            n2 = string.indexOf(91, n3);
            n3 = string.indexOf(123);
        }
        int n4 = GdbUtils.findMatchingBrace(string, n2);
        assert (n4 != -1);
        int n5 = 0;
        int n6 = string.indexOf(91, n4);
        String string3 = n6 == -1 ? "" : string.substring(n6);
        String string4 = n3 == -1 ? string.substring(0, n2).trim() + string3 : string.substring(0, n3).trim() + string3;
        try {
            n = Integer.valueOf(string.substring(n2 + 1, n4));
        }
        catch (Exception exception) {
            n = 0;
        }
        if (string4.equals("char") || string4.equals("unsigned char")) {
            AbstractVariable.parseCharArray(this, this.getName(), string, n, string2);
        } else {
            string2 = string2.substring(1, string2.length() - 1);
            int n7 = GdbUtils.log10(n - 1);
            for (int i = 0; i < n && n5 != -1; ++i) {
                int n8 = string2.charAt(n5) == '{' ? GdbUtils.findNextComma(string2, GdbUtils.findMatchingCurly(string2, n5)) : GdbUtils.findNextComma(string2, n5);
                this.fields.add(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(n7, i), string4, n8 == -1 ? string2.substring(n5) : string2.substring(n5, n8)));
                n5 = GdbUtils.firstNonWhite(string2, n8 + 1);
            }
        }
    }

    private static String getIndexStr(int n, int n2) {
        return AbstractVariable.getIndexStr(n, n2, "");
    }

    private static String getIndexStr(int n, int n2, String string) {
        int n3 = n - GdbUtils.log10(n2);
        String string2 = n2 + string;
        if (n3 > 0) {
            string2 = GdbUtils.zeros(n3) + string2;
        }
        return "[" + string2 + "]";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    protected final void onValueChange(PropertyChangeEvent propertyChangeEvent) {
        assert ("valueChanged".equals(propertyChangeEvent.getPropertyName()));
        assert (propertyChangeEvent.getNewValue() instanceof AbstractVariable);
        AbstractVariable abstractVariable = (AbstractVariable)propertyChangeEvent.getNewValue();
        if (abstractVariable != this && abstractVariable.getFullName().equals(this.getFullName())) {
            if (abstractVariable instanceof AbstractField) {
                final AbstractVariable abstractVariable2 = ((AbstractField)this).getAncestor();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        abstractVariable2.updateVariable();
                    }
                });
            } else {
                this.setModifiedValue(abstractVariable.getValue());
            }
        }
    }

    private void updateVariable() {
        this.value = this.getDebugger().requestValue("\"" + this.getName() + "\"");
        this.setModifiedValue(this.value);
    }

    public String toString() {
        return this.getFullName(false);
    }

    private static boolean isNumber(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isNumberInRange(String string, long l, long l2) {
        try {
            long l3 = Long.parseLong(string);
            return l3 >= l && l3 <= l2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public final String getFullName() {
        return this.getFullName(false);
    }

    protected String getFullName(boolean bl) {
        return this.getName();
    }

    public static class ErrorField
    implements Field {
        private final String msg;

        public ErrorField(String string) {
            this.msg = string.substring(1, string.length() - 1);
        }

        public String getName() {
            return NbBundle.getMessage(AbstractVariable.class, (String)"LBL_Error");
        }

        public void setValue(String string) {
            throw new UnsupportedOperationException("Not supported");
        }

        public String getType() {
            return "";
        }

        public String getValue() {
            return this.msg;
        }
    }

    private static class AbstractField
    extends AbstractVariable
    implements Field,
    PropertyChangeListener {
        private AbstractVariable parent;
        private final String name;
        private final String type;

        public AbstractField(AbstractVariable abstractVariable, String string, String string2, String string3) {
            super(abstractVariable.debugger, null);
            assert (string != null) : "AbstractField with null name";
            this.name = string.startsWith("static ") ? string.substring(7) : string;
            if (string2 == null) {
                this.type = "";
            } else {
                int n = string2.indexOf(123);
                if (n == -1) {
                    this.type = string2;
                } else {
                    int n2 = string2.indexOf(125, n);
                    this.type = string2.substring(0, n).trim() + string2.substring(n2 + 1);
                }
            }
            this.parent = abstractVariable;
            this.value = Utilities.getOperatingSystem() == 4096 ? GdbUtils.mackHack(string3) : string3;
            abstractVariable.debugger.addPropertyChangeListener("valueChanged", this);
        }

        protected AbstractVariable getAncestor() {
            if (this.parent instanceof AbstractField) {
                return ((AbstractField)this.parent).getAncestor();
            }
            return this.parent;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        protected String getFullName(boolean bl) {
            int n;
            String string;
            if (this.parent instanceof AbstractField) {
                string = ((AbstractField)this.parent).getFullName(bl);
            } else {
                string = this.parent.getName();
                if (string.charAt(0) == '*') {
                    string = '(' + string + ')';
                }
            }
            String string2 = this.name.equals(NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass")) ? (bl ? string + ".<" + this.type + ">" : string) : (this.name.indexOf(91) != -1 ? ((n = string.lastIndexOf(46)) != -1 ? string.substring(0, n) + '.' + this.name : this.name) : (GdbUtils.isSimplePointer(this.parent.getType()) && this.name.charAt(0) == '*' ? '*' + string : (GdbUtils.isPointer(this.parent.getType()) ? string + "->" + this.name : (this.name.length() > 0 ? string + '.' + this.name : string))));
            return string2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.onValueChange(propertyChangeEvent);
        }
    }
}

