/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.ActionsPanel;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.ConditionsPanel;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class FunctionBreakpointPanel
extends JPanel
implements Controller {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private FunctionBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel lFunctionName;
    private JPanel pActions;
    private JPanel pConditions;
    private JPanel pSettings;
    private JTextField tfFunctionName;

    private static FunctionBreakpoint createBreakpoint() {
        FunctionBreakpoint functionBreakpoint = FunctionBreakpoint.create("main");
        functionBreakpoint.setPrintText(NbBundle.getBundle(FunctionBreakpointPanel.class).getString("CTL_Function_Breakpoint_Print_Text"));
        return functionBreakpoint;
    }

    public FunctionBreakpointPanel() {
        this(FunctionBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public FunctionBreakpointPanel(FunctionBreakpoint functionBreakpoint) {
        this.breakpoint = functionBreakpoint;
        this.initComponents();
        this.tfFunctionName.setText(functionBreakpoint.getFunctionName());
        this.conditionsPanel = new ConditionsPanel(functionBreakpoint);
        this.pConditions.add(this.conditionsPanel);
        this.actionsPanel = new ActionsPanel(functionBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.lFunctionName = new JLabel();
        this.tfFunctionName = new JTextField();
        this.pConditions = new JPanel();
        this.pActions = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Function_Breakpoint_BorderTitle")));
        this.pSettings.setMinimumSize(new Dimension(249, 80));
        this.pSettings.setLayout(new GridBagLayout());
        this.lFunctionName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Function_Breakpoint_Function_Name").charAt(0));
        this.lFunctionName.setLabelFor(this.tfFunctionName);
        this.lFunctionName.setText(resourceBundle.getString("L_Function_Breakpoint_Function_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lFunctionName, gridBagConstraints);
        this.lFunctionName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Function_Breakpoint_Function_Name"));
        this.tfFunctionName.setToolTipText(resourceBundle.getString("TTT_TF_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFunctionName, gridBagConstraints);
        this.tfFunctionName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_TF_Function_Breakpoint_Function_Name"));
        this.tfFunctionName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pConditions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pConditions, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.conditionsPanel.ok();
        this.actionsPanel.ok();
        String string2 = this.tfFunctionName.getText().trim();
        this.breakpoint.setFunctionName(string2);
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            String string3;
            FunctionBreakpoint functionBreakpoint;
            if (!(breakpointArray[i] instanceof FunctionBreakpoint) || !string2.equals((functionBreakpoint = (FunctionBreakpoint)breakpointArray[i]).getFunctionName()) || ((string3 = this.breakpoint.getCondition()) == null ? functionBreakpoint.getCondition() != null : !string3.equals(functionBreakpoint.getCondition()))) continue;
            if (!functionBreakpoint.isEnabled()) {
                breakpointArray[i].enable();
            }
            return true;
        }
        if (this.createBreakpoint) {
            debuggerManager.addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private String valiadateMsg() {
        String string = this.tfFunctionName.getText().trim();
        if (string.length() == 0) {
            return NbBundle.getBundle(FunctionBreakpointPanel.class).getString("MSG_No_Function_Name_Spec");
        }
        return null;
    }
}

