/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerOutput;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.IOManager;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.event.GdbBreakpointEvent;
import org.netbeans.modules.cnd.debugger.gdb.event.GdbBreakpointListener;
import org.netbeans.modules.cnd.debugger.gdb.models.BreakpointsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
GdbBreakpointListener,
PropertyChangeListener {
    private static final Pattern fileNamePattern = Pattern.compile("\\{fileName\\}");
    private static final Pattern functionNamePattern = Pattern.compile("\\{functionName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private IOManager ioManager;
    private GdbDebugger debugger;
    private ContextProvider contextProvider;
    private final Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.ioManager = null;
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(GdbBreakpointEvent gdbBreakpointEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (gdbBreakpointEvent.getDebugger() != this.debugger) {
                return;
            }
        }
        if (gdbBreakpointEvent.getConditionResult() == 2) {
            return;
        }
        object = (GdbBreakpoint)((Object)gdbBreakpointEvent.getSource());
        if (((GdbBreakpoint)((Object)object)).getSuspend() != 0) {
            this.getBreakpointsNodeModel().setCurrentBreakpoint((GdbBreakpoint)((Object)object));
            this.debugger.setCurrentBreakpoint((GdbBreakpoint)((Object)object));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ioManager == null) {
                this.lookupIOManager();
                if (this.ioManager == null) {
                    return;
                }
            }
        }
        object2 = ((GdbBreakpoint)((Object)object)).getPrintText();
        if (object2 == null || ((String)object2).length() == 0) {
            return;
        }
        object2 = this.substitute((String)object2, gdbBreakpointEvent);
        Object object3 = this.lock;
        synchronized (object3) {
            if (this.ioManager != null) {
                this.ioManager.println((String)object2, null);
            }
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.debugger == null || !propertyChangeEvent.getPropertyName().equals("state") || this.debugger.getState() == GdbDebugger.State.STOPPED) {
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
        this.debugger.setCurrentBreakpoint(null);
    }

    private String substitute(String string, GdbBreakpointEvent gdbBreakpointEvent) {
        Object object;
        Object object2 = gdbBreakpointEvent.getSource();
        if (object2 instanceof LineBreakpoint) {
            object = (LineBreakpoint)((Object)object2);
            String string2 = ((GdbBreakpoint)((Object)object)).getPath();
            String string3 = Integer.toString(((GdbBreakpoint)((Object)object)).getLineNumber());
            string = fileNamePattern.matcher(string).replaceAll(string2);
            string = lineNumberPattern.matcher(string).replaceAll(string3);
        } else if (object2 instanceof FunctionBreakpoint) {
            object = (FunctionBreakpoint)((Object)object2);
            String string4 = ((FunctionBreakpoint)((Object)object)).getFunctionName();
            string = functionNamePattern.matcher(string).replaceAll(string4);
        }
        object = gdbBreakpointEvent.getConditionException();
        if (object != null) {
            string = string + "\n***\n" + ((Throwable)object).getLocalizedMessage() + "\n***\n";
        }
        return string;
    }

    private void lookupIOManager() {
        List list = this.contextProvider.lookup(null, LazyActionsManagerListener.class);
        for (LazyActionsManagerListener lazyActionsManagerListener : list) {
            if (!(lazyActionsManagerListener instanceof DebuggerOutput)) continue;
            this.ioManager = ((DebuggerOutput)lazyActionsManagerListener).getIOManager();
            break;
        }
    }

    private void hookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.hookBreakpoint(breakpoint);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.unhookBreakpoint(breakpoint);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof GdbBreakpoint) {
            GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
            gdbBreakpoint.addGdbBreakpointListener(this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof GdbBreakpoint) {
            GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
            gdbBreakpoint.removeGdbBreakpointListener(this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List list = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            for (NodeModel nodeModel : list) {
                if (!(nodeModel instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nodeModel;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

