/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.actions.GdbDebuggerActionProvider;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class StepActionProvider
extends GdbDebuggerActionProvider {
    private final Set actions = new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_CONTINUE, ActionsManager.ACTION_RUN_TO_CURSOR));

    public StepActionProvider(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public Set getActions() {
        return this.actions;
    }

    public void doAction(Object object) {
        this.runAction(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(Object object) {
        if (this.getDebugger() != null) {
            Object object2 = this.getDebugger().LOCK;
            synchronized (object2) {
                if (object == ActionsManager.ACTION_STEP_INTO) {
                    if (Disassembly.isInDisasm()) {
                        this.getDebugger().stepI();
                    } else {
                        this.getDebugger().stepInto();
                    }
                    return;
                }
                if (object == ActionsManager.ACTION_STEP_OUT) {
                    this.getDebugger().stepOut();
                    return;
                }
                if (object == ActionsManager.ACTION_STEP_OVER) {
                    if (Disassembly.isInDisasm()) {
                        this.getDebugger().stepOverInstr();
                    } else {
                        this.getDebugger().stepOver();
                    }
                    return;
                }
                if (object == ActionsManager.ACTION_CONTINUE) {
                    this.getDebugger().resume();
                    return;
                }
                if (object == ActionsManager.ACTION_RUN_TO_CURSOR) {
                    this.getDebugger().runToCursor();
                    return;
                }
            }
        }
    }

    public void postAction(final Object object, final Runnable runnable) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepActionProvider.this.doAction(object);
                }
                finally {
                    runnable.run();
                }
            }
        });
    }

    protected void checkEnabled(GdbDebugger.State state) {
        boolean bl = state == GdbDebugger.State.STOPPED;
        for (Object e : this.getActions()) {
            if (e == ActionsManager.ACTION_STEP_OUT) {
                this.setEnabled(e, bl && this.isStepOutValid());
                continue;
            }
            this.setEnabled(e, bl);
        }
    }

    public boolean isStepOutValid() {
        List<CallStackFrame> list = this.getDebugger().getCallStack();
        return list.size() == 1 || list.size() > 1 && list.get(1).isValid();
    }
}

