/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import java.beans.PropertyChangeListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class SourcePathProvider {
    public static final String PROP_SOURCE_ROOTS = "sourceRoots";

    public abstract String getRelativePath(String var1, char var2, boolean var3);

    public abstract String getURL(String var1, boolean var2);

    public String getSourceRoot(String string) {
        return null;
    }

    public abstract String[] getSourceRoots();

    public abstract void setSourceRoots(String[] var1);

    public abstract String[] getOriginalSourceRoots();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextAware
    extends SourcePathProvider
    implements ContextAwareService<SourcePathProvider> {
        private String serviceName;

        private ContextAware(String string) {
            this.serviceName = string;
        }

        public SourcePathProvider forContext(ContextProvider contextProvider) {
            return (SourcePathProvider)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)contextProvider);
        }

        @Override
        public String getRelativePath(String string, char c, boolean bl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getURL(String string, boolean bl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String[] getSourceRoots() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setSourceRoots(String[] stringArray) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String[] getOriginalSourceRoots() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        static ContextAwareService createService(Map map) throws ClassNotFoundException {
            String string = (String)map.get("serviceName");
            return new ContextAware(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

