/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends JPDABreakpoint {
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_SOURCE_NAME = "sourceName";
    public static final String PROP_SOURCE_PATH = "sourcePath";
    public static final String PROP_STRATUM = "stratum";
    public static final String PROP_PREFERRED_CLASS_NAME = "classNamePreferred";
    public static final String PROP_INSTANCE_FILTERS = "instanceFilters";
    public static final String PROP_THREAD_FILTERS = "threadFilters";
    private String url = "";
    private int lineNumber;
    private String condition = "";
    private String sourceName = null;
    private String sourcePath = null;
    private String stratum = "Java";
    private String className = null;
    private Map<JPDADebugger, ObjectVariable[]> instanceFilters;
    private Map<JPDADebugger, JPDAThread[]> threadFilters;

    private LineBreakpoint(String string) {
        this.url = string;
    }

    public static LineBreakpoint create(String string, int n) {
        LineBreakpointImpl lineBreakpointImpl = new LineBreakpointImpl(string);
        lineBreakpointImpl.setLineNumber(n);
        return lineBreakpointImpl;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string == null) {
                string = "";
            }
            if (string == this.url || string != null && this.url != null && string.equals(this.url)) {
                return;
            }
            string2 = this.url;
            this.url = string;
        }
        this.firePropertyChange(PROP_URL, string2, string);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int n) {
        int n2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (n == this.lineNumber) {
                return;
            }
            n2 = this.lineNumber;
            this.lineNumber = n;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(n2), new Integer(n));
    }

    public ObjectVariable[] getInstanceFilters(JPDADebugger jPDADebugger) {
        if (this.instanceFilters != null) {
            return this.instanceFilters.get(jPDADebugger);
        }
        return null;
    }

    public void setInstanceFilters(JPDADebugger jPDADebugger, ObjectVariable[] objectVariableArray) {
        Object[] objectArray;
        if (this.instanceFilters == null) {
            this.instanceFilters = new WeakHashMap<JPDADebugger, ObjectVariable[]>();
        }
        if (objectVariableArray != null) {
            this.instanceFilters.put(jPDADebugger, objectVariableArray);
        } else {
            this.instanceFilters.remove(jPDADebugger);
        }
        if (objectVariableArray != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = jPDADebugger;
            objectArray = objectArray2;
            objectArray2[1] = objectVariableArray;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_INSTANCE_FILTERS, null, objectArray);
    }

    public JPDAThread[] getThreadFilters(JPDADebugger jPDADebugger) {
        if (this.threadFilters != null) {
            return this.threadFilters.get(jPDADebugger);
        }
        return null;
    }

    public void setThreadFilters(JPDADebugger jPDADebugger, JPDAThread[] jPDAThreadArray) {
        Object[] objectArray;
        if (this.threadFilters == null) {
            this.threadFilters = new WeakHashMap<JPDADebugger, JPDAThread[]>();
        }
        if (jPDAThreadArray != null) {
            this.threadFilters.put(jPDADebugger, jPDAThreadArray);
        } else {
            this.threadFilters.remove(jPDADebugger);
        }
        if (jPDAThreadArray != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = jPDADebugger;
            objectArray = objectArray2;
            objectArray2[1] = jPDAThreadArray;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_THREAD_FILTERS, null, objectArray);
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()) == this.condition || string != null && this.condition != null && this.condition.equals(string)) {
                return;
            }
            string2 = this.condition;
            this.condition = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getStratum() {
        return this.stratum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStratum(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()) == this.stratum || string != null && this.stratum != null && this.stratum.equals(string)) {
                return;
            }
            string2 = this.stratum;
            this.stratum = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceName(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string != null) {
                string = string.trim();
            }
            if (string == this.sourceName || string != null && this.sourceName != null && this.sourceName.equals(string)) {
                return;
            }
            string2 = this.sourceName;
            this.sourceName = string;
        }
        this.firePropertyChange(PROP_SOURCE_NAME, string2, string);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourcePath(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string != null) {
                string = string.trim();
            }
            if (string == this.sourcePath || string != null && string.equals(this.sourcePath)) {
                return;
            }
            string2 = this.sourcePath;
            this.sourcePath = string;
        }
        this.firePropertyChange(PROP_SOURCE_PATH, string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredClassName(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (this.className == string || string != null && string.equals(this.className)) {
                return;
            }
            string2 = string;
            this.className = string;
        }
        this.firePropertyChange(PROP_PREFERRED_CLASS_NAME, string2, string);
    }

    public String getPreferredClassName() {
        return this.className;
    }

    public String toString() {
        String string = null;
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(this.url));
            if (fileObject != null) {
                string = fileObject.getNameExt();
            }
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
        }
        if (string == null) {
            string = this.url;
        }
        return "LineBreakpoint " + string + " : " + this.lineNumber;
    }

    private static class LineBreakpointImpl
    extends LineBreakpoint
    implements Comparable,
    FileChangeListener,
    ChangeListener,
    PropertyChangeListener {
        private FileObject fo;
        private ChangeListener registryListener;

        public LineBreakpointImpl(String string) {
            super(string);
            try {
                this.fo = URLMapper.findFileObject((URL)new URL(string));
                if (this.fo != null) {
                    this.fo.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.fo));
                    this.registryListener = WeakListeners.change((ChangeListener)this, (Object)DataObject.getRegistry());
                    DataObject.getRegistry().addChangeListener(this.registryListener);
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException("URL = '" + string + "'", malformedURLException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException("URL = '" + string + "'", illegalArgumentException));
            }
        }

        public int compareTo(Object object) {
            if (object instanceof LineBreakpointImpl) {
                LineBreakpointImpl lineBreakpointImpl = this;
                LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
                int n = ((LineBreakpoint)lineBreakpointImpl).url.compareTo(lineBreakpoint.url);
                if (n != 0) {
                    return n;
                }
                return ((LineBreakpoint)lineBreakpointImpl).lineNumber - lineBreakpoint.lineNumber;
            }
            return -1;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this);
            this.fo = null;
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            try {
                this.setURL(((FileObject)fileRenameEvent.getSource()).getURL().toString());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof Breakpoint.VALIDITY) {
                this.setValidity((Breakpoint.VALIDITY)object, changeEvent.toString());
            } else if (object instanceof Collection) {
                for (DataObject dataObject : (Collection)object) {
                    if (this.registryListener == null) continue;
                    FileObject fileObject = this.fo;
                    if (fileObject == null) {
                        DataObject.getRegistry().removeChangeListener(this.registryListener);
                        this.registryListener = null;
                        return;
                    }
                    FileObject fileObject2 = dataObject.getPrimaryFile();
                    if (!fileObject.equals(fileObject2)) continue;
                    dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataObject));
                    DataObject.getRegistry().removeChangeListener(this.registryListener);
                    this.registryListener = null;
                }
            } else {
                throw new UnsupportedOperationException(changeEvent.toString());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                FileObject fileObject = ((DataObject)propertyChangeEvent.getSource()).getPrimaryFile();
                fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.fo));
                try {
                    this.setURL(fileObject.getURL().toString());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
                this.fo = fileObject;
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this);
            }
        }
    }
}

