/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsImpl;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.xml.sax.Attributes;

public class GizmoOptionsXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private final Logger log = DLightLogger.getLogger(GizmoOptionsXMLCodec.class);
    private GizmoOptionsImpl gizmoOptions;
    private static final String PROFILE_ON_RUN_ELEMENT = "profileOnRun";
    private static final String DATA_PROVIDER_ELEMENT = "dataprovider";
    private static final String TOOL_ELEMENT = "tool";
    private static final String TOOL_NAME_ATTRIBUTE = "name";
    private static final String TOOL_ENABLED_ATTRIBUTE = "enabled";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    private static final int thisversion = 1;

    public GizmoOptionsXMLCodec(GizmoOptionsImpl gizmoOptionsImpl) {
        this.gizmoOptions = gizmoOptionsImpl;
    }

    public static int getVersion() {
        return 1;
    }

    public String tag() {
        return "gizmo_options";
    }

    public void start(Attributes attributes) throws VersionException {
        String string = "gizmo options";
        int n = GizmoOptionsXMLCodec.getVersion();
        this.checkVersion(attributes, string, n);
    }

    public void end() {
        this.gizmoOptions.clearChanged();
    }

    public void startElement(String string, Attributes attributes) {
        this.log.log(Level.FINEST, "start element with the name " + string);
        if (string.equals(TOOL_ELEMENT)) {
            String string2 = attributes.getValue(TOOL_NAME_ATTRIBUTE);
            boolean bl = attributes.getValue(TOOL_ENABLED_ATTRIBUTE).equals(TRUE_VALUE);
            this.gizmoOptions.setValueByName(string2, bl);
        }
    }

    public void endElement(String string, String string2) {
        this.log.log(Level.FINEST, "end element with the name " + string);
        if (string.equals(PROFILE_ON_RUN_ELEMENT)) {
            boolean bl = string2.equals(TRUE_VALUE);
            this.gizmoOptions.getProfileOnRun().setValue(bl);
        } else if (string.equals(DATA_PROVIDER_ELEMENT)) {
            int n = new Integer(string2);
            this.gizmoOptions.getDataProvider().setValue(n);
        }
    }

    private static void encode(XMLEncoderStream xMLEncoderStream, GizmoOptionsImpl gizmoOptionsImpl) {
        xMLEncoderStream.elementOpen("gizmo_options", GizmoOptionsXMLCodec.getVersion());
        if (gizmoOptionsImpl.getProfileOnRun().getModified()) {
            xMLEncoderStream.element(PROFILE_ON_RUN_ELEMENT, "" + gizmoOptionsImpl.getProfileOnRun().getValue());
        }
        for (String string : gizmoOptionsImpl.getNames()) {
            BooleanConfiguration booleanConfiguration = gizmoOptionsImpl.getConfigurationByName(string);
            if (!booleanConfiguration.getModified()) continue;
            AttrValuePair[] attrValuePairArray = new AttrValuePair[]{new AttrValuePair(TOOL_NAME_ATTRIBUTE, string), new AttrValuePair(TOOL_ENABLED_ATTRIBUTE, "" + booleanConfiguration.getValue())};
            xMLEncoderStream.element(TOOL_ELEMENT, attrValuePairArray);
        }
        if (gizmoOptionsImpl.getDataProvider().getModified()) {
            xMLEncoderStream.element(DATA_PROVIDER_ELEMENT, "" + gizmoOptionsImpl.getDataProvider().getValue());
        }
        xMLEncoderStream.elementClose("gizmo_options");
    }

    public void encode(XMLEncoderStream xMLEncoderStream) {
        GizmoOptionsXMLCodec.encode(xMLEncoderStream, this.gizmoOptions);
    }
}

