/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsXMLCodec;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GizmoOptionsImpl
implements ConfigurationAuxObject,
GizmoOptions {
    public static final String PROFILE_ID = "gizmo_options";
    private final PropertyChangeSupport pcs;
    private boolean needSave = false;
    private String baseDir;
    private BooleanConfiguration profileOnRun;
    public static final String PROFILE_ON_RUN_PROP = "profileOnRun";
    private final Map<String, BooleanConfiguration> toolConfigurations;
    private final Map<String, String> toolDescriptions;
    private static final String[] DATA_PROVIDER_NAMES = new String[]{GizmoOptionsImpl.getString("SunStudio"), GizmoOptionsImpl.getString("DTrace"), GizmoOptionsImpl.getString("Simple")};
    private static final String[] LINUX_DATA_PROVIDER_NAMES = new String[]{GizmoOptionsImpl.getString("Simple"), GizmoOptionsImpl.getString("SunStudio")};
    private static final String[] WINDOWS_DATA_PROVIDER_NAMES = new String[]{GizmoOptionsImpl.getString("Simple")};
    private IntConfiguration dataProvider;
    private DataProvidersCollection currentDPCollection = DataProvidersCollection.DEFAULT;
    public static final String DATA_PROVIDER_PROP = "dataProvider";
    private static ResourceBundle bundle;

    public GizmoOptionsImpl(String string, PropertyChangeSupport propertyChangeSupport) {
        this.baseDir = string;
        this.pcs = propertyChangeSupport;
        this.toolConfigurations = new HashMap<String, BooleanConfiguration>();
        this.toolDescriptions = new HashMap<String, String>();
        this.profileOnRun = new BooleanConfiguration(null, true, null, null);
        this.dataProvider = new IntConfiguration(null, 0, DATA_PROVIDER_NAMES, null);
        this.currentDPCollection = DataProvidersCollection.DEFAULT;
    }

    @Override
    public void init(Configuration configuration) {
        Object object2;
        MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
        ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        DLightConfiguration dLightConfiguration = DLightConfigurationManager.getInstance().getConfigurationByName("Gizmo");
        List list = dLightConfiguration.getToolsSet();
        for (Object object2 : list) {
            String string = object2.getName();
            boolean bl = this.toolConfigurations.get(string) == null ? true : this.toolConfigurations.get(string).getValue();
            this.toolConfigurations.put(string, new BooleanConfiguration(null, bl, string, string));
            this.toolDescriptions.put(string, object2.getDetailedName());
        }
        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment);
        object2 = compilerSetManager.getCompilerSets();
        boolean bl = false;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            CompilerSet compilerSet = (CompilerSet)object3.next();
            if (!compilerSet.isSunCompiler()) continue;
            bl = true;
            break;
        }
        object3 = makeConfiguration.getDevelopmentHost().getBuildPlatformDisplayName();
        int n = this.getDataProvider().getValue();
        if (((String)object3).indexOf("Linux") != -1 || ((String)object3).equals("MacOS")) {
            this.dataProvider = new IntConfiguration(null, 0, LINUX_DATA_PROVIDER_NAMES, null);
            this.currentDPCollection = DataProvidersCollection.LINUX;
            switch (n) {
                case 0: {
                    this.setDataProviderValue(GizmoOptions.DataProvider.SIMPLE);
                    break;
                }
                case 1: {
                    this.setDataProviderValue(GizmoOptions.DataProvider.SUN_STUDIO);
                    break;
                }
                default: {
                    this.setDataProviderValue(GizmoOptions.DataProvider.SIMPLE);
                    break;
                }
            }
        } else if (((String)object3).indexOf("Solaris") != -1) {
            this.dataProvider = new IntConfiguration(null, 0, DATA_PROVIDER_NAMES, null);
            this.currentDPCollection = DataProvidersCollection.DEFAULT;
            switch (n) {
                case 0: {
                    this.setDataProviderValue(GizmoOptions.DataProvider.SUN_STUDIO);
                    break;
                }
                case 1: {
                    this.setDataProviderValue(GizmoOptions.DataProvider.DTRACE);
                    break;
                }
                default: {
                    this.setDataProviderValue(GizmoOptions.DataProvider.SIMPLE);
                    break;
                }
            }
        } else {
            this.dataProvider = new IntConfiguration(null, 0, WINDOWS_DATA_PROVIDER_NAMES, null);
            this.currentDPCollection = DataProvidersCollection.WINDOWS;
            this.setDataProviderValue(GizmoOptions.DataProvider.SIMPLE);
        }
    }

    @Override
    public Collection<String> getNames() {
        return this.toolConfigurations.keySet();
    }

    public void initialize() {
        this.clearChanged();
    }

    public static GizmoOptionsImpl getOptions(Configuration configuration) {
        GizmoOptionsImpl gizmoOptionsImpl = (GizmoOptionsImpl)configuration.getAuxObject(PROFILE_ID);
        gizmoOptionsImpl.init(configuration);
        return gizmoOptionsImpl;
    }

    public boolean isModified() {
        return this.getProfileOnRun().getModified();
    }

    public String getId() {
        return PROFILE_ID;
    }

    private void checkPropertyChange(String string, boolean bl, boolean bl2) {
        if (bl != bl2 && this.pcs != null) {
            this.pcs.firePropertyChange(string, bl, bl2);
        }
    }

    private void checkPropertyChange(String string, Object object, Object object2) {
        if (object != object2 && this.pcs != null) {
            this.pcs.firePropertyChange(string, object, object2);
        }
    }

    public BooleanConfiguration getProfileOnRun() {
        return this.profileOnRun;
    }

    @Override
    public boolean getProfileOnRunValue() {
        return this.getProfileOnRun().getValue();
    }

    public void setProfileOnRun(BooleanConfiguration booleanConfiguration) {
        this.profileOnRun = booleanConfiguration;
    }

    @Override
    public void setProfileOnRunValue(boolean bl) {
        boolean bl2 = this.getProfileOnRunValue();
        this.getProfileOnRun().setValue(bl);
        this.checkPropertyChange(PROFILE_ON_RUN_PROP, bl2, this.getProfileOnRunValue());
    }

    public BooleanConfiguration getConfigurationByName(String string) {
        return this.toolConfigurations.get(string);
    }

    public String getDescriptionByName(String string) {
        return this.toolDescriptions.get(string);
    }

    @Override
    public boolean getValueByName(String string) {
        return this.toolConfigurations.get(string).getValue();
    }

    public void setByName(String string, BooleanConfiguration booleanConfiguration) {
        this.toolConfigurations.put(string, booleanConfiguration);
    }

    @Override
    public void setValueByName(String string, boolean bl) {
        boolean bl2;
        BooleanConfiguration booleanConfiguration = this.toolConfigurations.get(string);
        boolean bl3 = bl2 = booleanConfiguration == null ? false : booleanConfiguration.getValue();
        if (booleanConfiguration == null) {
            booleanConfiguration = new BooleanConfiguration(null, true, string, string);
            this.toolConfigurations.put(string, booleanConfiguration);
        }
        booleanConfiguration.setValue(bl);
        this.checkPropertyChange(string, bl2, bl);
    }

    public IntConfiguration getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public GizmoOptions.DataProvider getDataProviderValue() {
        if (this.currentDPCollection == DataProvidersCollection.DEFAULT) {
            if (this.getDataProvider().getValue() == 0) {
                return GizmoOptions.DataProvider.SUN_STUDIO;
            }
            if (this.getDataProvider().getValue() == 1) {
                return GizmoOptions.DataProvider.DTRACE;
            }
            if (this.getDataProvider().getValue() == 2) {
                return GizmoOptions.DataProvider.SIMPLE;
            }
        } else if (this.currentDPCollection == DataProvidersCollection.LINUX) {
            if (this.getDataProvider().getValue() == 0) {
                return GizmoOptions.DataProvider.SIMPLE;
            }
            if (this.getDataProvider().getValue() == 1) {
                return GizmoOptions.DataProvider.SUN_STUDIO;
            }
        } else {
            return GizmoOptions.DataProvider.SIMPLE;
        }
        return GizmoOptions.DataProvider.SIMPLE;
    }

    public void setDataProvider(IntConfiguration intConfiguration) {
        this.dataProvider = intConfiguration;
    }

    @Override
    public void setDataProviderValue(GizmoOptions.DataProvider dataProvider) {
        int n = 0;
        if (this.currentDPCollection == DataProvidersCollection.DEFAULT) {
            if (dataProvider == GizmoOptions.DataProvider.SUN_STUDIO) {
                n = 0;
            } else if (dataProvider == GizmoOptions.DataProvider.DTRACE) {
                n = 1;
            } else if (dataProvider == GizmoOptions.DataProvider.SIMPLE) {
                n = 2;
            }
        } else if (this.currentDPCollection == DataProvidersCollection.LINUX) {
            if (dataProvider == GizmoOptions.DataProvider.SUN_STUDIO) {
                n = 1;
            } else if (dataProvider == GizmoOptions.DataProvider.SIMPLE) {
                n = 0;
            }
        } else {
            n = 0;
        }
        GizmoOptions.DataProvider dataProvider2 = this.getDataProviderValue();
        this.getDataProvider().setValue(n);
        this.checkPropertyChange(DATA_PROVIDER_PROP, (Object)dataProvider2, (Object)this.getDataProviderValue());
    }

    public boolean shared() {
        return false;
    }

    public XMLDecoder getXMLDecoder() {
        return new GizmoOptionsXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new GizmoOptionsXMLCodec(this);
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public void assign(ConfigurationAuxObject configurationAuxObject) {
        GizmoOptionsImpl gizmoOptionsImpl = (GizmoOptionsImpl)configurationAuxObject;
        boolean bl = this.getProfileOnRun().getValue();
        this.getProfileOnRun().assign(gizmoOptionsImpl.getProfileOnRun());
        this.checkPropertyChange(PROFILE_ON_RUN_PROP, bl, this.getProfileOnRunValue());
        Set<String> set = this.toolConfigurations.keySet();
        for (String string : set) {
            BooleanConfiguration booleanConfiguration = this.toolConfigurations.get(string);
            bl = booleanConfiguration.getValue();
            booleanConfiguration.assign(gizmoOptionsImpl.getConfigurationByName(string));
            this.checkPropertyChange(string, bl, this.getValueByName(string));
        }
        GizmoOptions.DataProvider dataProvider = this.getDataProviderValue();
        this.getDataProvider().assign(gizmoOptionsImpl.getDataProvider());
        this.checkPropertyChange(DATA_PROVIDER_PROP, (Object)dataProvider, (Object)this.getDataProviderValue());
    }

    public GizmoOptionsImpl clone(Configuration configuration) {
        GizmoOptionsImpl gizmoOptionsImpl = new GizmoOptionsImpl(this.getBaseDir(), null);
        gizmoOptionsImpl.setProfileOnRun(this.getProfileOnRun().clone());
        Set<String> set = this.toolConfigurations.keySet();
        for (String string : set) {
            BooleanConfiguration booleanConfiguration = this.toolConfigurations.get(string);
            gizmoOptionsImpl.setByName(string, booleanConfiguration.clone());
        }
        gizmoOptionsImpl.setDataProvider(this.getDataProvider().clone());
        return gizmoOptionsImpl;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    protected static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(GizmoOptionsImpl.class);
        }
        return bundle.getString(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DataProvidersCollection {
        DEFAULT,
        LINUX,
        WINDOWS;

    }
}

