/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.addr2line;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

class SectionFinder {
    private static final Logger logger = Logger.getLogger(SectionFinder.class.getName());
    private static final debug DEBUG = new debug();
    private static final byte ELFMAG0 = 127;
    private static final byte ELFMAG1 = 69;
    private static final byte ELFMAG2 = 76;
    private static final byte ELFMAG3 = 70;
    private static final boolean WORDS_BIGENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);

    SectionFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MappedByteBuffer mapSection(String string, String string2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        Elf32_Ehdr elf32_Ehdr = new Elf32_Ehdr();
        elf32_Ehdr.read(randomAccessFile);
        if (elf32_Ehdr.e_ident[0] != 127 || elf32_Ehdr.e_ident[1] != 69 || elf32_Ehdr.e_ident[2] != 76 || elf32_Ehdr.e_ident[3] != 70) {
            randomAccessFile.close();
            throw new IOException(string + ": not an ELF file");
        }
        Elf32_Shdr elf32_Shdr = new Elf32_Shdr();
        randomAccessFile.seek(elf32_Ehdr.e_shoff + (long)(elf32_Ehdr.e_shstrndx * Elf32_Shdr.sizeof()));
        elf32_Shdr.read(randomAccessFile);
        Elf32_Shdr elf32_Shdr2 = new Elf32_Shdr();
        byte[] byArray = string2.getBytes("ISO8859-1");
        byte[] byArray2 = new byte[byArray.length + 1];
        boolean bl = false;
        block3: for (int i = 0; i < elf32_Ehdr.e_shnum; ++i) {
            randomAccessFile.seek(elf32_Ehdr.e_shoff + (long)(i * Elf32_Shdr.sizeof()));
            elf32_Shdr2.read(randomAccessFile);
            randomAccessFile.seek(elf32_Shdr.sh_offset + elf32_Shdr2.sh_name);
            randomAccessFile.readFully(byArray2);
            for (int j = 0; j < byArray.length; ++j) {
                if (byArray[j] != byArray2[j]) continue block3;
            }
            if (byArray2[byArray2.length - 1] != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            randomAccessFile.close();
            throw new IOException("no section " + string2 + " found in " + string);
        }
        try {
            FileChannel fileChannel = randomAccessFile.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, elf32_Shdr2.sh_offset, elf32_Shdr2.sh_size);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            fileChannel.close();
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
            return mappedByteBuffer2;
        }
        finally {
            randomAccessFile.close();
        }
    }

    private static int readUHalf(RandomAccessFile randomAccessFile) throws IOException {
        if (WORDS_BIGENDIAN) {
            return randomAccessFile.readUnsignedShort();
        }
        return randomAccessFile.readUnsignedByte() | randomAccessFile.readUnsignedByte() << 8;
    }

    private static int readWord(RandomAccessFile randomAccessFile) throws IOException {
        if (WORDS_BIGENDIAN) {
            return randomAccessFile.readInt();
        }
        return randomAccessFile.readUnsignedByte() | randomAccessFile.readUnsignedByte() << 8 | randomAccessFile.readUnsignedByte() << 16 | randomAccessFile.readUnsignedByte() << 24;
    }

    private static long readUWord(RandomAccessFile randomAccessFile) throws IOException {
        if (WORDS_BIGENDIAN) {
            return (long)randomAccessFile.readInt() & 0xFFFFFFFFL;
        }
        long l = randomAccessFile.readUnsignedByte() | randomAccessFile.readUnsignedByte() << 8 | randomAccessFile.readUnsignedByte() << 16 | randomAccessFile.readUnsignedByte() << 24;
        return l & 0xFFFFFFFFL;
    }

    private static class Elf32_Shdr {
        private long sh_name;
        private int sh_type;
        private int sh_flags;
        private long sh_addr;
        private long sh_offset;
        private long sh_size;
        private int sh_link;
        private int sh_info;
        private int sh_addralign;
        private long sh_entsize;

        private Elf32_Shdr() {
        }

        private static int sizeof() {
            return 40;
        }

        private void read(RandomAccessFile randomAccessFile) throws IOException {
            this.sh_name = SectionFinder.readUWord(randomAccessFile);
            this.sh_type = SectionFinder.readWord(randomAccessFile);
            this.sh_flags = SectionFinder.readWord(randomAccessFile);
            this.sh_addr = SectionFinder.readUWord(randomAccessFile);
            this.sh_offset = SectionFinder.readUWord(randomAccessFile);
            this.sh_size = SectionFinder.readUWord(randomAccessFile);
            this.sh_link = SectionFinder.readWord(randomAccessFile);
            this.sh_info = SectionFinder.readWord(randomAccessFile);
            this.sh_addralign = SectionFinder.readWord(randomAccessFile);
            this.sh_entsize = SectionFinder.readWord(randomAccessFile);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" [ sh_name: ").append(this.sh_name);
            stringBuffer.append("; sh_type: ").append(this.sh_type);
            stringBuffer.append("; sh_flags: 0x").append(Long.toHexString(this.sh_flags));
            stringBuffer.append("; sh_addr: 0x").append(Long.toHexString(this.sh_addr));
            stringBuffer.append("; sh_offset: ").append(this.sh_offset);
            stringBuffer.append("; sh_size: ").append(this.sh_size);
            stringBuffer.append("; sh_link: ").append(this.sh_link);
            stringBuffer.append("; sh_info: ").append(this.sh_info);
            stringBuffer.append("; sh_addralgin: ").append(this.sh_addralign);
            stringBuffer.append("; sh_entsize: ").append(this.sh_entsize);
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }

    private static class Elf32_Ehdr {
        private static final int EI_NIDENT = 16;
        private final byte[] e_ident = new byte[16];
        private int e_type;
        private int e_machine;
        private int e_version;
        private long e_entry;
        private long e_phoff;
        private long e_shoff;
        private int e_flags;
        private int e_ehsize;
        private int e_phentsize;
        private int e_phentnum;
        private int e_shentsize;
        private int e_shnum;
        private int e_shstrndx;

        private Elf32_Ehdr() {
        }

        private void read(RandomAccessFile randomAccessFile) throws IOException {
            randomAccessFile.readFully(this.e_ident);
            this.e_type = SectionFinder.readUHalf(randomAccessFile);
            this.e_machine = SectionFinder.readUHalf(randomAccessFile);
            this.e_version = SectionFinder.readWord(randomAccessFile);
            this.e_entry = SectionFinder.readUWord(randomAccessFile);
            this.e_phoff = SectionFinder.readUWord(randomAccessFile);
            this.e_shoff = SectionFinder.readUWord(randomAccessFile);
            this.e_flags = SectionFinder.readWord(randomAccessFile);
            this.e_ehsize = SectionFinder.readUHalf(randomAccessFile);
            this.e_phentsize = SectionFinder.readUHalf(randomAccessFile);
            this.e_phentnum = SectionFinder.readUHalf(randomAccessFile);
            this.e_shentsize = SectionFinder.readUHalf(randomAccessFile);
            this.e_shnum = SectionFinder.readUHalf(randomAccessFile);
            this.e_shstrndx = SectionFinder.readUHalf(randomAccessFile);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" [ e_ident: ");
            for (int i = 0; i < 16; ++i) {
                if (this.e_ident[i] < 16 && this.e_ident[i] >= 0) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(this.e_ident[i] & 0xFF));
            }
            stringBuffer.append("; e_type: ").append(this.e_type & 0xFFFF);
            stringBuffer.append("; e_machine: ").append(this.e_machine & 0xFFFF);
            stringBuffer.append("; e_version: ").append(this.e_version & 0xFFFF);
            stringBuffer.append("; e_entry: 0x").append(Long.toHexString(this.e_entry));
            stringBuffer.append("; e_phoff: ").append(this.e_phoff & 0xFFFFFFFFL);
            stringBuffer.append("; e_shoff: ").append(this.e_shoff & 0xFFFFFFFFL);
            stringBuffer.append("; e_flags: 0x").append(Integer.toHexString(this.e_flags));
            stringBuffer.append("; e_ehsize: ").append(this.e_ehsize & 0xFFFF);
            stringBuffer.append("; e_phentsize: ").append(this.e_phentsize & 0xFFFF);
            stringBuffer.append("; e_phentnum: ").append(this.e_phentnum & 0xFFFF);
            stringBuffer.append("; e_shentsize: ").append(this.e_shentsize & 0xFFFF);
            stringBuffer.append("; e_shnum: ").append(this.e_shnum & 0xFFFF);
            stringBuffer.append("; e_shstrndx: ").append(this.e_shstrndx & 0xFFFF);
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }

    private static final class debug
    extends Level {
        private debug() {
            super("DWARF-2(ELF-32)", Level.INFO.intValue());
        }
    }
}

