/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.gizmo.GizmoProjectOptions;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GizmoOptionsPanel
extends JPanel
implements ExplorerManager.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final GizmoProjectOptions options;
    private JButton btnAdd;
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private JComboBox dataCollectorName;
    private ListView toolsListView;
    private JCheckBox useCollectorsCheckBox;

    public GizmoOptionsPanel(GizmoProjectOptions gizmoProjectOptions) {
        this.initComponents();
        this.options = gizmoProjectOptions;
        this.manager.setRootContext((Node)new AbstractNode((Children)new DLightConfigurationChildren(gizmoProjectOptions.getSelectedTools())));
        this.dataCollectorName.setModel(new DefaultComboBoxModel<String>(new String[]{"SunStudio", "DTrace"}));
        this.dataCollectorName.setSelectedItem(gizmoProjectOptions.getDataCollectorName());
        this.useCollectorsCheckBox.setSelected(gizmoProjectOptions.getDataCollectorEnabled());
        this.dataCollectorName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GizmoOptionsPanel.this.options.setDataCollectorName("" + GizmoOptionsPanel.this.dataCollectorName.getSelectedItem());
                if ("DTrace".equals("" + GizmoOptionsPanel.this.dataCollectorName.getSelectedItem())) {
                    GizmoOptionsPanel.this.options.setUserInteractionRequiredActionsEnabled(true);
                } else {
                    GizmoOptionsPanel.this.options.setUserInteractionRequiredActionsEnabled(false);
                }
            }
        });
        this.useCollectorsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GizmoOptionsPanel.this.options.setDataCollectorEnabled(GizmoOptionsPanel.this.useCollectorsCheckBox.isSelected());
            }
        });
        this.btnRemove.setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Node[] nodeArray = GizmoOptionsPanel.this.manager.getSelectedNodes();
                if (nodeArray == null || nodeArray.length == 0 || !(GizmoOptionsPanel.this.manager.getRootContext().getChildren() instanceof DLightConfigurationChildren)) {
                    return;
                }
                DLightConfigurationChildren dLightConfigurationChildren = (DLightConfigurationChildren)GizmoOptionsPanel.this.manager.getRootContext().getChildren();
                List<String> list = dLightConfigurationChildren.getNames();
                if (nodeArray != null && nodeArray.length > 0) {
                    boolean bl = false;
                    for (int i = 0; i < nodeArray.length; ++i) {
                        String string = nodeArray[i].getDisplayName();
                        if (!list.contains(string)) continue;
                        list.remove(string);
                        bl = true;
                    }
                    if (bl) {
                        dLightConfigurationChildren.setNames(list);
                    }
                }
                GizmoOptionsPanel.this.manager.getRootContext().getChildren().remove(nodeArray);
                Node[] nodeArray2 = GizmoOptionsPanel.this.manager.getRootContext().getChildren().getNodes();
                String[] stringArray = new String[nodeArray2.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = nodeArray2[i].getDisplayName();
                }
                GizmoOptionsPanel.this.options.setSelectedTools(stringArray);
                GizmoOptionsPanel.this.manager.setRootContext((Node)new AbstractNode((Children)new DLightConfigurationChildren(GizmoOptionsPanel.this.options.getSelectedTools())));
            }
        });
    }

    private void initComponents() {
        this.dataCollectorName = new JComboBox();
        this.useCollectorsCheckBox = new JCheckBox();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.toolsListView = new ListView();
        this.useCollectorsCheckBox.setText(NbBundle.getMessage(GizmoOptionsPanel.class, (String)"GizmoOptionsPanel.useCollectorsCheckBox.text"));
        this.btnAdd.setText(NbBundle.getMessage(GizmoOptionsPanel.class, (String)"GizmoOptionsPanel.btnAdd.text"));
        this.btnRemove.setText(NbBundle.getMessage(GizmoOptionsPanel.class, (String)"GizmoOptionsPanel.btnRemove.text"));
        this.btnUp.setText(NbBundle.getMessage(GizmoOptionsPanel.class, (String)"GizmoOptionsPanel.btnUp.text"));
        this.btnDown.setText(NbBundle.getMessage(GizmoOptionsPanel.class, (String)"GizmoOptionsPanel.btnDown.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.toolsListView, -1, 366, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.btnRemove, -1, -1, Short.MAX_VALUE).add((Component)this.btnUp, -1, -1, Short.MAX_VALUE).add((Component)this.btnDown, -1, -1, Short.MAX_VALUE).add((Component)this.btnAdd, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.useCollectorsCheckBox).addPreferredGap(0).add((Component)this.dataCollectorName, -2, 135, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnAdd).addPreferredGap(0).add((Component)this.btnRemove).addPreferredGap(0).add((Component)this.btnUp).addPreferredGap(0).add((Component)this.btnDown)).add((Component)this.toolsListView, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dataCollectorName, -2, -1, -2).add((Component)this.useCollectorsCheckBox)).addContainerGap(131, Short.MAX_VALUE)));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    class DLightToolNode
    extends AbstractNode {
        private final DLightTool dlightTool;

        DLightToolNode(DLightTool dLightTool) {
            super(Children.LEAF);
            this.dlightTool = dLightTool;
        }

        public String getDisplayName() {
            return this.dlightTool.getName();
        }

        public String getHtmlDisplayName() {
            return "<h3>" + this.getDisplayName() + "</h3>";
        }

        public Image getIcon(int n) {
            if (!this.dlightTool.hasIcon()) {
                return super.getIcon(n);
            }
            return ImageUtilities.loadImage((String)this.dlightTool.getIconPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DLightConfigurationChildren
    extends Children.Keys<String> {
        private final DLightConfiguration gizmoConfiguration = DLightConfigurationManager.getInstance().getConfigurationByName("Gizmo");
        private List<String> names;

        public DLightConfigurationChildren(String[] stringArray) {
            if (stringArray != null) {
                this.names = new ArrayList<String>();
                this.names.addAll(Arrays.asList(stringArray));
                return;
            }
            List list = this.gizmoConfiguration.getToolsSet();
            this.names = new ArrayList<String>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.names.add(((DLightTool)list.get(i)).getName());
            }
            this.setKeys(this.names);
        }

        public List<String> getNames() {
            return this.names;
        }

        protected Node[] createNodes(String string) {
            return new Node[]{new DLightToolNode(this.gizmoConfiguration.getToolByName(string))};
        }

        protected void addNotify() {
            this.setKeys(this.names);
        }

        private void setNames(List<String> list) {
            this.setKeys(list);
        }
    }
}

