/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppSymbolDemanglerImpl
implements CppSymbolDemangler {
    private static final int MAX_CMDLINE_LENGTH = 2000;
    private static final Map<String, String> demangledCache = new HashMap<String, String>();
    private final ExecutionEnvironment env;
    private final CppSymbolDemanglerFactory.CPPCompiler cppCompiler;
    private final String demanglerTool;
    private static final String GNU_FAMILIY = "gc++filt";
    private static final String SS_FAMILIY = "dem";
    private static final String EQUALS_EQUALS = " == ";

    CppSymbolDemanglerImpl() {
        Project project = OpenProjects.getDefault().getMainProject();
        NativeProject nativeProject = project == null ? null : (NativeProject)project.getLookup().lookup(NativeProject.class);
        MakeConfiguration makeConfiguration = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (nativeProject == null || makeConfiguration == null) {
            this.cppCompiler = CppSymbolDemanglerFactory.CPPCompiler.GNU;
            this.demanglerTool = GNU_FAMILIY;
            this.env = ExecutionEnvironmentFactory.getLocal();
            return;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        String string = SS_FAMILIY;
        if (compilerSet.getCompilerFlavor().isGnuCompiler()) {
            this.cppCompiler = CppSymbolDemanglerFactory.CPPCompiler.GNU;
            string = GNU_FAMILIY;
        } else {
            this.cppCompiler = CppSymbolDemanglerFactory.CPPCompiler.SS;
        }
        String string2 = compilerSet.getDirectory();
        ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        this.env = executionEnvironment.isRemote() ? ExecutionEnvironmentFactory.createNew((String)executionEnvironment.getUser(), (String)executionEnvironment.getHost()) : ExecutionEnvironmentFactory.getLocal();
        this.demanglerTool = string2 + "/" + string;
    }

    CppSymbolDemanglerImpl(CppSymbolDemanglerFactory.CPPCompiler cPPCompiler) {
        this.cppCompiler = cPPCompiler;
        this.demanglerTool = cPPCompiler == CppSymbolDemanglerFactory.CPPCompiler.GNU ? GNU_FAMILIY : SS_FAMILIY;
        this.env = ExecutionEnvironmentFactory.getLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String demangle(String string) {
        String string2 = CppSymbolDemanglerImpl.stripModuleAndOffset(string);
        if (!this.isMangled(string2)) {
            return string2;
        }
        String string3 = null;
        Object object = demangledCache;
        synchronized (object) {
            string3 = demangledCache.get(string2);
        }
        if (string3 == null) {
            object = Collections.singletonList(string2);
            this.demangleImpl((List<String>)object);
            string3 = (String)object.get(0);
            Map<String, String> map = demangledCache;
            synchronized (map) {
                demangledCache.put(string2, string3);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> demangle(List<String> list) {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String object2 : list) {
            arrayList.add(CppSymbolDemanglerImpl.stripModuleAndOffset(object2));
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        Map<String, String> map = demangledCache;
        synchronized (map) {
            for (n = 0; n < arrayList.size(); ++n) {
                String n2 = (String)arrayList.get(n);
                if (!this.isMangled(n2)) continue;
                string = demangledCache.get(n2);
                if (string == null) {
                    arrayList2.add(n2);
                    arrayList3.add(n);
                    continue;
                }
                arrayList.set(n, string);
            }
        }
        if (!arrayList2.isEmpty()) {
            this.demangleImpl(arrayList2);
            map = demangledCache;
            synchronized (map) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    int n2 = (Integer)arrayList3.get(n);
                    string = (String)arrayList.get(n2);
                    String string2 = (String)arrayList2.get(n);
                    demangledCache.put(string, string2);
                    arrayList.set(n2, string2);
                }
            }
        }
        return arrayList;
    }

    private boolean isMangled(String string) {
        return 0 < string.length() && string.charAt(0) == '_' || 0 <= string.indexOf("__");
    }

    private static String stripModuleAndOffset(String string) {
        int n;
        int n2 = string.indexOf(43);
        if (0 <= n2) {
            string = string.substring(0, n2);
        }
        if (0 <= (n = string.indexOf(96))) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void demangleImpl(List<String> list) {
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
        nativeProcessBuilder.setExecutable(this.demanglerTool);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outLineBased(true);
        final ArrayList arrayList = new ArrayList();
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string;
            int n = listIterator.nextIndex();
            for (int i = this.demanglerTool.length(); listIterator.hasNext() && i < 2000; i += string.length() + 3) {
                string = listIterator.next();
                listIterator.set(string);
            }
            int n2 = listIterator.nextIndex();
            List<String> list2 = list.subList(n, n2);
            nativeProcessBuilder = nativeProcessBuilder.setArguments(list2.toArray(new String[list2.size()]));
            executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                    return InputProcessors.bridge((LineProcessor)new DemanglerLineProcessor(arrayList));
                }
            });
            ExecutionService executionService = ExecutionService.newService((Callable)nativeProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)"Batch demangling");
            Future future = executionService.run();
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            if (list2.size() == arrayList.size()) {
                for (int i = 0; i < list2.size(); ++i) {
                    list2.set(i, (String)arrayList.get(i));
                }
            }
            arrayList.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DemanglerLineProcessor
    implements LineProcessor {
        private final List<String> output;

        public DemanglerLineProcessor(List<String> list) {
            this.output = list;
        }

        public void processLine(String string) {
            if (0 < string.length()) {
                int n;
                if (CppSymbolDemanglerImpl.this.cppCompiler == CppSymbolDemanglerFactory.CPPCompiler.SS && 0 <= (n = string.indexOf(CppSymbolDemanglerImpl.EQUALS_EQUALS))) {
                    string = string.substring(n + CppSymbolDemanglerImpl.EQUALS_EQUALS.length());
                }
                this.output.add(string);
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

