/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricsFactory;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLStackStorage {
    public static final List<FunctionMetric> METRICS = Arrays.asList(FunctionMetric.CpuTimeExclusiveMetric, FunctionMetric.CpuTimeInclusiveMetric);
    protected final SQLDataStorage sqlStorage;
    private final Map<CharSequence, Integer> funcCache;
    private final Map<NodeCacheKey, Integer> nodeCache;
    private int funcIdSequence;
    private int nodeIdSequence;
    private final ExecutorThread executor;
    private boolean isRunning = true;
    private final CppSymbolDemangler demangler;

    public SQLStackStorage(SQLDataStorage sQLDataStorage) throws SQLException, IOException {
        this.sqlStorage = sQLDataStorage;
        this.initTables();
        this.funcCache = new HashMap<CharSequence, Integer>();
        this.nodeCache = new HashMap<NodeCacheKey, Integer>();
        this.funcIdSequence = 0;
        this.nodeIdSequence = 0;
        this.executor = new ExecutorThread();
        this.executor.setPriority(1);
        this.executor.start();
        CppSymbolDemanglerFactory cppSymbolDemanglerFactory = (CppSymbolDemanglerFactory)Lookup.getDefault().lookup(CppSymbolDemanglerFactory.class);
        this.demangler = cppSymbolDemanglerFactory != null ? cppSymbolDemanglerFactory.getForCurrentSession() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTables() throws SQLException, IOException {
        InputStream inputStream = SQLStackStorage.class.getClassLoader().getResourceAsStream("org/netbeans/modules/dlight/core/stack/resource/schema.sql");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            this.sqlStorage.execute(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
    }

    public boolean shutdown() {
        this.isRunning = false;
        this.funcCache.clear();
        this.nodeCache.clear();
        return true;
    }

    public int putStack(List<CharSequence> list, long l) {
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            boolean bl = i + 1 == list.size();
            CharSequence charSequence = list.get(i);
            int n2 = this.generateFuncId(charSequence);
            this.updateMetrics(n2, false, l, !hashSet.contains(n2), bl);
            hashSet.add(n2);
            int n3 = this.generateNodeId(n, n2, this.getOffset(charSequence));
            this.updateMetrics(n3, true, l, true, bl);
            n = n3;
        }
        return n;
    }

    public void flush() throws InterruptedException {
        this.executor.flush();
    }

    public List<Long> getPeriodicStacks(long l, long l2, long l3) throws SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        PreparedStatement preparedStatement = this.sqlStorage.prepareStatement("SELECT time_stamp FROM CallStack WHERE ? <= time_stamp AND time_stamp < ? ORDER BY time_stamp");
        preparedStatement.setMaxRows(1);
        for (long i = l; i < l2; i += l3) {
            long l4 = Math.min(i + l3, l2);
            preparedStatement.setLong(1, i);
            preparedStatement.setLong(2, l4);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                arrayList.add(resultSet.getLong(1));
            }
            resultSet.close();
        }
        return arrayList;
    }

    public List<FunctionMetric> getMetricsList() {
        return METRICS;
    }

    public List<FunctionCall> getCallers(FunctionCall[] functionCallArray, boolean bl) throws SQLException {
        ArrayList<FunctionCall> arrayList = new ArrayList<FunctionCall>();
        PreparedStatement preparedStatement = this.prepareCallersSelect(functionCallArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
            hashMap.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(resultSet.getLong(4)));
            hashMap.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(resultSet.getLong(5)));
            String string = resultSet.getString(2);
            if (this.demangler != null) {
                string = this.demangler.demangle(string);
            }
            arrayList.add(new FunctionCallImpl((Function)new FunctionImpl(resultSet.getInt(1), string, resultSet.getString(3)), hashMap));
        }
        resultSet.close();
        return arrayList;
    }

    public List<FunctionCall> getCallees(FunctionCall[] functionCallArray, boolean bl) throws SQLException {
        ArrayList<FunctionCall> arrayList = new ArrayList<FunctionCall>();
        PreparedStatement preparedStatement = this.prepareCalleesSelect(functionCallArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
            hashMap.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(resultSet.getLong(4)));
            hashMap.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(resultSet.getLong(5)));
            String string = resultSet.getString(2);
            if (this.demangler != null) {
                string = this.demangler.demangle(string);
            }
            arrayList.add(new FunctionCallImpl((Function)new FunctionImpl(resultSet.getInt(1), string, resultSet.getString(3)), hashMap));
        }
        resultSet.close();
        return arrayList;
    }

    public List<FunctionCall> getHotSpotFunctions(FunctionMetric functionMetric, int n) {
        try {
            List<String> list = new ArrayList();
            ArrayList<FunctionCall> arrayList = new ArrayList<FunctionCall>();
            PreparedStatement preparedStatement = this.sqlStorage.prepareStatement("SELECT func_id, func_name, func_full_name,  time_incl, time_excl FROM Func ORDER BY " + functionMetric.getMetricID() + " DESC");
            preparedStatement.setMaxRows(n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
                hashMap.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(resultSet.getLong(4)));
                hashMap.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(resultSet.getLong(5)));
                String string = resultSet.getString(2);
                list.add(string);
                arrayList.add(new FunctionCallImpl((Function)new FunctionImpl(resultSet.getInt(1), string, resultSet.getString(3)), hashMap));
            }
            resultSet.close();
            if (this.demangler != null && (list = this.demangler.demangle(list)).size() == arrayList.size()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((FunctionImpl)((FunctionCall)arrayList.get(i)).getFunction()).setName((String)list.get(i));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            return Collections.emptyList();
        }
    }

    public List<FunctionCall> getFunctionsList(DataTableMetadata dataTableMetadata, List<DataTableMetadata.Column> list, FunctionDatatableDescription functionDatatableDescription) {
        try {
            Object object;
            Object object222;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object222 : list) {
                object = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetric.FunctionMetricConfiguration(object222.getColumnName(), object222.getColumnUName(), object222.getColumnClass()));
                arrayList.add(object);
            }
            String string = functionDatatableDescription.getNameColumn();
            object222 = functionDatatableDescription.getOffsetColumn();
            object = functionDatatableDescription.getUniqueColumnName();
            List<Object> list2 = new ArrayList();
            ArrayList<FunctionCall> arrayList2 = new ArrayList<FunctionCall>();
            PreparedStatement preparedStatement = this.sqlStorage.prepareStatement(dataTableMetadata.getViewStatement());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
                for (FunctionMetric functionMetric : arrayList) {
                    try {
                        resultSet.findColumn(functionMetric.getMetricID());
                        Object object3 = resultSet.getObject(functionMetric.getMetricID());
                        if (functionMetric.getMetricValueClass() == Time.class && object3 != null) {
                            object3 = new Time(Long.valueOf(object3 + "").longValue());
                        }
                        hashMap.put(functionMetric, object3);
                    }
                    catch (SQLException sQLException) {}
                }
                String string2 = resultSet.getString(string);
                list2.add(string2);
                arrayList2.add(new FunctionCallImpl(new FunctionImpl(resultSet.getInt((String)object), string2, string2), object222 != null ? resultSet.getLong((String)object222) : -1L, hashMap));
            }
            resultSet.close();
            if (this.demangler != null && (list2 = this.demangler.demangle(list2)).size() == arrayList2.size()) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((FunctionImpl)((FunctionCall)arrayList2.get(i)).getFunction()).setName((String)list2.get(i));
                }
            }
            return arrayList2;
        }
        catch (SQLException sQLException) {
            return Collections.emptyList();
        }
    }

    private void updateMetrics(int n, boolean bl, long l, boolean bl2, boolean bl3) {
        if (0L < l) {
            UpdateMetrics updateMetrics = new UpdateMetrics();
            updateMetrics.objId = n;
            updateMetrics.funcOrNode = bl;
            if (bl2) {
                updateMetrics.cpuTimeInclusive = l;
            }
            if (bl3) {
                updateMetrics.cpuTimeExclusive = l;
            }
            this.executor.submitCommand(updateMetrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateNodeId(int n, int n2, long l) {
        Map<NodeCacheKey, Integer> map = this.nodeCache;
        synchronized (map) {
            NodeCacheKey nodeCacheKey = new NodeCacheKey(n, n2, l);
            Integer n3 = this.nodeCache.get(nodeCacheKey);
            if (n3 == null) {
                n3 = ++this.nodeIdSequence;
                AddNode addNode = new AddNode();
                addNode.id = n3;
                addNode.callerId = n;
                addNode.funcId = n2;
                addNode.offset = l;
                this.executor.submitCommand(addNode);
                this.nodeCache.put(nodeCacheKey, n3);
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateFuncId(CharSequence charSequence) {
        int n = this.lastIndexOf(charSequence, '+');
        if (0 <= n) {
            charSequence = charSequence.subSequence(0, n);
        }
        Map<CharSequence, Integer> map = this.funcCache;
        synchronized (map) {
            Integer n2 = this.funcCache.get(charSequence);
            if (n2 == null) {
                n2 = ++this.funcIdSequence;
                AddFunction addFunction = new AddFunction();
                addFunction.id = n2;
                addFunction.name = charSequence;
                this.executor.submitCommand(addFunction);
                this.funcCache.put(charSequence, n2);
            }
            return n2;
        }
    }

    private long getOffset(CharSequence charSequence) {
        int n = this.lastIndexOf(charSequence, '+');
        if (0 <= n) {
            try {
                return Long.parseLong(((Object)charSequence.subSequence(n + 3, charSequence.length())).toString(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private int lastIndexOf(CharSequence charSequence, char c) {
        for (int i = charSequence.length() - 1; 0 <= i; --i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private PreparedStatement prepareCallersSelect(FunctionCall[] functionCallArray) throws SQLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT F.func_id, F.func_name, F.func_full_name, SUM(N.time_incl), SUM(N.time_excl) FROM Node AS N ");
        stringBuilder.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id ");
        stringBuilder.append(" INNER JOIN Node N1 ON N.node_id = N1.caller_id ");
        for (n = 1; n < functionCallArray.length; ++n) {
            stringBuilder.append(" INNER JOIN Node AS N").append(n + 1);
            stringBuilder.append(" ON N").append(n).append(".node_id = N").append(n + 1).append(".caller_id ");
        }
        stringBuilder.append(" WHERE ");
        for (n = 1; n <= functionCallArray.length; ++n) {
            if (1 < n) {
                stringBuilder.append("AND ");
            }
            stringBuilder.append("N").append(n).append(".func_id = ? ");
        }
        stringBuilder.append(" GROUP BY F.func_id, F.func_name, F.func_full_name");
        PreparedStatement preparedStatement = this.sqlStorage.prepareStatement(stringBuilder.toString());
        for (int i = 0; i < functionCallArray.length; ++i) {
            preparedStatement.setInt(i + 1, ((FunctionImpl)functionCallArray[i].getFunction()).getId());
        }
        return preparedStatement;
    }

    private PreparedStatement prepareCalleesSelect(FunctionCall[] functionCallArray) throws SQLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT F.func_id, F.func_name, F.func_full_name, SUM(N.time_incl), SUM(N.time_excl) FROM Node AS N1 ");
        for (n = 1; n < functionCallArray.length; ++n) {
            stringBuilder.append(" INNER JOIN Node AS N").append(n + 1);
            stringBuilder.append(" ON N").append(n).append(".node_id = N").append(n + 1).append(".caller_id ");
        }
        stringBuilder.append(" INNER JOIN Node N ON N").append(functionCallArray.length).append(".node_id = N.caller_id ");
        stringBuilder.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id WHERE ");
        for (n = 1; n <= functionCallArray.length; ++n) {
            if (1 < n) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(" N").append(n).append(".func_id = ? ");
        }
        stringBuilder.append(" GROUP BY F.func_id, F.func_name, F.func_full_name");
        PreparedStatement preparedStatement = this.sqlStorage.prepareStatement(stringBuilder.toString());
        for (int i = 0; i < functionCallArray.length; ++i) {
            preparedStatement.setInt(i + 1, ((FunctionImpl)functionCallArray[i].getFunction()).getId());
        }
        return preparedStatement;
    }

    private class ExecutorThread
    extends Thread {
        private static final int MAX_COMMANDS = 1000;
        private static final long SLEEP_INTERVAL = 200L;
        private final LinkedBlockingQueue<Object> queue;

        public ExecutorThread() {
            this.setName("DLIGTH: SQLStackStorage executor thread");
            this.queue = new LinkedBlockingQueue();
        }

        public void submitCommand(Object object) {
            this.queue.offer(object);
        }

        public synchronized void flush() throws InterruptedException {
            while (!this.queue.isEmpty()) {
                this.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                LinkedList linkedList = new LinkedList();
                while (SQLStackStorage.this.isRunning) {
                    ExecutorThread executorThread = this;
                    synchronized (executorThread) {
                        UpdateMetrics updateMetrics;
                        HashMap hashMap3;
                        Object object3;
                        Object object2;
                        this.queue.drainTo(linkedList, 1000);
                        Iterator iterator = linkedList.iterator();
                        while (iterator.hasNext()) {
                            if (!SQLStackStorage.this.isRunning) {
                                return;
                            }
                            object2 = iterator.next();
                            if (!(object2 instanceof UpdateMetrics)) continue;
                            object3 = (UpdateMetrics)object2;
                            hashMap3 = ((UpdateMetrics)object3).funcOrNode ? hashMap2 : hashMap;
                            updateMetrics = (UpdateMetrics)hashMap3.get(((UpdateMetrics)object3).objId);
                            if (updateMetrics == null) {
                                hashMap3.put(((UpdateMetrics)object3).objId, object3);
                            } else {
                                updateMetrics.add((UpdateMetrics)object3);
                            }
                            iterator.remove();
                        }
                        iterator = linkedList.iterator();
                        while (iterator.hasNext()) {
                            if (!SQLStackStorage.this.isRunning) {
                                return;
                            }
                            object2 = iterator.next();
                            try {
                                if (object2 instanceof AddFunction) {
                                    object3 = (AddFunction)object2;
                                    hashMap3 = SQLStackStorage.this.sqlStorage.prepareStatement("INSERT INTO Func (func_id, func_full_name, func_name, time_incl, time_excl) VALUES (?, ?, ?, ?, ?)");
                                    hashMap3.setInt(1, ((AddFunction)object3).id);
                                    hashMap3.setString(2, ((Object)((AddFunction)object3).name).toString());
                                    hashMap3.setString(3, ((Object)((AddFunction)object3).name).toString());
                                    updateMetrics = (UpdateMetrics)hashMap.remove(((AddFunction)object3).id);
                                    if (updateMetrics == null) {
                                        hashMap3.setLong(4, 0L);
                                        hashMap3.setLong(5, 0L);
                                    } else {
                                        hashMap3.setLong(4, updateMetrics.cpuTimeInclusive);
                                        hashMap3.setLong(5, updateMetrics.cpuTimeExclusive);
                                    }
                                    hashMap3.executeUpdate();
                                    continue;
                                }
                                if (!(object2 instanceof AddNode)) continue;
                                object3 = (AddNode)object2;
                                hashMap3 = SQLStackStorage.this.sqlStorage.prepareStatement("INSERT INTO Node (node_id, caller_id, func_id, offset, time_incl, time_excl) VALUES (?, ?, ?, ?, ?, ?)");
                                hashMap3.setInt(1, ((AddNode)object3).id);
                                hashMap3.setInt(2, ((AddNode)object3).callerId);
                                hashMap3.setInt(3, ((AddNode)object3).funcId);
                                hashMap3.setLong(4, ((AddNode)object3).offset);
                                updateMetrics = (UpdateMetrics)hashMap2.remove(((AddNode)object3).id);
                                if (updateMetrics == null) {
                                    hashMap3.setLong(5, 0L);
                                    hashMap3.setLong(6, 0L);
                                } else {
                                    hashMap3.setLong(5, updateMetrics.cpuTimeInclusive);
                                    hashMap3.setLong(6, updateMetrics.cpuTimeExclusive);
                                }
                                hashMap3.executeUpdate();
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                            }
                        }
                        linkedList.clear();
                        for (Object object3 : hashMap.values()) {
                            try {
                                hashMap3 = SQLStackStorage.this.sqlStorage.prepareStatement("UPDATE Func SET time_incl = time_incl + ?, time_excl = time_excl + ? WHERE func_id = ?");
                                hashMap3.setLong(1, ((UpdateMetrics)object3).cpuTimeInclusive);
                                hashMap3.setLong(2, ((UpdateMetrics)object3).cpuTimeExclusive);
                                hashMap3.setInt(3, ((UpdateMetrics)object3).objId);
                                hashMap3.executeUpdate();
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                            }
                        }
                        hashMap.clear();
                        for (Object object3 : hashMap2.values()) {
                            try {
                                hashMap3 = SQLStackStorage.this.sqlStorage.prepareStatement("UPDATE Node SET time_incl = time_incl + ?, time_excl = time_excl + ? WHERE node_id = ?");
                                hashMap3.setLong(1, ((UpdateMetrics)object3).cpuTimeInclusive);
                                hashMap3.setLong(2, ((UpdateMetrics)object3).cpuTimeExclusive);
                                hashMap3.setInt(3, ((UpdateMetrics)object3).objId);
                                hashMap3.executeUpdate();
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                            }
                        }
                        hashMap2.clear();
                        this.notifyAll();
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private static class UpdateMetrics {
        public int objId;
        public boolean funcOrNode;
        public long cpuTimeInclusive;
        public long cpuTimeExclusive;

        private UpdateMetrics() {
        }

        public void add(UpdateMetrics updateMetrics) {
            this.cpuTimeInclusive += updateMetrics.cpuTimeInclusive;
            this.cpuTimeExclusive += updateMetrics.cpuTimeExclusive;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.funcOrNode ? "func" : "node");
            stringBuilder.append(" id=").append(this.objId);
            stringBuilder.append(": time_incl+=").append(this.cpuTimeInclusive);
            stringBuilder.append(", time_excl+=").append(this.cpuTimeExclusive);
            return stringBuilder.toString();
        }
    }

    private static class AddNode {
        public int id;
        public int callerId;
        public int funcId;
        public long offset;

        private AddNode() {
        }
    }

    private static class AddFunction {
        public int id;
        public CharSequence name;

        private AddFunction() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FunctionCallImpl
    extends FunctionCall {
        private final Map<FunctionMetric, Object> metrics;

        FunctionCallImpl(Function function, long l, Map<FunctionMetric, Object> map) {
            super(function, l);
            this.metrics = map;
        }

        FunctionCallImpl(Function function, Map<FunctionMetric, Object> map) {
            this(function, 0L, map);
        }

        @Override
        public String getDisplayedName() {
            return this.getFunction().getName() + (this.hasOffset() ? "+0x" + this.getOffset() : "");
        }

        @Override
        public Object getMetricValue(FunctionMetric functionMetric) {
            return this.metrics.get(functionMetric);
        }

        @Override
        public Object getMetricValue(String string) {
            for (FunctionMetric functionMetric : this.metrics.keySet()) {
                if (!functionMetric.getMetricID().equals(string)) continue;
                return this.metrics.get(functionMetric);
            }
            return null;
        }

        @Override
        public boolean hasMetric(String string) {
            for (FunctionMetric functionMetric : this.metrics.keySet()) {
                if (!functionMetric.getMetricID().equals(string)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FunctionCall{ function=").append(this.getFunction());
            stringBuilder.append(", metrics=").append(this.metrics).append(" }");
            return stringBuilder.toString();
        }
    }

    protected static class FunctionImpl
    implements Function {
        private final int id;
        private String name;
        private final String quilifiedName;

        public FunctionImpl(int n, String string, String string2) {
            this.id = n;
            this.name = string;
            this.quilifiedName = string2;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String string) {
            this.name = string;
        }

        public String getQuilifiedName() {
            return this.quilifiedName;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class NodeCacheKey {
        private final int callerId;
        private final int funcId;
        private long offset;

        public NodeCacheKey(int n, int n2, long l) {
            this.callerId = n;
            this.funcId = n2;
            this.offset = l;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NodeCacheKey)) {
                return false;
            }
            NodeCacheKey nodeCacheKey = (NodeCacheKey)object;
            return this.callerId == nodeCacheKey.callerId && this.funcId == nodeCacheKey.funcId && this.offset == nodeCacheKey.offset;
        }

        public int hashCode() {
            return 13 * this.callerId + 17 * this.funcId + ((int)(this.offset >> 32) | (int)this.offset);
        }
    }
}

