/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOrderingController
implements InspectorOrderingController {
    private static final Comparator<InspectorFolder> DEFAULT_STRING_COMPARATOR = new Comparator<InspectorFolder>(){

        @Override
        public int compare(InspectorFolder inspectorFolder, InspectorFolder inspectorFolder2) {
            return inspectorFolder.getDisplayName().compareTo(inspectorFolder2.getDisplayName());
        }
    };
    private Integer order;
    private List<TypeID> types;

    public DefaultOrderingController(Integer n, TypeID ... typeIDArray) {
        if (typeIDArray == null) {
            throw new IllegalArgumentException("types argument cant be null");
        }
        this.order = n;
        this.types = Arrays.asList(typeIDArray);
    }

    @Override
    public List<InspectorFolder> getOrdered(DesignComponent designComponent, Collection<InspectorFolder> collection) {
        ArrayList<InspectorFolder> arrayList = new ArrayList<InspectorFolder>(collection);
        Collections.sort(arrayList, DEFAULT_STRING_COMPARATOR);
        return arrayList;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public boolean isTypeIDSupported(DesignDocument designDocument, TypeID typeID) {
        return this.types.contains(typeID);
    }
}

