/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.TreeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportAnalysis2 {
    private Elements elements;
    private TreeFactory make;
    private List<ImportTree> imports;
    private Set<Element> imported;
    private Stack<Set<Element>> visibleThroughClasses;
    private Map<String, Element> simpleNames2Elements;
    private PackageElement unnamedPackage;
    private PackageElement pack;
    private ASTService model;
    private CompilationUnitTree cut;
    private Set<String> usedClassesFromJavaLangCache;
    private Set<String> javaLangElements;
    private PackageElement javaLang;

    public ImportAnalysis2(Context context) {
        this.elements = JavacElements.instance(context);
        this.make = TreeFactory.instance(context);
        this.unnamedPackage = Symtab.instance((Context)context).unnamedPackage;
        this.model = ASTService.instance(context);
    }

    public void setCompilationUnit(CompilationUnitTree compilationUnitTree) {
        this.cut = compilationUnitTree;
    }

    public void setPackage(ExpressionTree expressionTree) {
        if (expressionTree == null) {
            this.pack = this.unnamedPackage;
            return;
        }
        String string = this.getFQN(expressionTree);
        this.pack = this.elements.getPackageElement(string);
    }

    public void setImports(List<? extends ImportTree> list) {
        this.imports = new ArrayList<ImportTree>();
        this.imported = new HashSet<Element>();
        this.simpleNames2Elements = new HashMap<String, Element>();
        this.visibleThroughClasses = new Stack();
        this.usedClassesFromJavaLangCache = null;
        for (ImportTree object : list) {
            this.addImport(object, false);
        }
        this.javaLangElements = new HashSet<String>();
        this.javaLang = this.elements.getPackageElement("java.lang");
        if (this.javaLang != null) {
            for (Element element : this.javaLang.getEnclosedElements()) {
                this.javaLangElements.add(element.getSimpleName().toString());
            }
        }
    }

    public List<? extends ImportTree> getImports() {
        return this.imports;
    }

    public void classEntered(ClassTree classTree) {
        HashSet<Element> hashSet = new HashSet<Element>();
        hashSet.add(this.model.getElement(classTree));
        this.addAll(classTree.getExtendsClause(), hashSet);
        for (Tree tree : classTree.getImplementsClause()) {
            this.addAll(tree, hashSet);
        }
        for (Tree tree : classTree.getMembers()) {
            Element element;
            if (tree.getKind() != Tree.Kind.CLASS || (element = this.model.getElement(tree)) == null) continue;
            hashSet.add(element);
        }
        this.visibleThroughClasses.push(hashSet);
    }

    public void classLeft() {
        this.visibleThroughClasses.pop();
    }

    private String getFQN(ImportTree importTree) {
        return this.getFQN(importTree.getQualifiedIdentifier());
    }

    private String getFQN(Tree tree) {
        final StringBuffer stringBuffer = new StringBuffer();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void void_) {
                super.visitMemberSelect(memberSelectTree, void_);
                stringBuffer.append('.');
                stringBuffer.append(memberSelectTree.getIdentifier().toString());
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
                stringBuffer.append(identifierTree.getName().toString());
                return null;
            }
        }.scan(tree, null);
        return stringBuffer.toString();
    }

    private void addImport(ImportTree importTree, boolean bl) {
        Object object;
        List<TypeElement> list;
        String string = this.getFQN(importTree);
        if (!importTree.isStatic()) {
            TypeElement typeElement = this.elements.getTypeElement(string);
            if (typeElement != null) {
                this.imported.add(typeElement);
                this.simpleNames2Elements.put(typeElement.getSimpleName().toString(), typeElement);
            } else if (string.endsWith(".*")) {
                string = string.substring(0, string.length() - 2);
                list = Collections.emptyList();
                object = this.elements.getTypeElement(string);
                if (object != null) {
                    list = ElementFilter.typesIn(object.getEnclosedElements());
                } else {
                    PackageElement packageElement = this.elements.getPackageElement(string);
                    if (packageElement != null) {
                        list = ElementFilter.typesIn(packageElement.getEnclosedElements());
                    }
                }
                for (TypeElement typeElement2 : list) {
                    this.imported.add(typeElement2);
                    this.simpleNames2Elements.put(typeElement2.getSimpleName().toString(), typeElement2);
                }
            }
        } else {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                TypeElement typeElement2;
                list = string.substring(0, n);
                object = string.substring(n + 1);
                boolean bl2 = "*".equals(object);
                typeElement2 = this.elements.getTypeElement((CharSequence)((Object)list));
                if (typeElement2 != null) {
                    for (Element element : typeElement2.getEnclosedElements()) {
                        if (!element.getModifiers().contains((Object)Modifier.STATIC) || !bl2 && !((String)object).contains(element.getSimpleName().toString())) continue;
                        this.imported.add(element);
                        this.simpleNames2Elements.put(element.getSimpleName().toString(), element);
                    }
                }
            }
        }
        if (!bl) {
            this.imports.add(importTree);
        } else {
            int n = -1;
            int n2 = 0;
            while (n2 < this.imports.size() && ((String)(object = this.getFQN(this.imports.get(n2)))).compareTo(string) < 0) {
                n = n2++;
            }
            this.imports.add(n + 1, importTree);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExpressionTree resolveImport(MemberSelectTree memberSelectTree, Element element) {
        void var4_7;
        boolean bl;
        Object object2;
        if (this.visibleThroughClasses == null) {
            return memberSelectTree;
        }
        if (element.getKind() == ElementKind.PACKAGE) {
            return this.make.MemberSelect(memberSelectTree.getExpression(), memberSelectTree.getIdentifier());
        }
        for (Set object42 : this.visibleThroughClasses) {
            if (!object42.contains(element)) continue;
            return this.make.Identifier(element.getSimpleName());
        }
        String string = element.getSimpleName().toString();
        Element element2 = this.simpleNames2Elements.get(string);
        if (element2 == null) {
            block1: for (Set set : this.visibleThroughClasses) {
                for (Object object2 : set) {
                    if (object2 == null || object2.getSimpleName() == null || !string.equals(object2.getSimpleName().toString())) continue;
                    Element element3 = object2;
                    break block1;
                }
            }
        }
        boolean bl2 = bl = var4_7 != null && !((Object)element).equals(var4_7);
        if (!bl && (element.getKind().isClass() || element.getKind().isInterface())) {
            Element element4 = element.getEnclosingElement();
            if (this.pack != null && this.pack.equals(element4)) {
                return this.make.Identifier(element.getSimpleName());
            }
        }
        if (this.imported.contains(element)) {
            return this.make.Identifier(element.getSimpleName());
        }
        if (this.elements.getPackageOf(element) != null && this.elements.getPackageOf(element).isUnnamed()) {
            if (memberSelectTree.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                return this.make.MemberSelect(this.resolveImport((MemberSelectTree)memberSelectTree.getExpression(), element.getEnclosingElement()), element.getSimpleName());
            }
            return memberSelectTree;
        }
        if (!bl && this.javaLangElements.contains(string) && !((Object)element.getEnclosingElement()).equals(this.javaLang)) {
            bl = this.getUsedClassesFromJavaLang().contains(string);
        }
        if (bl) {
            if (element.getEnclosingElement().getKind().isClass() || element.getEnclosingElement().getKind().isInterface() && memberSelectTree.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                return this.make.MemberSelect(this.resolveImport((MemberSelectTree)memberSelectTree.getExpression(), element.getEnclosingElement()), memberSelectTree.getIdentifier());
            }
            return this.make.MemberSelect(memberSelectTree.getExpression(), memberSelectTree.getIdentifier());
        }
        if (!element.getKind().isClass() && !element.getKind().isInterface()) {
            void var6_15;
            ExpressionTree expressionTree = memberSelectTree.getExpression();
            if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree expressionTree2 = this.resolveImport((MemberSelectTree)expressionTree, element.getEnclosingElement());
            }
            return this.make.MemberSelect((ExpressionTree)var6_15, memberSelectTree.getIdentifier());
        }
        TypeElement typeElement = (TypeElement)element;
        Element element5 = typeElement.getEnclosingElement();
        if (element5.getKind() == ElementKind.PACKAGE && "java.lang".equals(((PackageElement)element5).getQualifiedName().toString())) {
            return this.make.Identifier(element.getSimpleName());
        }
        object2 = this.make.QualIdentImpl(element);
        this.addImport(this.make.Import((Tree)object2, false), true);
        return this.make.Identifier(element.getSimpleName());
    }

    private void addAll(Tree tree, Set<Element> set) {
        if (tree == null) {
            return;
        }
        Symbol symbol = null;
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            symbol = ((JCTree.JCFieldAccess)tree).sym;
        } else if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            symbol = ((JCTree.JCIdent)tree).sym;
        }
        if (symbol == null) {
            return;
        }
        set.addAll(symbol.getEnclosedElements());
    }

    private Set<String> getUsedClassesFromJavaLang() {
        if (this.usedClassesFromJavaLangCache != null) {
            return this.usedClassesFromJavaLangCache;
        }
        this.usedClassesFromJavaLangCache = new HashSet<String>();
        if (this.javaLang != null) {
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
                    Element element = ImportAnalysis2.this.model.getElement(identifierTree);
                    if (element != null && ImportAnalysis2.this.javaLang.equals(element.getEnclosingElement())) {
                        ImportAnalysis2.this.usedClassesFromJavaLangCache.add(element.getSimpleName().toString());
                    }
                    return null;
                }
            }.scan(this.cut, null);
        }
        return this.usedClassesFromJavaLangCache;
    }
}

