/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.MemoryFileManager;
import org.netbeans.modules.java.source.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFileManager
implements JavaFileManager {
    private static final JavaFileManager.Location ALL = new JavaFileManager.Location(){

        public String getName() {
            return "ALL";
        }

        public boolean isOutputLocation() {
            return false;
        }
    };
    private final JavaFileManager bootPath;
    private final JavaFileManager classPath;
    private final JavaFileManager sourcePath;
    private final MemoryFileManager memoryFileManager;
    private final JavaFileManager outputhPath;
    private JavaFileObject lastInfered;
    private String lastInferedResult;
    private static final Logger LOG = Logger.getLogger(ProxyFileManager.class.getName());

    public ProxyFileManager(JavaFileManager javaFileManager, JavaFileManager javaFileManager2, JavaFileManager javaFileManager3, JavaFileManager javaFileManager4) {
        this(javaFileManager, javaFileManager2, javaFileManager3, javaFileManager4, null);
    }

    public ProxyFileManager(JavaFileManager javaFileManager, JavaFileManager javaFileManager2, JavaFileManager javaFileManager3, JavaFileManager javaFileManager4, MemoryFileManager memoryFileManager) {
        assert (javaFileManager != null);
        assert (javaFileManager2 != null);
        assert (memoryFileManager == null || javaFileManager3 != null);
        this.bootPath = javaFileManager;
        this.classPath = javaFileManager2;
        this.sourcePath = javaFileManager3;
        this.memoryFileManager = memoryFileManager;
        this.outputhPath = javaFileManager4;
    }

    private JavaFileManager[] getFileManager(JavaFileManager.Location location) {
        if (location == StandardLocation.CLASS_PATH) {
            JavaFileManager[] javaFileManagerArray;
            if (this.outputhPath == null) {
                JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                javaFileManagerArray = javaFileManagerArray2;
                javaFileManagerArray2[0] = this.classPath;
            } else {
                JavaFileManager[] javaFileManagerArray3 = new JavaFileManager[2];
                javaFileManagerArray3[0] = this.classPath;
                javaFileManagerArray = javaFileManagerArray3;
                javaFileManagerArray3[1] = this.outputhPath;
            }
            return javaFileManagerArray;
        }
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return new JavaFileManager[]{this.bootPath};
        }
        if (location == StandardLocation.SOURCE_PATH && this.sourcePath != null) {
            if (this.memoryFileManager != null) {
                return new JavaFileManager[]{this.sourcePath, this.memoryFileManager};
            }
            return new JavaFileManager[]{this.sourcePath};
        }
        if (location == StandardLocation.CLASS_OUTPUT && this.outputhPath != null) {
            return new JavaFileManager[]{this.outputhPath};
        }
        if (location == ALL) {
            JavaFileManager[] javaFileManagerArray;
            if (this.memoryFileManager != null) {
                JavaFileManager[] javaFileManagerArray4;
                if (this.outputhPath == null) {
                    JavaFileManager[] javaFileManagerArray5 = new JavaFileManager[4];
                    javaFileManagerArray5[0] = this.sourcePath;
                    javaFileManagerArray5[1] = this.memoryFileManager;
                    javaFileManagerArray5[2] = this.bootPath;
                    javaFileManagerArray4 = javaFileManagerArray5;
                    javaFileManagerArray5[3] = this.classPath;
                } else {
                    JavaFileManager[] javaFileManagerArray6 = new JavaFileManager[5];
                    javaFileManagerArray6[0] = this.sourcePath;
                    javaFileManagerArray6[1] = this.memoryFileManager;
                    javaFileManagerArray6[2] = this.bootPath;
                    javaFileManagerArray6[3] = this.classPath;
                    javaFileManagerArray4 = javaFileManagerArray6;
                    javaFileManagerArray6[4] = this.outputhPath;
                }
                return javaFileManagerArray4;
            }
            if (this.outputhPath == null) {
                JavaFileManager[] javaFileManagerArray7 = new JavaFileManager[3];
                javaFileManagerArray7[0] = this.sourcePath;
                javaFileManagerArray7[1] = this.bootPath;
                javaFileManagerArray = javaFileManagerArray7;
                javaFileManagerArray7[2] = this.classPath;
            } else {
                JavaFileManager[] javaFileManagerArray8 = new JavaFileManager[4];
                javaFileManagerArray8[0] = this.sourcePath;
                javaFileManagerArray8[1] = this.bootPath;
                javaFileManagerArray8[2] = this.classPath;
                javaFileManagerArray = javaFileManagerArray8;
                javaFileManagerArray8[3] = this.outputhPath;
            }
            return javaFileManagerArray;
        }
        return new JavaFileManager[0];
    }

    private JavaFileManager[] getAllFileManagers() {
        ArrayList<JavaFileManager> arrayList = new ArrayList<JavaFileManager>(4);
        arrayList.add(this.bootPath);
        arrayList.add(this.classPath);
        if (this.sourcePath != null) {
            arrayList.add(this.sourcePath);
        }
        if (this.outputhPath != null) {
            arrayList.add(this.outputhPath);
        }
        return arrayList.toArray(new JavaFileManager[arrayList.size()]);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        LinkedList<Iterable<JavaFileObject>> linkedList = new LinkedList<Iterable<JavaFileObject>>();
        JavaFileManager[] javaFileManagerArray = this.getFileManager(location);
        for (JavaFileManager object : javaFileManagerArray) {
            linkedList.add(object.list(location, string, set, bl));
        }
        Iterable iterable = Iterators.chained(linkedList);
        if (LOG.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                JavaFileObject javaFileObject = (JavaFileObject)iterator.next();
                stringBuilder.append(javaFileObject.toUri().toString());
                stringBuilder.append(", ");
            }
            LOG.finer(String.format("list %s package: %s type: %s found files: [%s]", location.toString(), string, set.toString(), stringBuilder.toString()));
        }
        return iterable;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        JavaFileManager[] javaFileManagerArray;
        for (JavaFileManager javaFileManager : javaFileManagerArray = this.getFileManager(location)) {
            FileObject fileObject = javaFileManager.getFileForInput(location, string, string2);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] javaFileManagerArray = this.getFileManager(location);
        assert (javaFileManagerArray.length <= 1);
        if (javaFileManagerArray.length == 0) {
            return null;
        }
        return javaFileManagerArray[0].getFileForOutput(location, string, string2, fileObject);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public void flush() throws IOException {
        JavaFileManager[] javaFileManagerArray;
        for (JavaFileManager javaFileManager : javaFileManagerArray = this.getAllFileManagers()) {
            javaFileManager.flush();
        }
    }

    @Override
    public void close() throws IOException {
        JavaFileManager[] javaFileManagerArray;
        for (JavaFileManager javaFileManager : javaFileManagerArray = this.getAllFileManagers()) {
            javaFileManager.close();
        }
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        for (JavaFileManager javaFileManager : this.getFileManager(ALL)) {
            if (!javaFileManager.handleOption(string, iterator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH || location == StandardLocation.SOURCE_PATH || location == StandardLocation.CLASS_OUTPUT;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        JavaFileManager[] javaFileManagerArray;
        for (JavaFileManager javaFileManager : javaFileManagerArray = this.getFileManager(location)) {
            JavaFileObject javaFileObject = javaFileManager.getJavaFileForInput(location, string, kind);
            if (javaFileObject == null) continue;
            return javaFileObject;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] javaFileManagerArray = this.getFileManager(location);
        assert (javaFileManagerArray.length <= 1);
        if (javaFileManagerArray.length == 0) {
            return null;
        }
        return javaFileManagerArray[0].getJavaFileForOutput(location, string, kind, fileObject);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        JavaFileManager[] javaFileManagerArray;
        String string;
        assert (javaFileObject != null);
        if (javaFileObject == this.lastInfered) {
            return this.lastInferedResult;
        }
        if (javaFileObject instanceof FileObjects.InferableJavaFileObject && (string = (javaFileManagerArray = (JavaFileManager[])javaFileObject).inferBinaryName()) != null) {
            this.lastInfered = javaFileObject;
            this.lastInferedResult = string;
            return string;
        }
        for (JavaFileManager javaFileManager : javaFileManagerArray = this.getFileManager(location)) {
            string = javaFileManager.inferBinaryName(location, javaFileObject);
            if (string == null || string.length() <= 0) continue;
            this.lastInfered = javaFileObject;
            this.lastInferedResult = string;
            return string;
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        JavaFileManager[] javaFileManagerArray;
        for (JavaFileManager javaFileManager : javaFileManagerArray = this.getFileManager(ALL)) {
            if (!javaFileManager.isSameFile(fileObject, fileObject2)) continue;
            return true;
        }
        return fileObject.toUri().equals(fileObject2.toUri());
    }
}

