/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.ClassNamesForFileOraculum;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.CancelAbort;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javadoc.JavadocClassReader;
import com.sun.tools.javadoc.JavadocMemberEnter;
import com.sun.tools.javadoc.Messager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.PostFlowAnalysis;
import org.netbeans.modules.java.source.TreeLoader;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.parsing.ClasspathInfoListener;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.DefaultJavaFileObjectProvider;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.ErrorHandlingJavadocEnter;
import org.netbeans.modules.java.source.parsing.FindAnonymousVisitor;
import org.netbeans.modules.java.source.parsing.FindMethodRegionsVisitor;
import org.netbeans.modules.java.source.parsing.JavaFileObjectProvider;
import org.netbeans.modules.java.source.parsing.JavacFlowListener;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.java.source.parsing.NewComilerTask;
import org.netbeans.modules.java.source.parsing.NullWriter;
import org.netbeans.modules.java.source.parsing.TranslatePositionsVisitor;
import org.netbeans.modules.java.source.tasklist.CompilerSettings;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacParser
extends Parser {
    private static final Logger TIME_LOGGER = Logger.getLogger("TIMER");
    private static final Logger LOGGER = Logger.getLogger(JavacParser.class.getName());
    public static final String MIME_TYPE = "text/x-java";
    static JavaFileObjectProvider jfoProvider = new DefaultJavaFileObjectProvider();
    private static final PrintWriter DEV_NULL = new PrintWriter((Writer)new NullWriter(), false);
    private static final int MAX_DUMPS = 255;
    private static Map<JavaSource.Phase, String> phase2Message = new HashMap<JavaSource.Phase, String>();
    private final ChangeSupport listeners = new ChangeSupport((Object)this);
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final boolean privateParser;
    private FileObject file;
    private FileObject root;
    private ClasspathInfo cpInfo;
    private final int sourceCount;
    private final boolean supportsReparse;
    private final List<Pair<DocPositionRegion, MethodTree>> positions = Collections.synchronizedList(new LinkedList());
    private Pair<DocPositionRegion, MethodTree> changedMethod;
    private final DocListener listener;
    private final FilterListener filterListener;
    private final ChangeListener cpInfoListener;
    private CompilationInfoImpl ciImpl;
    private boolean initialized;
    private boolean invalid;
    private Snapshot cachedSnapShot;
    private long parseId;
    private ChangeListener weakCpListener;

    JavacParser(Collection<Snapshot> collection, boolean bl) {
        this.privateParser = bl;
        this.sourceCount = collection.size();
        this.supportsReparse = this.sourceCount == 1 && MIME_TYPE.equals(collection.iterator().next().getSource().getMimeType());
        EditorCookie.Observable observable = null;
        JavaFileFilterImplementation javaFileFilterImplementation = null;
        if (this.supportsReparse) {
            org.netbeans.modules.parsing.api.Source source = collection.iterator().next().getSource();
            FileObject fileObject = source.getFileObject();
            if (fileObject != null) {
                javaFileFilterImplementation = JavaFileFilterQuery.getFilter(source.getFileObject());
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)source.getFileObject());
                observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
                if (observable == null) {
                    LOGGER.log(Level.FINE, String.format("File: %s has no EditorCookie.Observable", FileUtil.getFileDisplayName((FileObject)source.getFileObject())));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.FINE, "Invalid DataObject", dataObjectNotFoundException);
            }
        }
        this.filterListener = javaFileFilterImplementation != null ? new FilterListener(javaFileFilterImplementation) : null;
        this.listener = observable != null ? new DocListener(observable) : null;
        this.cpInfoListener = new ClasspathInfoListener(this.listeners);
    }

    private void init(Snapshot snapshot, Task task, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = task instanceof ClasspathInfoProvider && ((ClasspathInfoProvider)task).getClasspathInfo() != null;
        if (!this.initialized) {
            org.netbeans.modules.parsing.api.Source source = snapshot.getSource();
            FileObject fileObject = source.getFileObject();
            assert (fileObject != null);
            this.file = fileObject;
            ClasspathInfo classpathInfo = this.cpInfo;
            this.cpInfo = bl2 ? ((ClasspathInfoProvider)task).getClasspathInfo() : ClasspathInfo.create(fileObject);
            ClassPath classPath = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            assert (classPath != null);
            this.root = classPath.findOwnerRoot(fileObject);
            if (bl) {
                if (classpathInfo != null && this.weakCpListener != null) {
                    classpathInfo.removeChangeListener(this.weakCpListener);
                    this.weakCpListener = null;
                }
                if (!bl2) {
                    this.weakCpListener = WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)this.cpInfo);
                    this.cpInfo.addChangeListener(this.weakCpListener);
                }
                this.initialized = true;
            }
        } else if (bl && !bl2) {
            assert (this.file != null);
            assert (this.cpInfo != null);
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.file, (String)"classpath/source");
            if (classPath != this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)) {
                Project project = FileOwnerQuery.getOwner((FileObject)this.file);
                LOGGER.warning("ClassPath identity changed for " + this.file + ", class path owner: " + (project == null ? "null" : FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " (" + project.getClass() + ")"));
                if (this.weakCpListener != null) {
                    this.cpInfo.removeChangeListener(this.weakCpListener);
                }
                this.cpInfo = ClasspathInfo.create(this.file);
                this.weakCpListener = WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)this.cpInfo);
                this.cpInfo.addChangeListener(this.weakCpListener);
                JavaSourceAccessor.getINSTANCE().invalidateCachedClasspathInfo(this.file);
            }
        }
    }

    public void invalidate() {
        this.invalid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        assert (task != null);
        assert (this.privateParser || Utilities.holdsParserLock());
        ++this.parseId;
        this.canceled.set(false);
        try {
            LOGGER.fine("parse: task: " + task.toString() + "\n" + (snapshot == null ? "null" : snapshot.getText()));
            switch (this.sourceCount) {
                case 0: {
                    ClasspathInfo classpathInfo = null;
                    if (task instanceof ClasspathInfoProvider && (classpathInfo = ((ClasspathInfoProvider)task).getClasspathInfo()) != null) {
                        this.cpInfo = classpathInfo;
                        this.ciImpl = new CompilationInfoImpl(this.cpInfo);
                        break;
                    }
                    throw new IllegalArgumentException("No classpath provided by task: " + task);
                }
                case 1: {
                    this.init(snapshot, task, true);
                    boolean bl = true;
                    if (this.supportsReparse) {
                        Pair<DocPositionRegion, MethodTree> pair;
                        JavacParser javacParser = this;
                        synchronized (javacParser) {
                            pair = this.changedMethod;
                            this.changedMethod = null;
                        }
                        if (pair != null && this.ciImpl != null) {
                            LOGGER.fine("\t:trying partial reparse:\n" + ((DocPositionRegion)((Object)pair.first)).getText());
                            boolean bl2 = bl = !JavacParser.reparseMethod(this.ciImpl, snapshot, (MethodTree)pair.second, ((DocPositionRegion)((Object)pair.first)).getText());
                        }
                    }
                    if (!bl) break;
                    this.ciImpl = JavacParser.createCurrentInfo(this, this.file, this.root, snapshot, null);
                    LOGGER.fine("\t:created new javac");
                    break;
                }
                default: {
                    this.init(snapshot, task, false);
                    this.ciImpl = JavacParser.createCurrentInfo(this, this.file, this.root, snapshot, this.ciImpl == null ? null : this.ciImpl.getJavacTask());
                }
            }
            this.cachedSnapShot = snapshot;
        }
        catch (IOException iOException) {
            throw new ParseException("JavacParser failure", (Throwable)iOException);
        }
    }

    public JavacParserResult getResult(Task task) throws ParseException {
        Object object;
        Object object2;
        assert (this.ciImpl != null);
        assert (this.privateParser || Utilities.holdsParserLock());
        LOGGER.fine("getResult: task:" + task.toString());
        if (this.invalid) {
            LOGGER.fine("\t:invalid, reparse");
            this.invalid = false;
            if (this.cachedSnapShot != null) {
                this.parse(this.cachedSnapShot, task, null);
            }
        }
        boolean bl = task instanceof JavaParserResultTask;
        boolean bl2 = task instanceof ParserResultTask;
        boolean bl3 = task instanceof UserTask;
        boolean bl4 = task instanceof ClasspathInfoProvider;
        if (bl4 && (object2 = ((ClasspathInfoProvider)task).getClasspathInfo()) != null && !object2.equals(this.cpInfo)) {
            if (this.sourceCount != 0) {
                LOGGER.fine("Task " + task + " has changed ClasspathInfo form: " + this.cpInfo + " to:" + object2);
            }
            assert (this.cachedSnapShot != null);
            this.initialized = false;
            this.parse(this.cachedSnapShot, task, null);
        }
        object2 = null;
        if (bl2) {
            JavaSource.Phase phase;
            if (bl) {
                object = ((JavaParserResultTask)task).getPhase();
            } else {
                object = JavaSource.Phase.RESOLVED;
                LOGGER.warning("ParserResultTask: " + task + " doesn't provide phase, assuming RESOLVED");
            }
            try {
                phase = this.moveToPhase((JavaSource.Phase)((Object)object), this.ciImpl, true, false, false);
            }
            catch (IOException iOException) {
                throw new ParseException("JavacParser failure", (Throwable)iOException);
            }
            if (phase.compareTo(object) >= 0) {
                Index.cancel.set(this.canceled);
                object2 = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationInfo(this.ciImpl));
            }
        } else if (bl3) {
            object2 = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationController(this.ciImpl));
        } else {
            LOGGER.warning("Ignoring unknown task: " + task);
        }
        if (task instanceof NewComilerTask && (((NewComilerTask)(object = (NewComilerTask)task)).getCompilationController() == null || ((NewComilerTask)object).getTimeStamp() != this.parseId)) {
            try {
                ((NewComilerTask)object).setCompilationController(JavaSourceAccessor.getINSTANCE().createCompilationController(new CompilationInfoImpl(this, this.file, this.root, null, this.cachedSnapShot, false)), this.parseId);
            }
            catch (IOException iOException) {
                throw new ParseException("Javac Failure", (Throwable)iOException);
            }
        }
        return object2;
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public void resultFinished(boolean bl) {
        if (bl) {
            Index.cancel.remove();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.listeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.listeners.removeChangeListener(changeListener);
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaSource.Phase moveToPhase(JavaSource.Phase phase, CompilationInfoImpl compilationInfoImpl, boolean bl, boolean bl2, boolean bl3) throws IOException {
        JavaSource.Phase phase2 = compilationInfoImpl.parserCrashed;
        assert (phase2 != null);
        JavaSource.Phase phase3 = compilationInfoImpl.getPhase();
        LowMemoryNotifier lowMemoryNotifier = null;
        LMListener lMListener = null;
        if (bl2) {
            lowMemoryNotifier = LowMemoryNotifier.getDefault();
            assert (lowMemoryNotifier != null);
            lMListener = new LMListener();
            lowMemoryNotifier.addLowMemoryListener(lMListener);
        }
        try {
            long l;
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfoImpl.needsRestart = true;
                JavaSource.Phase phase4 = phase3;
                return phase4;
            }
            if (phase3.compareTo(JavaSource.Phase.PARSED) < 0 && phase.compareTo(JavaSource.Phase.PARSED) >= 0 && phase.compareTo(phase2) <= 0) {
                Document document;
                if (bl && this.canceled.get()) {
                    JavaSource.Phase phase5 = JavaSource.Phase.MODIFIED;
                    return phase5;
                }
                l = System.currentTimeMillis();
                Iterable iterable = compilationInfoImpl.getJavacTask().parse(new JavaFileObject[]{compilationInfoImpl.jfo});
                assert (iterable != null) : "Did not parse anything";
                Iterator iterator = iterable.iterator();
                assert (iterator.hasNext());
                CompilationUnitTree compilationUnitTree = (CompilationUnitTree)iterator.next();
                compilationInfoImpl.setCompilationUnit(compilationUnitTree);
                assert (!iterator.hasNext());
                Document document2 = document = this.listener == null ? null : this.listener.document;
                if (document != null && this.supportsReparse && !bl3) {
                    FindMethodRegionsVisitor findMethodRegionsVisitor = new FindMethodRegionsVisitor(document, Trees.instance(compilationInfoImpl.getJavacTask()).getSourcePositions(), this.canceled);
                    findMethodRegionsVisitor.visit(compilationUnitTree, null);
                    List<Pair<DocPositionRegion, MethodTree>> list = this.positions;
                    synchronized (list) {
                        this.positions.clear();
                        this.positions.addAll(findMethodRegionsVisitor.getResult());
                    }
                }
                phase3 = JavaSource.Phase.PARSED;
                long l2 = System.currentTimeMillis();
                FileObject fileObject = compilationInfoImpl.getFileObject();
                TIME_LOGGER.log(Level.FINE, "Compilation Unit", new Object[]{fileObject, compilationUnitTree});
                JavacParser.logTime(fileObject, phase3, l2 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfoImpl.needsRestart = true;
                JavaSource.Phase phase6 = phase3;
                return phase6;
            }
            if (phase3 == JavaSource.Phase.PARSED && phase.compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0 && phase.compareTo(phase2) <= 0) {
                if (bl && this.canceled.get()) {
                    JavaSource.Phase phase7 = JavaSource.Phase.MODIFIED;
                    return phase7;
                }
                l = System.currentTimeMillis();
                compilationInfoImpl.getJavacTask().enter();
                phase3 = JavaSource.Phase.ELEMENTS_RESOLVED;
                long l3 = System.currentTimeMillis();
                JavacParser.logTime(compilationInfoImpl.getFileObject(), phase3, l3 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfoImpl.needsRestart = true;
                JavaSource.Phase phase8 = phase3;
                return phase8;
            }
            if (phase3 == JavaSource.Phase.ELEMENTS_RESOLVED && phase.compareTo(JavaSource.Phase.RESOLVED) >= 0 && phase.compareTo(phase2) <= 0) {
                if (bl && this.canceled.get()) {
                    JavaSource.Phase phase9 = JavaSource.Phase.MODIFIED;
                    return phase9;
                }
                l = System.currentTimeMillis();
                JavacTaskImpl javacTaskImpl = compilationInfoImpl.getJavacTask();
                PostFlowAnalysis.analyze(javacTaskImpl.analyze(), javacTaskImpl.getContext());
                phase3 = JavaSource.Phase.RESOLVED;
                long l4 = System.currentTimeMillis();
                JavacParser.logTime(compilationInfoImpl.getFileObject(), phase3, l4 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfoImpl.needsRestart = true;
                JavaSource.Phase phase10 = phase3;
                return phase10;
            }
            if (phase3 == JavaSource.Phase.RESOLVED && phase.compareTo(JavaSource.Phase.UP_TO_DATE) >= 0) {
                phase3 = JavaSource.Phase.UP_TO_DATE;
            }
        }
        catch (CouplingAbort couplingAbort) {
            TreeLoader.dumpCouplingAbort(couplingAbort, compilationInfoImpl.jfo);
            compilationInfoImpl.needsRestart = true;
            JavaSource.Phase phase11 = phase3;
            return phase11;
        }
        catch (CancelAbort cancelAbort) {
            phase3 = JavaSource.Phase.MODIFIED;
        }
        catch (Abort abort) {
            phase2 = phase3;
        }
        catch (IOException iOException) {
            compilationInfoImpl.parserCrashed = phase3;
            JavacParser.dumpSource(compilationInfoImpl, iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            phase2 = phase3;
            JavacParser.dumpSource(compilationInfoImpl, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            phase2 = phase3;
            JavacParser.dumpSource(compilationInfoImpl, error);
            throw error;
        }
        finally {
            if (bl2) {
                assert (lowMemoryNotifier != null);
                assert (lMListener != null);
                lowMemoryNotifier.removeLowMemoryListener(lMListener);
            }
            compilationInfoImpl.setPhase(phase3);
            compilationInfoImpl.parserCrashed = phase2;
        }
        return phase3;
    }

    private static CompilationInfoImpl createCurrentInfo(JavacParser javacParser, FileObject fileObject, FileObject fileObject2, Snapshot snapshot, JavacTaskImpl javacTaskImpl) throws IOException {
        CompilationInfoImpl compilationInfoImpl = new CompilationInfoImpl(javacParser, fileObject, fileObject2, javacTaskImpl, snapshot, false);
        if (fileObject != null) {
            Logger.getLogger("TIMER").log(Level.FINE, "CompilationInfo", new Object[]{fileObject, compilationInfoImpl});
        }
        return compilationInfoImpl;
    }

    static JavacTaskImpl createJavacTask(FileObject fileObject, FileObject fileObject2, ClasspathInfo classpathInfo, JavacParser javacParser, DiagnosticListener<? super JavaFileObject> diagnosticListener, ClassNamesForFileOraculum classNamesForFileOraculum) {
        String string = null;
        if (fileObject != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Created new JavacTask for: " + FileUtil.getFileDisplayName((FileObject)fileObject));
            }
            string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
            if (fileObject2 != null && string != null) {
                try {
                    JavaCustomIndexer.verifySourceLevel(fileObject2.getURL(), string);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, null, iOException);
                }
            }
        }
        if (string == null) {
            string = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
        }
        JavacTaskImpl javacTaskImpl = JavacParser.createJavacTask(classpathInfo, diagnosticListener, string, false, classNamesForFileOraculum);
        Context context = javacTaskImpl.getContext();
        if (javacParser != null) {
            JavacCancelService.preRegister(context, javacParser);
        }
        JavacFlowListener.preRegister(context);
        TreeLoader.preRegister(context, classpathInfo);
        Messager.preRegister((Context)context, null, (PrintWriter)DEV_NULL, (PrintWriter)DEV_NULL, (PrintWriter)DEV_NULL);
        ErrorHandlingJavadocEnter.preRegister(context);
        JavadocMemberEnter.preRegister((Context)context);
        JavadocEnv.preRegister(context, classpathInfo);
        com.sun.tools.javac.main.JavaCompiler.instance((Context)context).keepComments = true;
        return javacTaskImpl;
    }

    public static JavacTaskImpl createJavacTask(ClasspathInfo classpathInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String string, ClassNamesForFileOraculum classNamesForFileOraculum) {
        if (string == null) {
            string = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
        }
        return JavacParser.createJavacTask(classpathInfo, diagnosticListener, string, true, classNamesForFileOraculum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavacTaskImpl createJavacTask(ClasspathInfo classpathInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String string, boolean bl, ClassNamesForFileOraculum classNamesForFileOraculum) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = CompilerSettings.getCommandLine();
        Source source = JavacParser.validateSourceLevel(string, classpathInfo);
        if (string2.length() > 0) {
            arrayList.addAll(Arrays.asList(string2.split(" ")));
        }
        if (!bl) {
            arrayList.add("-Xjcov");
            arrayList.add("-XDdisableStringFolding");
        } else {
            arrayList.add("-XDbackgroundCompilation");
            arrayList.add("-XDcompilePolicy=byfile");
            arrayList.add("-target");
            arrayList.add(source.requiredTarget().name);
        }
        arrayList.add("-XDide");
        arrayList.add("-XDsave-parameter-names");
        arrayList.add("-g:source");
        arrayList.add("-g:lines");
        arrayList.add("-g:vars");
        arrayList.add("-source");
        arrayList.add(source.name);
        arrayList.add("-proc:none");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClasspathInfo.class.getClassLoader());
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            JavacTaskImpl javacTaskImpl = (JavacTaskImpl)javaCompiler.getTask(null, ClasspathInfoAccessor.getINSTANCE().getFileManager(classpathInfo), diagnosticListener, arrayList, null, Collections.emptySet());
            Context context = javacTaskImpl.getContext();
            JavadocClassReader.preRegister((Context)context, (!bl ? 1 : 0) != 0);
            if (classNamesForFileOraculum != null) {
                context.put(ClassNamesForFileOraculum.class, classNamesForFileOraculum);
            }
            JavacTaskImpl javacTaskImpl2 = javacTaskImpl;
            return javacTaskImpl2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static Source validateSourceLevel(String string, ClasspathInfo classpathInfo) {
        ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
        SpecificationVersion specificationVersion = Source.values();
        if (string == null) {
            return specificationVersion[((Source[])specificationVersion).length - 1];
        }
        for (Source source : specificationVersion) {
            if (!source.name.equals(string)) continue;
            if (source.compareTo(Source.JDK1_4) >= 0 && classPath != null && classPath.findResource("java/lang/AssertionError.class") == null) {
                LOGGER.warning("Even though the source level of " + classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE) + " is set to: " + string + ", java.lang.AssertionError cannot be found on the bootclasspath: " + classPath + "\nChanging source level to 1.3");
                return Source.JDK1_3;
            }
            if (source.compareTo(Source.JDK1_5) >= 0 && classPath != null && classPath.findResource("java/lang/StringBuilder.class") == null) {
                LOGGER.warning("Even though the source level of " + classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE) + " is set to: " + string + ", java.lang.StringBuilder cannot be found on the bootclasspath: " + classPath + "\nChanging source level to 1.4");
                return Source.JDK1_4;
            }
            return source;
        }
        SpecificationVersion specificationVersion2 = new SpecificationVersion("1.2");
        SpecificationVersion specificationVersion3 = new SpecificationVersion(string);
        if (specificationVersion2.compareTo((Object)specificationVersion3) > 0) {
            return specificationVersion[0];
        }
        return specificationVersion[((SpecificationVersion)specificationVersion).length - 1];
    }

    private static void logTime(FileObject fileObject, JavaSource.Phase phase, long l) {
        assert (fileObject != null && phase != null);
        String string = phase2Message.get((Object)phase);
        assert (string != null);
        TIME_LOGGER.log(Level.FINE, string, new Object[]{fileObject, l});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSource(CompilationInfoImpl compilationInfoImpl, Throwable throwable) {
        Object object;
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            return;
        }
        String string2 = string + "/var/log/";
        String string3 = compilationInfoImpl.getText();
        FileObject fileObject = compilationInfoImpl.getFileObject();
        String string4 = FileUtil.getFileDisplayName((FileObject)fileObject);
        String string5 = fileObject.getName();
        File file = new File(string2 + string5 + ".dump");
        boolean bl = false;
        for (int i = 1; i < 255 && file.exists(); ++i) {
            file = new File(string2 + string5 + '_' + i + ".dump");
        }
        if (!file.exists()) {
            try {
                object = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
                try {
                    printWriter.println(string3);
                    printWriter.println("----- Classpath: ---------------------------------------------");
                    ClassPath classPath = compilationInfoImpl.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath2 = compilationInfoImpl.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath classPath3 = compilationInfoImpl.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    printWriter.println("bootPath: " + (classPath != null ? classPath.toString() : "null"));
                    printWriter.println("classPath: " + (classPath2 != null ? classPath2.toString() : "null"));
                    printWriter.println("sourcePath: " + (classPath3 != null ? classPath3.toString() : "null"));
                    printWriter.println("----- Original exception ---------------------------------------------");
                    throwable.printStackTrace(printWriter);
                }
                finally {
                    printWriter.close();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, "Error when writing parser dump file!", iOException);
            }
        }
        if (bl) {
            object = Exceptions.attachMessage((Throwable)throwable, (String)("An error occurred during parsing of '" + string4 + "'. Please report a bug against java/source and attach dump file '" + file.getAbsolutePath() + "'."));
            Exceptions.printStackTrace((Throwable)object);
        } else {
            LOGGER.log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + string2 + "' and " + "clean all *.dump files in that directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean reparseMethod(CompilationInfoImpl compilationInfoImpl, Snapshot snapshot, MethodTree methodTree, String string) throws IOException {
        assert (compilationInfoImpl != null);
        FileObject fileObject = compilationInfoImpl.getFileObject();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Reparse method in: " + fileObject);
        }
        if (((JCTree.JCMethodDecl)methodTree).localEnv == null) {
            return false;
        }
        JavaSource.Phase phase = compilationInfoImpl.getPhase();
        if (JavaSource.Phase.PARSED.compareTo(phase) > 0) {
            return false;
        }
        try {
            int n;
            CompilationUnitTree compilationUnitTree = compilationInfoImpl.getCompilationUnit();
            if (compilationUnitTree == null) return false;
            if (string == null) {
                return false;
            }
            JavacTaskImpl javacTaskImpl = compilationInfoImpl.getJavacTask();
            JavacTrees javacTrees = JavacTrees.instance(javacTaskImpl);
            int n2 = (int)javacTrees.getSourcePositions().getStartPosition(compilationUnitTree, methodTree.getBody());
            if (n2 > (n = (int)javacTrees.getSourcePositions().getEndPosition(compilationUnitTree, methodTree.getBody()))) {
                LOGGER.warning("Javac returned startpos: " + n2 + " > endpos: " + n);
                return false;
            }
            FindAnonymousVisitor findAnonymousVisitor = new FindAnonymousVisitor();
            findAnonymousVisitor.scan(methodTree.getBody(), null);
            if (findAnonymousVisitor.hasLocalClass) {
                if (!LOGGER.isLoggable(Level.FINER)) return false;
                LOGGER.finer("Skeep reparse method (old local classes): " + fileObject);
                return false;
            }
            int n3 = findAnonymousVisitor.firstInner;
            int n4 = findAnonymousVisitor.noInner;
            Context context = javacTaskImpl.getContext();
            TreeLoader treeLoader = TreeLoader.instance(context);
            if (treeLoader != null) {
                treeLoader.startPartialReparse();
            }
            try {
                Log log = Log.instance(context);
                log.startPartialReparse();
                JavaFileObject javaFileObject = log.useSource(compilationUnitTree.getSourceFile());
                try {
                    DiagnosticListener diagnosticListener = context.get(DiagnosticListener.class);
                    assert (diagnosticListener instanceof CompilationInfoImpl.DiagnosticListenerImpl);
                    ((CompilationInfoImpl.DiagnosticListenerImpl)diagnosticListener).startPartialReparse(n2, n);
                    long l = System.currentTimeMillis();
                    JCTree.JCBlock jCBlock = javacTaskImpl.reparseMethodBody(compilationUnitTree, methodTree, string, n3);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Reparsed method in: " + fileObject);
                    }
                    assert (jCBlock != null);
                    findAnonymousVisitor.reset();
                    findAnonymousVisitor.scan(jCBlock, null);
                    int n5 = findAnonymousVisitor.noInner;
                    if (findAnonymousVisitor.hasLocalClass || n4 != n5) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Skeep reparse method (new local classes): " + fileObject);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    long l2 = System.currentTimeMillis();
                    if (fileObject != null) {
                        JavacParser.logTime(fileObject, JavaSource.Phase.PARSED, l2 - l);
                    }
                    int n6 = (int)javacTrees.getSourcePositions().getEndPosition(compilationUnitTree, jCBlock);
                    int n7 = n6 - n;
                    EndPosTable endPosTable = ((JCTree.JCCompilationUnit)compilationUnitTree).endPositions;
                    TranslatePositionsVisitor translatePositionsVisitor = new TranslatePositionsVisitor(methodTree, (Map<JCTree, Integer>)((Object)endPosTable), n7);
                    translatePositionsVisitor.scan((Tree)compilationUnitTree, null);
                    ((JCTree.JCMethodDecl)methodTree).body = jCBlock;
                    if (JavaSource.Phase.RESOLVED.compareTo(phase) <= 0) {
                        JavacFlowListener javacFlowListener;
                        l = System.currentTimeMillis();
                        javacTaskImpl.reattrMethodBody(methodTree, jCBlock);
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Resolved method in: " + fileObject);
                        }
                        if (!((CompilationInfoImpl.DiagnosticListenerImpl)diagnosticListener).hasPartialReparseErrors() && (javacFlowListener = JavacFlowListener.instance(context)) != null && javacFlowListener.hasFlowCompleted(fileObject)) {
                            Iterable<Diagnostic<Object>> iterable;
                            if (LOGGER.isLoggable(Level.FINER) && !(iterable = compilationInfoImpl.getDiagnostics()).isEmpty()) {
                                LOGGER.finer("Reflow with errors: " + fileObject + " " + iterable);
                            }
                            iterable = TreePath.getPath(compilationUnitTree, (Tree)methodTree);
                            Tree tree = ((TreePath)iterable).getParentPath().getLeaf();
                            javacTaskImpl.reflowMethodBody(compilationUnitTree, (ClassTree)tree, methodTree);
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("Reflowed method in: " + fileObject);
                            }
                        }
                        l2 = System.currentTimeMillis();
                        if (fileObject != null) {
                            JavacParser.logTime(fileObject, JavaSource.Phase.ELEMENTS_RESOLVED, 0L);
                            JavacParser.logTime(fileObject, JavaSource.Phase.RESOLVED, l2 - l);
                        }
                    }
                    ((CompilationInfoImpl.DiagnosticListenerImpl)diagnosticListener).endPartialReparse(n7);
                }
                finally {
                    log.endPartialReparse();
                    log.useSource(javaFileObject);
                }
                compilationInfoImpl.update(snapshot);
                return true;
            }
            finally {
                if (treeLoader != null) {
                    treeLoader.endPartialReparse();
                }
            }
        }
        catch (CouplingAbort couplingAbort) {
            return false;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
            }
            if (!bl) return false;
            JavacParser.dumpSource(compilationInfoImpl, throwable);
            return false;
        }
    }

    public synchronized void setChangedMethod(Pair<DocPositionRegion, MethodTree> pair) {
        assert (pair != null);
        this.changedMethod = pair;
    }

    static {
        phase2Message.put(JavaSource.Phase.PARSED, "Parsed");
        phase2Message.put(JavaSource.Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Message.put(JavaSource.Phase.RESOLVED, "Attributed");
    }

    private final class FilterListener
    implements ChangeListener {
        public FilterListener(JavaFileFilterImplementation javaFileFilterImplementation) {
            javaFileFilterImplementation.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)javaFileFilterImplementation));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JavacParser.this.listeners.fireChange();
        }
    }

    private class DocListener
    implements PropertyChangeListener,
    TokenHierarchyListener {
        private EditorCookie.Observable ec;
        private TokenHierarchyListener lexListener;
        private volatile Document document;

        public DocListener(EditorCookie.Observable observable) {
            assert (observable != null);
            this.ec = observable;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            StyledDocument styledDocument = observable.getDocument();
            if (styledDocument != null) {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)styledDocument);
                this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)tokenHierarchy);
                tokenHierarchy.addTokenHierarchyListener(this.lexListener);
                this.document = styledDocument;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                StyledDocument styledDocument;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof Document && this.lexListener != null) {
                    styledDocument = TokenHierarchy.get((Document)((Document)object));
                    styledDocument.removeTokenHierarchyListener(this.lexListener);
                    this.lexListener = null;
                }
                if ((styledDocument = this.ec.getDocument()) != null) {
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)styledDocument);
                    this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)tokenHierarchy);
                    tokenHierarchy.addTokenHierarchyListener(this.lexListener);
                    this.document = styledDocument;
                } else {
                    this.document = styledDocument;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
            Pair pair = null;
            if (tokenHierarchyEvent.type() == TokenHierarchyEventType.MODIFICATION && JavacParser.this.supportsReparse) {
                int n = tokenHierarchyEvent.affectedStartOffset();
                int n2 = tokenHierarchyEvent.affectedEndOffset();
                List list = JavacParser.this.positions;
                synchronized (list) {
                    PositionRegion positionRegion;
                    Pair pair2;
                    Object object = JavacParser.this.positions.iterator();
                    while (object.hasNext()) {
                        pair2 = (Pair)object.next();
                        positionRegion = (PositionRegion)pair2.first;
                        if (n <= positionRegion.getStartOffset() || n2 >= positionRegion.getEndOffset()) continue;
                        pair = pair2;
                        break;
                    }
                    if (pair != null && (object = tokenHierarchyEvent.tokenChange(JavaTokenId.language())) != null) {
                        pair2 = object.removedTokenSequence();
                        if (pair2 != null) {
                            while (pair2.moveNext()) {
                                switch ((JavaTokenId)pair2.token().id()) {
                                    case LBRACE: 
                                    case RBRACE: {
                                        pair = null;
                                    }
                                }
                            }
                        }
                        if (pair != null) {
                            positionRegion = object.currentTokenSequence();
                            positionRegion.moveIndex(object.index());
                            for (int i = 0; i < object.addedTokenCount(); ++i) {
                                positionRegion.moveNext();
                                switch ((JavaTokenId)positionRegion.token().id()) {
                                    case LBRACE: 
                                    case RBRACE: {
                                        pair = null;
                                    }
                                }
                            }
                        }
                    }
                    JavacParser.this.positions.clear();
                    if (pair != null) {
                        JavacParser.this.positions.add(pair);
                    }
                    object = JavacParser.this;
                    synchronized (object) {
                        JavacParser.this.changedMethod = pair;
                    }
                }
            }
        }
    }

    private static class LMListener
    implements LowMemoryListener {
        private final AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }

    private static class JavacCancelService
    extends CancelService {
        private final JavacParser parser;
        boolean active;

        private JavacCancelService(JavacParser javacParser) {
            this.parser = javacParser;
        }

        public static JavacCancelService instance(Context context) {
            CancelService cancelService = CancelService.instance((Context)context);
            return cancelService instanceof JavacCancelService ? (JavacCancelService)cancelService : null;
        }

        static void preRegister(Context context, JavacParser javacParser) {
            assert (context != null);
            assert (javacParser != null);
            context.put(cancelServiceKey, new JavacCancelService(javacParser));
        }

        public boolean isCanceled() {
            boolean bl = this.active && this.parser.canceled.get();
            return bl;
        }
    }
}

