/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompilationInfoImpl {
    private JavaSource.Phase phase = JavaSource.Phase.MODIFIED;
    private CompilationUnitTree compilationUnit;
    private JavacTaskImpl javacTask;
    private final ClasspathInfo cpInfo;
    Pair<DocPositionRegion, MethodTree> changedMethod;
    private final FileObject file;
    private final FileObject root;
    final JavaFileObject jfo;
    private Snapshot snapshot;
    private final JavacParser parser;
    private final boolean isClassFile;
    boolean needsRestart;
    JavaSource.Phase parserCrashed = JavaSource.Phase.UP_TO_DATE;
    private final boolean clone;

    CompilationInfoImpl(JavacParser javacParser, FileObject fileObject, FileObject fileObject2, JavacTaskImpl javacTaskImpl, Snapshot snapshot, boolean bl) throws IOException {
        assert (javacParser != null);
        this.parser = javacParser;
        this.cpInfo = javacParser.getClasspathInfo();
        assert (this.cpInfo != null);
        this.file = fileObject;
        this.root = fileObject2;
        this.snapshot = snapshot;
        assert (fileObject == null || snapshot != null);
        this.jfo = fileObject != null ? JavacParser.jfoProvider.createJavaFileObject(fileObject, fileObject2, JavaFileFilterQuery.getFilter(fileObject), snapshot.getText()) : null;
        this.javacTask = javacTaskImpl;
        this.isClassFile = false;
        this.clone = bl;
    }

    CompilationInfoImpl(ClasspathInfo classpathInfo) {
        assert (classpathInfo != null);
        this.parser = null;
        this.file = null;
        this.root = null;
        this.jfo = null;
        this.snapshot = null;
        this.cpInfo = classpathInfo;
        this.isClassFile = false;
        this.clone = false;
    }

    CompilationInfoImpl(ClasspathInfo classpathInfo, FileObject fileObject, FileObject fileObject2) throws IOException {
        assert (classpathInfo != null);
        assert (fileObject != null);
        assert (fileObject2 != null);
        this.parser = null;
        this.file = fileObject;
        this.root = fileObject2;
        this.jfo = FileObjects.nbFileObject(fileObject, fileObject2);
        this.snapshot = null;
        this.cpInfo = classpathInfo;
        this.isClassFile = true;
        this.clone = false;
    }

    void update(Snapshot snapshot) throws IOException {
        assert (snapshot != null);
        JavacParser.jfoProvider.update(this.jfo, snapshot.getText());
        this.snapshot = snapshot;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public JavaSource.Phase getPhase() {
        return this.phase;
    }

    public Pair<DocPositionRegion, MethodTree> getChangedTree() {
        return this.changedMethod;
    }

    public CompilationUnitTree getCompilationUnit() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        if (this.phase.compareTo(JavaSource.Phase.PARSED) < 0) {
            throw new IllegalStateException("Cannot call getCompilationInfo() if current phase < JavaSource.Phase.PARSED. You must call toPhase(Phase.PARSED) first.");
        }
        return this.compilationUnit;
    }

    public String getText() {
        if (!this.hasSource()) {
            throw new IllegalStateException();
        }
        try {
            return ((Object)this.jfo.getCharContent(false)).toString();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public TokenHierarchy<?> getTokenHierarchy() {
        if (!this.hasSource()) {
            throw new IllegalStateException();
        }
        try {
            return ((SourceFileObject)this.jfo).getTokenHierarchy();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public List<Diagnostic> getDiagnostics() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        Collection collection = ((DiagnosticListenerImpl)this.javacTask.getContext().get(DiagnosticListener.class)).errors.values();
        List list = ((DiagnosticListenerImpl)this.javacTask.getContext().get(DiagnosticListener.class)).partialReparseErrors;
        List list2 = ((DiagnosticListenerImpl)this.javacTask.getContext().get(DiagnosticListener.class)).affectedErrors;
        ArrayList<Diagnostic> arrayList = new ArrayList<Diagnostic>(collection.size() + (list == null ? 0 : list.size()) + (list2 == null ? 0 : list2.size()));
        arrayList.addAll(collection);
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    public JavacParser getParser() {
        return this.parser;
    }

    public FileObject getFileObject() {
        return this.file;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isClassFile() {
        return this.isClassFile;
    }

    public Document getDocument() {
        if (this.file == null) {
            return null;
        }
        if (!this.file.isValid()) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)this.file);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                return editorCookie.getDocument();
            }
            return null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(CompilationInfoImpl.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
            return null;
        }
    }

    public JavaSource.Phase toPhase(JavaSource.Phase phase) throws IOException {
        if (phase == JavaSource.Phase.MODIFIED) {
            throw new IllegalArgumentException("Invalid phase: " + (Object)((Object)phase));
        }
        if (!this.hasSource()) {
            JavaSource.Phase phase2 = this.getPhase();
            if (phase2.compareTo(phase) < 0) {
                this.setPhase(phase);
                phase2 = phase;
            }
            return phase2;
        }
        JavaSource.Phase phase3 = this.parser.moveToPhase(phase, this, false, false, this.clone);
        return phase3.compareTo(phase) < 0 ? phase3 : phase;
    }

    void setPhase(JavaSource.Phase phase) {
        assert (phase != null);
        this.phase = phase;
    }

    void setChangedMethod(Pair<DocPositionRegion, MethodTree> pair) {
        this.changedMethod = pair;
    }

    void setCompilationUnit(CompilationUnitTree compilationUnitTree) {
        assert (compilationUnitTree != null);
        this.compilationUnit = compilationUnitTree;
    }

    public synchronized JavacTaskImpl getJavacTask() {
        if (this.javacTask == null) {
            this.javacTask = JavacParser.createJavacTask(this.file, this.root, this.cpInfo, this.clone ? null : this.parser, new DiagnosticListenerImpl(this.jfo), null);
        }
        return this.javacTask;
    }

    private boolean hasSource() {
        return this.jfo != null && !this.isClassFile;
    }

    static class DiagnosticListenerImpl
    implements DiagnosticListener {
        private final TreeMap<Integer, Diagnostic> errors;
        private final JavaFileObject jfo;
        private volatile List<Diagnostic> partialReparseErrors;
        private volatile List<Diagnostic> affectedErrors;
        private volatile int currentDelta;

        public DiagnosticListenerImpl(JavaFileObject javaFileObject) {
            this.jfo = javaFileObject;
            this.errors = new TreeMap();
        }

        public void report(Diagnostic diagnostic) {
            if (this.jfo != null && this.jfo == diagnostic.getSource()) {
                if (this.partialReparseErrors != null) {
                    this.partialReparseErrors.add(diagnostic);
                } else {
                    this.errors.put((int)diagnostic.getPosition(), diagnostic);
                }
            }
        }

        final boolean hasPartialReparseErrors() {
            return this.partialReparseErrors != null && !this.partialReparseErrors.isEmpty();
        }

        final void startPartialReparse(int n, int n2) {
            if (this.partialReparseErrors == null) {
                this.partialReparseErrors = new ArrayList<Diagnostic>();
                this.errors.subMap(n, n2).clear();
                SortedMap<Integer, Diagnostic> sortedMap = this.errors.tailMap(n2);
                this.affectedErrors = new ArrayList<Diagnostic>(sortedMap.size());
                Iterator iterator = sortedMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    iterator.remove();
                    this.affectedErrors.add(new D((JCDiagnostic)entry.getValue()));
                }
            } else {
                this.partialReparseErrors.clear();
            }
        }

        final void endPartialReparse(int n) {
            this.currentDelta += n;
        }

        private final class D
        implements Diagnostic {
            private final JCDiagnostic delegate;

            public D(JCDiagnostic jCDiagnostic) {
                assert (jCDiagnostic != null);
                this.delegate = jCDiagnostic;
            }

            public Diagnostic.Kind getKind() {
                return this.delegate.getKind();
            }

            public Object getSource() {
                return this.delegate.getSource();
            }

            public long getPosition() {
                long l = this.delegate.getPosition();
                if (this.delegate.hasFixedPositions()) {
                    l += (long)DiagnosticListenerImpl.this.currentDelta;
                }
                return l;
            }

            public long getStartPosition() {
                long l = this.delegate.getStartPosition();
                if (this.delegate.hasFixedPositions()) {
                    l += (long)DiagnosticListenerImpl.this.currentDelta;
                }
                return l;
            }

            public long getEndPosition() {
                long l = this.delegate.getEndPosition();
                if (this.delegate.hasFixedPositions()) {
                    l += (long)DiagnosticListenerImpl.this.currentDelta;
                }
                return l;
            }

            public long getLineNumber() {
                return -1L;
            }

            public long getColumnNumber() {
                return -1L;
            }

            public String getCode() {
                return this.delegate.getCode();
            }

            public String getMessage(Locale locale) {
                return this.delegate.getMessage(locale);
            }
        }
    }
}

