/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.util.Exceptions;

public class JavaBinaryIndexer
extends BinaryIndexer {
    static final Logger LOG = Logger.getLogger(JavaBinaryIndexer.class.getName());

    protected void index(final Context context) {
        LOG.log(Level.FINE, "index({0})", context.getRootURI());
        try {
            final ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
            classIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws IOException, InterruptedException {
                    CachingArchiveProvider.getDefault().clearArchive(context.getRootURI());
                    File file = JavaIndex.getClassFolder(context.getRootURI());
                    FileObjects.deleteRecursively(file);
                    ClassIndexImpl classIndexImpl = classIndexManager.createUsagesQuery(context.getRootURI(), false);
                    if (classIndexImpl == null) {
                        return null;
                    }
                    BinaryAnalyser binaryAnalyser = classIndexImpl.getBinaryAnalyser();
                    if (binaryAnalyser != null) {
                        try {
                            BinaryAnalyser.Result result = binaryAnalyser.start(context.getRootURI(), new AtomicBoolean(false), new AtomicBoolean(false));
                            while (result == BinaryAnalyser.Result.CANCELED) {
                                result = binaryAnalyser.resume();
                            }
                            Object var6_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            binaryAnalyser.finish();
                            throw throwable;
                        }
                        binaryAnalyser.finish();
                        {
                        }
                    }
                    return null;
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
    }

    public static class Factory
    extends BinaryIndexerFactory {
        public BinaryIndexer createIndexer() {
            return new JavaBinaryIndexer();
        }

        public String getIndexerName() {
            return "java";
        }

        public int getIndexVersion() {
            return 13;
        }
    }
}

