/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionDoc;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyType;
import org.netbeans.modules.spring.util.SpringBeansUIs;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringXMLConfigCompletionItem
implements CompletionItem {
    protected int substitutionOffset;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    private static final String UNKNOWN = "<unknown>";
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";

    public static SpringXMLConfigCompletionItem createBeanRefItem(int n, String string, SpringBean springBean, FileObject fileObject) {
        return new BeanRefItem(n, string, springBean, fileObject);
    }

    public static SpringXMLConfigCompletionItem createPackageItem(int n, String string, boolean bl) {
        return new PackageItem(n, string, bl);
    }

    public static SpringXMLConfigCompletionItem createTypeItem(int n, TypeElement typeElement, ElementHandle<TypeElement> elementHandle, boolean bl, boolean bl2) {
        return new ClassItem(n, typeElement, elementHandle, bl, bl2);
    }

    public static SpringXMLConfigCompletionItem createMethodItem(int n, ExecutableElement executableElement, boolean bl, boolean bl2) {
        return new MethodItem(n, executableElement, bl, bl2);
    }

    public static SpringXMLConfigCompletionItem createPropertyItem(int n, Property property) {
        return new PropertyItem(n, property);
    }

    public static SpringXMLConfigCompletionItem createAttribValueItem(int n, String string, String string2) {
        return new AttribValueItem(n, string, string2);
    }

    public static SpringXMLConfigCompletionItem createFolderItem(int n, FileObject fileObject) {
        return new FolderItem(n, fileObject);
    }

    public static SpringXMLConfigCompletionItem createSpringXMLFileItem(int n, FileObject fileObject) {
        return new FileItem(n, fileObject);
    }

    public static SpringXMLConfigCompletionItem createPropertyAttribItem(int n, String string, Property property) {
        return new PropertyAttribItem(n, string, property);
    }

    public static SpringXMLConfigCompletionItem createBeanNameItem(int n, String string, int n2) {
        return new BeanNameItem(n, string, n2);
    }

    protected SpringXMLConfigCompletionItem(int n) {
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        CharSequence charSequence = this.getSubstitutionText();
        String string2 = ((Object)charSequence).toString();
        if (string != null) {
            string2 = string2 + string;
        }
        baseDocument.atomicLock();
        try {
            Position position = baseDocument.createPosition(n);
            baseDocument.remove(n, n2);
            baseDocument.insertString(position.getOffset(), string2.toString(), null);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    protected CharSequence getSubstitutionText() {
        return this.getInsertPrefix();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        return null;
    }

    public static CharSequence getElementName(Element element, boolean bl) {
        if (element == null || element.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(element, bl);
    }

    public static int getImportanceLevel(String string) {
        int n = 50;
        if (string.startsWith("java.lang") || string.startsWith("java.util")) {
            n -= 10;
        } else if (string.startsWith("org.omg") || string.startsWith("org.apache")) {
            n += 10;
        } else if (string.startsWith("com.sun") || string.startsWith("com.ibm") || string.startsWith("com.apple")) {
            n += 20;
        } else if (string.startsWith("sun") || string.startsWith("sunw") || string.startsWith("netscape")) {
            n += 30;
        }
        return n;
    }

    public static CharSequence getTypeName(TypeMirror typeMirror, boolean bl) {
        return SpringXMLConfigCompletionItem.getTypeName(typeMirror, bl, false);
    }

    public static CharSequence getTypeName(TypeMirror typeMirror, boolean bl, boolean bl2) {
        if (typeMirror == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(bl2).visit(typeMirror, bl);
    }

    private static String escape(String string) {
        if (string != null) {
            try {
                return XMLUtil.toAttributeValue((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaElementDocQuery
    extends AsyncCompletionQuery {
        private ElementHandle<?> elemHandle;

        public JavaElementDocQuery(ElementHandle<?> elementHandle) {
            this.elemHandle = elementHandle;
        }

        protected void query(final CompletionResultSet completionResultSet, Document document, int n) {
            try {
                JavaSource javaSource = JavaUtils.getJavaSource(document);
                if (javaSource == null) {
                    return;
                }
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = JavaElementDocQuery.this.elemHandle.resolve((CompilationInfo)compilationController);
                        if (element == null) {
                            return;
                        }
                        SpringXMLConfigCompletionDoc springXMLConfigCompletionDoc = SpringXMLConfigCompletionDoc.createJavaDoc(compilationController, element);
                        completionResultSet.setDocumentation((CompletionDocumentation)springXMLConfigCompletionDoc);
                    }
                }, false);
                completionResultSet.finish();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;

        private TypeNameVisitor(boolean bl) {
            super(new StringBuilder());
            this.varArg = bl;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror typeMirror, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(typeMirror);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType declaredType, Boolean bl) {
            Element element = declaredType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
                Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                if (iterator.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (iterator.hasNext()) {
                        this.visit(iterator.next(), bl);
                        if (!iterator.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(SpringXMLConfigCompletionItem.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType arrayType, Boolean bl) {
            boolean bl2 = this.varArg;
            this.varArg = false;
            this.visit(arrayType.getComponentType(), bl);
            return ((StringBuilder)this.DEFAULT_VALUE).append(bl2 ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable typeVariable, Boolean bl) {
            Object object;
            Element element = typeVariable.asElement();
            if (element != null && !SpringXMLConfigCompletionItem.CAPTURED_WILDCARD.equals(object = element.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append((String)object);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            object = typeVariable.getLowerBound();
            if (object != null && object.getKind() != TypeKind.NULL) {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit((TypeMirror)object, bl);
            } else {
                object = typeVariable.getUpperBound();
                if (object != null && object.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (object.getKind() == TypeKind.TYPEVAR) {
                        object = ((TypeVariable)object).getLowerBound();
                    }
                    this.visit((TypeMirror)object, bl);
                }
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType wildcardType, Boolean bl) {
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror typeMirror = wildcardType.getSuperBound();
            if (typeMirror == null) {
                typeMirror = wildcardType.getExtendsBound();
                if (typeMirror != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (typeMirror.getKind() == TypeKind.WILDCARD) {
                        typeMirror = ((WildcardType)typeMirror).getSuperBound();
                    }
                    this.visit(typeMirror, bl);
                } else {
                    typeMirror = SourceUtils.getBound((WildcardType)wildcardType);
                    if (!(typeMirror == null || typeMirror.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        this.visit(typeMirror, bl);
                    }
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(typeMirror, bl);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType errorType, Boolean bl) {
            Element element = errorType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementNameVisitor
    extends SimpleElementVisitor6<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitPackage(PackageElement packageElement, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? packageElement.getQualifiedName() : packageElement.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement typeElement, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
        }
    }

    private static class FileItem
    extends SpringXMLConfigCompletionItem {
        private FileObject file;

        public FileItem(int n, FileObject fileObject) {
            super(n);
            this.file = fileObject;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.file.getNameExt();
        }

        public CharSequence getInsertPrefix() {
            return this.file.getNameExt();
        }

        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/spring/beans/resources/spring.png", (boolean)false);
        }

        protected String getLeftHtmlText() {
            return this.file.getNameExt();
        }
    }

    private static class PropertyAttribItem
    extends PropertyItem {
        private String text;

        public PropertyAttribItem(int n, String string, Property property) {
            super(n, property);
            this.text = string;
        }

        public int getSortPriority() {
            return 200;
        }

        public CharSequence getSortText() {
            return this.text;
        }

        public CharSequence getInsertPrefix() {
            return this.text;
        }

        protected CharSequence getSubstitutionText() {
            return this.text + "=\"\"";
        }

        protected String getLeftHtmlText() {
            return this.text;
        }

        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            super.substituteText(jTextComponent, n, n2, string);
            int n3 = jTextComponent.getCaretPosition() - 1;
            jTextComponent.setCaretPosition(n3);
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }
    }

    private static class PropertyItem
    extends SpringXMLConfigCompletionItem {
        private static final String PROP_RO = "org/netbeans/modules/beans/resources/propertyRO.gif";
        private static final String PROP_RW = "org/netbeans/modules/beans/resources/propertyRW.gif";
        private static final String PROP_WO = "org/netbeans/modules/beans/resources/propertyWO.gif";
        private String displayName;
        private PropertyType propertyType;
        private String typeName;
        private static EnumMap<PropertyType, ImageIcon> type2Icon = new EnumMap(PropertyType.class);

        public PropertyItem(int n, Property property) {
            super(n);
            this.displayName = property.getName();
            this.typeName = SpringXMLConfigCompletionItem.escape(((Object)PropertyItem.getTypeName(property.getImplementationType(), false)).toString());
            this.propertyType = property.getType();
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayName;
        }

        public CharSequence getInsertPrefix() {
            return this.displayName;
        }

        protected String getLeftHtmlText() {
            return this.displayName;
        }

        protected String getRightHtmlText() {
            return this.typeName;
        }

        protected ImageIcon getIcon() {
            ImageIcon imageIcon = type2Icon.get((Object)this.propertyType);
            if (imageIcon == null) {
                switch (this.propertyType) {
                    case READ_ONLY: {
                        imageIcon = ImageUtilities.loadImageIcon((String)PROP_RO, (boolean)false);
                        break;
                    }
                    case READ_WRITE: {
                        imageIcon = ImageUtilities.loadImageIcon((String)PROP_RW, (boolean)false);
                        break;
                    }
                    case WRITE_ONLY: {
                        imageIcon = ImageUtilities.loadImageIcon((String)PROP_WO, (boolean)false);
                    }
                }
                type2Icon.put(this.propertyType, imageIcon);
            }
            return imageIcon;
        }
    }

    private static class FolderItem
    extends SpringXMLConfigCompletionItem {
        private FileObject folder;
        private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
        private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";

        public FolderItem(int n, FileObject fileObject) {
            super(n);
            this.folder = fileObject;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 400 && keyEvent.getKeyChar() == '/') {
                Completion.get().hideDocumentation();
                JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                int n = jTextComponent.getSelectionEnd();
                this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, Character.toString(keyEvent.getKeyChar()));
                Completion.get().showCompletion();
                keyEvent.consume();
            }
        }

        public int getSortPriority() {
            return 300;
        }

        public CharSequence getSortText() {
            return this.folder.getName();
        }

        public CharSequence getInsertPrefix() {
            return this.folder.getName();
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        protected ImageIcon getIcon() {
            return new ImageIcon(FolderItem.getTreeFolderIcon());
        }

        protected String getLeftHtmlText() {
            return this.folder.getName();
        }

        private static Image getTreeFolderIcon() {
            Image image = null;
            Icon icon = UIManager.getIcon(ICON_KEY_UIMANAGER);
            if (icon != null) {
                image = ImageUtilities.icon2Image((Icon)icon);
            } else {
                image = (Image)UIManager.get(ICON_KEY_UIMANAGER_NB);
                if (image == null) {
                    Node node = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
                    image = node.getIcon(1);
                }
            }
            assert (image != null);
            return image;
        }
    }

    private static class BeanNameItem
    extends AttribValueItem {
        private final int sortPriority;

        public BeanNameItem(int n, String string, int n2) {
            super(n, string, null);
            this.sortPriority = n2;
        }

        public int getSortPriority() {
            return this.sortPriority;
        }
    }

    private static class AttribValueItem
    extends SpringXMLConfigCompletionItem {
        private String displayText;
        private String docText;

        public AttribValueItem(int n, String string, String string2) {
            super(n);
            this.displayText = string;
            this.docText = string2;
        }

        public int getSortPriority() {
            return 50;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        protected String getLeftHtmlText() {
            return this.displayText;
        }

        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet completionResultSet, Document document, int n) {
                    if (AttribValueItem.this.docText != null) {
                        SpringXMLConfigCompletionDoc springXMLConfigCompletionDoc = SpringXMLConfigCompletionDoc.getAttribValueDoc(AttribValueItem.this.docText);
                        completionResultSet.setDocumentation((CompletionDocumentation)springXMLConfigCompletionDoc);
                    }
                    completionResultSet.finish();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodItem
    extends SpringXMLConfigCompletionItem {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
        private static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
        private static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        private Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private boolean isPrimitive;
        private String typeName;
        private String sortText;
        private String leftText;
        private boolean isInherited;
        private String rightText;
        private static final int PUBLIC_LEVEL = 3;
        private static final int PROTECTED_LEVEL = 2;
        private static final int PACKAGE_LEVEL = 1;
        private static final int PRIVATE_LEVEL = 0;

        public MethodItem(int n, ExecutableElement executableElement, boolean bl, boolean bl2) {
            super(n);
            TypeMirror typeMirror;
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isDeprecated = bl2;
            this.isInherited = bl;
            this.simpleName = executableElement.getSimpleName().toString();
            this.modifiers = executableElement.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
            Iterator<? extends TypeMirror> iterator2 = ((ExecutableType)executableElement.asType()).getParameterTypes().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                typeMirror = iterator2.next();
                this.params.add(new ParamDesc(((Object)typeMirror).toString(), ((Object)MethodItem.getTypeName(typeMirror, false, executableElement.isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
            }
            typeMirror = executableElement.getReturnType();
            this.typeName = ((Object)MethodItem.getTypeName(typeMirror, false)).toString();
            this.isPrimitive = typeMirror.getKind().isPrimitive() || typeMirror.getKind() == TypeKind.VOID;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = this.simpleName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(METHOD_COLOR);
                if (!this.isInherited) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.BOLD_END);
                }
                stringBuilder.append(SpringXMLConfigCompletionItem.COLOR_END);
                stringBuilder.append('(');
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(SpringXMLConfigCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(SpringXMLConfigCompletionItem.COLOR_END);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = SpringXMLConfigCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        @Override
        protected ImageIcon getIcon() {
            int n = MethodItem.getProtectionLevel(this.modifiers);
            boolean bl = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon imageIcon = icon[bl ? 1 : 0][n];
            if (imageIcon != null) {
                return imageIcon;
            }
            String string = METHOD_PUBLIC;
            if (bl) {
                switch (n) {
                    case 0: {
                        string = METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        string = METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon imageIcon2 = ImageUtilities.loadImageIcon((String)string, (boolean)false);
            MethodItem.icon[bl ? 1 : 0][n] = imageIcon2;
            return imageIcon2;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaElementDocQuery(this.elementHandle), EditorRegistry.lastFocusedComponent());
        }

        private static int getProtectionLevel(Set<Modifier> set) {
            if (set.contains((Object)Modifier.PUBLIC)) {
                return 3;
            }
            if (set.contains((Object)Modifier.PROTECTED)) {
                return 2;
            }
            if (set.contains((Object)Modifier.PRIVATE)) {
                return 0;
            }
            return 1;
        }

        static class ParamDesc {
            private String fullTypeName;
            private String typeName;
            private String name;

            public ParamDesc(String string, String string2, String string3) {
                this.fullTypeName = string;
                this.typeName = string2;
                this.name = string3;
            }
        }
    }

    private static class PackageItem
    extends SpringXMLConfigCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean deprecated;
        private String simpleName;
        private String sortText;
        private String leftText;

        public PackageItem(int n, String string, boolean bl) {
            super(n);
            int n2 = string.lastIndexOf(46);
            this.simpleName = n2 < 0 ? string : string.substring(n2 + 1);
            this.deprecated = bl;
            this.sortText = this.simpleName + "#" + string;
        }

        public int getSortPriority() {
            return 50;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 400 && keyEvent.getKeyChar() == '.') {
                Completion.get().hideDocumentation();
                JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                int n = jTextComponent.getSelectionEnd();
                this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, Character.toString(keyEvent.getKeyChar()));
                Completion.get().showCompletion();
                keyEvent.consume();
            }
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false);
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PACKAGE_COLOR);
                if (this.deprecated) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.deprecated) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.STRIKE_END);
                }
                stringBuilder.append(SpringXMLConfigCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassItem
    extends SpringXMLConfigCompletionItem {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private ElementHandle<TypeElement> elemHandle;
        private boolean deprecated;
        private String displayName;
        private String enclName;
        private String sortText;
        private String leftText;
        private boolean smartItem;

        public ClassItem(int n, TypeElement typeElement, ElementHandle<TypeElement> elementHandle, boolean bl, boolean bl2) {
            super(n);
            this.elemHandle = elementHandle;
            this.deprecated = bl;
            this.displayName = bl2 ? typeElement.getSimpleName().toString() : this.getRelativeName(typeElement);
            this.enclName = ((Object)ClassItem.getElementName(typeElement.getEnclosingElement(), true)).toString();
            this.sortText = this.displayName + ClassItem.getImportanceLevel(this.enclName) + "#" + this.enclName;
            this.smartItem = bl2;
        }

        private String getRelativeName(TypeElement typeElement) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(typeElement.getSimpleName().toString());
            Element element = typeElement.getEnclosingElement();
            while (element.getKind() != ElementKind.PACKAGE) {
                stringBuilder.insert(0, element.getSimpleName().toString() + "$");
                element = element.getEnclosingElement();
            }
            return stringBuilder.toString();
        }

        public int getSortPriority() {
            return 200;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.smartItem ? "" : this.elemHandle.getBinaryName();
        }

        @Override
        protected CharSequence getSubstitutionText() {
            return this.elemHandle.getBinaryName();
        }

        @Override
        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getColor());
                if (this.deprecated) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.STRIKE);
                }
                stringBuilder.append(this.displayName);
                if (this.deprecated) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.STRIKE_END);
                }
                if (this.smartItem && this.enclName != null && this.enclName.length() > 0) {
                    stringBuilder.append(SpringXMLConfigCompletionItem.COLOR_END);
                    stringBuilder.append(PKG_COLOR);
                    stringBuilder.append(" (");
                    stringBuilder.append(this.enclName);
                    stringBuilder.append(")");
                }
                stringBuilder.append(SpringXMLConfigCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)CLASS, (boolean)false);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaElementDocQuery(this.elemHandle), EditorRegistry.lastFocusedComponent());
        }
    }

    private static class BeanRefItem
    extends SpringXMLConfigCompletionItem {
        private static final String CLASS_COLOR = "<font color=#808080>";
        private String beanId;
        private String beanClass;
        private List<String> beanNames;
        private String displayName;
        private String beanLocFile;
        private Action goToBeanAction;
        private String leftText;

        public BeanRefItem(int n, String string, SpringBean springBean, FileObject fileObject) {
            super(n);
            File file;
            FileObject fileObject2;
            this.beanId = springBean.getId();
            this.beanClass = springBean.getClassName();
            this.beanNames = springBean.getNames();
            if (springBean.getLocation() != null && (fileObject2 = FileUtil.toFileObject((File)(file = springBean.getLocation().getFile()))) != null) {
                this.beanLocFile = FileUtil.getRelativePath((FileObject)fileObject.getParent(), (FileObject)fileObject2);
            }
            this.goToBeanAction = SpringBeansUIs.createGoToBeanAction(springBean);
            this.displayName = string;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayName;
        }

        public CharSequence getInsertPrefix() {
            return this.displayName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.displayName);
                stringBuilder.append(CLASS_COLOR);
                stringBuilder.append(" (");
                if (this.beanClass != null) {
                    stringBuilder.append(this.beanClass);
                }
                stringBuilder.append(")");
                stringBuilder.append(SpringXMLConfigCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return this.beanLocFile;
        }

        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/spring/beans/resources/spring-bean.png", (boolean)false);
        }

        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet completionResultSet, Document document, int n) {
                    SpringXMLConfigCompletionDoc springXMLConfigCompletionDoc = SpringXMLConfigCompletionDoc.createBeanRefDoc(BeanRefItem.this.beanId, BeanRefItem.this.beanNames, BeanRefItem.this.beanClass, BeanRefItem.this.beanLocFile, BeanRefItem.this.goToBeanAction);
                    completionResultSet.setDocumentation((CompletionDocumentation)springXMLConfigCompletionDoc);
                    completionResultSet.finish();
                }
            });
        }
    }
}

