/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.util.Vector;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.netbeans.modules.ant.debugger.Utils;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;

public class BreakpointModel
implements NodeModel {
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/Breakpoint";
    public static final String LINE_BREAKPOINT_PC = "org/netbeans/modules/debugger/resources/editor/Breakpoint+PC";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint";
    private Vector listeners = new Vector();

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof AntBreakpoint) {
            AntBreakpoint antBreakpoint = (AntBreakpoint)((Object)object);
            FileObject fileObject = (FileObject)antBreakpoint.getLine().getLookup().lookup(FileObject.class);
            return fileObject.getNameExt() + ":" + (antBreakpoint.getLine().getLineNumber() + 1);
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof AntBreakpoint) {
            AntBreakpoint antBreakpoint = (AntBreakpoint)((Object)object);
            if (!((AntBreakpoint)((Object)object)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            AntDebugger antDebugger = BreakpointModel.getDebugger();
            if (antDebugger != null && Utils.contains(antDebugger.getCurrentLine(), antBreakpoint.getLine())) {
                return LINE_BREAKPOINT_PC;
            }
            return LINE_BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof AntBreakpoint) {
            AntBreakpoint antBreakpoint = (AntBreakpoint)((Object)object);
            return antBreakpoint.getLine().getDisplayName();
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private static AntDebugger getDebugger() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (AntDebugger)((Object)debuggerEngine.lookupFirst(null, AntDebugger.class));
    }
}

