/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.ActionButton;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.InstallConfig;
import org.netbeans.modules.welcome.ui.SampleProjectAction;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;

class GetStarted
extends JPanel
implements Constants {
    private int row;
    private InstallConfig ic;
    private boolean foregroundColorFlag = true;

    public GetStarted() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.ic = InstallConfig.getDefault();
        this.buildContent();
    }

    private void buildContent() {
        String string = this.ic.isJavaFXInstalled() ? "WelcomePage/GettingStartedLinksJavaFX" : "WelcomePage/GettingStartedLinks";
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (null == fileObject) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: FileObject: " + string);
            return;
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        if (null == dataFolder) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: DataFolder: " + string);
            return;
        }
        DataObject[] dataObjectArray = dataFolder.getChildren();
        if (null == dataObjectArray) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: DataObject: " + string);
            return;
        }
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (dataObjectArray[i].getPrimaryFile().isFolder()) {
                String string2 = dataObjectArray[i].getNodeDelegate().getDisplayName();
                JLabel jLabel = new JLabel(string2);
                jLabel.setFont(BUTTON_FONT);
                jLabel.setHorizontalAlignment(2);
                jLabel.setOpaque(true);
                jLabel.setBorder(HEADER_TEXT_BORDER);
                this.add((Component)jLabel, new GridBagConstraints(0, this.row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                DataFolder dataFolder2 = DataFolder.findFolder((FileObject)dataObjectArray[i].getPrimaryFile());
                DataObject[] dataObjectArray2 = dataFolder2.getChildren();
                for (int j = 0; j < dataObjectArray2.length; ++j) {
                    this.row = this.addLink(this.row, dataObjectArray2[j]);
                }
                continue;
            }
            this.row = this.addLink(this.row, dataObjectArray[i]);
        }
        this.add((Component)new JLabel(), new GridBagConstraints(0, this.row++, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private int addLink(int n, DataObject dataObject) {
        Object object;
        FileObject fileObject = dataObject.getPrimaryFile();
        String string = fileObject.getName();
        if (!string.endsWith("_default") && !string.endsWith((String)(object = this.ic.getPreferredPackName()))) {
            return n;
        }
        object = this.extractAction(dataObject);
        if (null != object) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            ActionButton actionButton = new ActionButton((Action)object, false, Utils.getUrlString(dataObject), Utils.getColor(this.foregroundColorFlag ? "HeaderForegroundColor1" : "HeaderForegroundColor2"));
            this.foregroundColorFlag = !this.foregroundColorFlag;
            jPanel.add((Component)actionButton, new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            actionButton.setFont(GET_STARTED_FONT);
            jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 3, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            int n2 = new JLabel().getIconTextGap();
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/bullet.png", (boolean)true);
            JLabel jLabel = new JLabel(new ImageIcon(image));
            jLabel.setVerticalAlignment(0);
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, n2), 0, 0));
            actionButton.getAccessibleContext().setAccessibleName(actionButton.getText());
            actionButton.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("GettingStarted", actionButton.getText()));
            this.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 7, 0), 0, 0));
        }
        return n;
    }

    private Action extractAction(DataObject dataObject) {
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (null != openCookie) {
            return new LinkAction(dataObject);
        }
        InstanceCookie.Of of = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class);
        if (null != of && of.instanceOf(Action.class)) {
            try {
                Action action = (Action)of.instanceCreate();
                if (null != action) {
                    action.putValue("Name", dataObject.getNodeDelegate().getDisplayName());
                }
                return action;
            }
            catch (Exception exception) {
                Logger.getLogger(SampleProjectAction.class.getName()).log(Level.INFO, null, exception);
            }
        }
        return null;
    }

    private static class LinkAction
    extends AbstractAction {
        private DataObject dob;

        public LinkAction(DataObject dataObject) {
            super(dataObject.getNodeDelegate().getDisplayName());
            this.dob = dataObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OpenCookie openCookie = (OpenCookie)this.dob.getCookie(OpenCookie.class);
            if (null != openCookie) {
                openCookie.open();
            }
        }
    }
}

