/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.IssueNode;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueNode;
import org.netbeans.modules.bugzilla.issue.IssueController;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaIssue
extends Issue {
    public static final String RESOLVE_FIXED = "FIXED";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final int SHORTENED_SUMMARY_LENGTH = 22;
    private TaskData data;
    private BugzillaRepository repository;
    private IssueController controller;
    private IssueNode node;
    static final String LABEL_NAME_ID = "bugzilla.issue.id";
    static final String LABEL_NAME_SEVERITY = "bugzilla.issue.severity";
    static final String LABEL_NAME_PRIORITY = "bugzilla.issue.priority";
    static final String LABEL_NAME_STATUS = "bugzilla.issue.status";
    static final String LABEL_NAME_RESOLUTION = "bugzilla.issue.resolution";
    static final String LABEL_NAME_SUMMARY = "bugzilla.issue.summary";
    static final int FIELD_STATUS_IRELEVANT = -1;
    static final int FIELD_STATUS_UPTODATE = 1;
    static final int FIELD_STATUS_NEW = 2;
    static final int FIELD_STATUS_MODIFIED = 4;
    private Map<String, String> seenAtributes;
    private Map<String, String> attributes;

    public BugzillaIssue(TaskData taskData, BugzillaRepository bugzillaRepository) {
        super((Repository)bugzillaRepository);
        this.data = taskData;
        this.repository = bugzillaRepository;
    }

    void opened() {
        String string = System.getProperty("org.netbeans.modules.bugzilla.noIssueRefresh");
        if (string != null && string.equals("true")) {
            return;
        }
        this.repository.scheduleForRefresh(this.getID());
    }

    void closed() {
        this.repository.stopRefreshing(this.getID());
    }

    public String getDisplayName() {
        return this.data.isNew() ? NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_NewIssue") : NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue", (Object[])new Object[]{this.getID(), this.getSummary()});
    }

    public String getShortenedDisplayName() {
        if (this.data.isNew()) {
            return this.getDisplayName();
        }
        String string = TextUtils.shortenText((String)this.getSummary(), (int)2, (int)22);
        return NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue", (Object[])new Object[]{this.getID(), string});
    }

    public String getTooltip() {
        return this.getDisplayName();
    }

    public static Query.ColumnDescriptor[] getColumnDescriptors(BugzillaRepository bugzillaRepository) {
        ResourceBundle resourceBundle = NbBundle.getBundle(BugzillaIssue.class);
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        JTable jTable = new JTable();
        return new Query.ColumnDescriptor[]{new Query.ColumnDescriptor(LABEL_NAME_ID, String.class, resourceBundle.getString("CTL_Issue_ID_Title"), resourceBundle.getString("CTL_Issue_ID_Desc"), BugtrackingUtil.getColumnWidthInPixels((int)7, (JComponent)jTable)), new Query.ColumnDescriptor(LABEL_NAME_SUMMARY, String.class, resourceBundle.getString("CTL_Issue_Summary_Title"), resourceBundle.getString("CTL_Issue_Summary_Desc")), new Query.ColumnDescriptor(LABEL_NAME_SEVERITY, String.class, resourceBundle.getString("CTL_Issue_Severity_Title"), resourceBundle.getString("CTL_Issue_Severity_Desc"), BugzillaIssue.getLongestWordWidth(resourceBundle.getString("CTL_Issue_Severity_Title"), bugzillaConfiguration.getSeverities(), jTable)), new Query.ColumnDescriptor(LABEL_NAME_PRIORITY, String.class, resourceBundle.getString("CTL_Issue_Priority_Title"), resourceBundle.getString("CTL_Issue_Priority_Desc"), BugzillaIssue.getLongestWordWidth(resourceBundle.getString("CTL_Issue_Priority_Title"), bugzillaConfiguration.getPriorities(), jTable)), new Query.ColumnDescriptor(LABEL_NAME_STATUS, String.class, resourceBundle.getString("CTL_Issue_Status_Title"), resourceBundle.getString("CTL_Issue_Status_Desc"), BugzillaIssue.getLongestWordWidth(resourceBundle.getString("CTL_Issue_Status_Title"), bugzillaConfiguration.getStatusValues(), jTable)), new Query.ColumnDescriptor(LABEL_NAME_RESOLUTION, String.class, resourceBundle.getString("CTL_Issue_Resolution_Title"), resourceBundle.getString("CTL_Issue_Resolution_Desc"), BugzillaIssue.getLongestWordWidth(resourceBundle.getString("CTL_Issue_Resolution_Title"), bugzillaConfiguration.getResolutions(), jTable))};
    }

    private static int getLongestWordWidth(String string, List<String> list, JComponent jComponent) {
        int n = string.length();
        for (String string2 : list) {
            if (n >= string2.length()) continue;
            n = string2.length();
        }
        return BugtrackingUtil.getColumnWidthInPixels((int)n, (JComponent)jComponent);
    }

    public BugtrackingController getController() {
        if (this.controller == null) {
            this.controller = new IssueController(this);
        }
        return this.controller;
    }

    public String toString() {
        String string = this.getID() + " : " + this.getSummary();
        return string;
    }

    public IssueNode getNode() {
        if (this.node == null) {
            this.node = this.createNode();
        }
        return this.node;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
            for (IssueField issueField : IssueField.values()) {
                switch (issueField) {
                    default: 
                }
                String string = this.getFieldValue(issueField);
                if (string == null || string.trim().equals("")) continue;
                this.attributes.put(issueField.key, string);
            }
        }
        return this.attributes;
    }

    public void setSeen(boolean bl) throws IOException {
        this.seenAtributes = bl ? this.repository.getIssueCache().getSeenAttributes(this.getID()) : null;
        super.setSeen(bl);
    }

    public String getRecentChanges() {
        if (this.wasSeen()) {
            return "";
        }
        int n = this.repository.getIssueCache().getStatus(this.getID());
        if (n == 4) {
            return NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_NEW_STATUS");
        }
        if (n == 8) {
            String string;
            String string2;
            ArrayList<IssueField> arrayList = new ArrayList<IssueField>();
            Map<String, String> map = this.getSeenAttributes();
            assert (map != null);
            block28: for (IssueField issueField : IssueField.values()) {
                switch (issueField) {
                    case MODIFICATION: 
                    case REPORTER_NAME: 
                    case QA_CONTACT_NAME: 
                    case ASSIGNED_TO_NAME: {
                        continue block28;
                    }
                    default: {
                        string2 = this.getFieldValue(issueField);
                        string = map.get(issueField.key);
                        if (string == null) {
                            string = "";
                        }
                        if (string2.trim().equals(string)) continue block28;
                        arrayList.add(issueField);
                    }
                }
            }
            int n2 = arrayList.size();
            if (n2 == 1) {
                String string3 = null;
                block29: for (IssueField issueField : arrayList) {
                    switch (issueField) {
                        case SUMMARY: {
                            string3 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_SUMMARY_CHANGED_STATUS");
                            continue block29;
                        }
                        case CC: {
                            string3 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CC_FIELD_CHANGED_STATUS");
                            continue block29;
                        }
                        case KEYWORDS: {
                            string3 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_KEYWORDS_CHANGED_STATUS");
                            continue block29;
                        }
                        case DEPENDS_ON: 
                        case BLOCKS: {
                            string3 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_DEPENDENCE_CHANGED_STATUS");
                            continue block29;
                        }
                        case COMMENT_COUNT: {
                            string2 = this.getFieldValue(issueField);
                            string = map.get(issueField.key);
                            int n3 = 0;
                            try {
                                n3 = Integer.parseInt(string2) - Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                Bugzilla.LOG.log(Level.WARNING, string3, numberFormatException);
                            }
                            string3 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_COMMENTS_CHANGED", (Object[])new Object[]{n3});
                            continue block29;
                        }
                        case ATTACHEMENT_COUNT: {
                            string3 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_ATTACHMENTS_CHANGED");
                            continue block29;
                        }
                    }
                    string3 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGED_TO", (Object[])new Object[]{issueField.getDisplayName(), this.getFieldValue(issueField)});
                }
                return string3;
            }
            String string4 = null;
            Iterator iterator = arrayList.iterator();
            if (iterator.hasNext()) {
                IssueField issueField;
                issueField = (IssueField)((Object)iterator.next());
                switch (issueField) {
                    case SUMMARY: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_SUMMARY", (Object[])new Object[]{n2});
                        break;
                    }
                    case PRIORITY: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_PRIORITY", (Object[])new Object[]{n2});
                        break;
                    }
                    case SEVERITY: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_SEVERITY", (Object[])new Object[]{n2});
                        break;
                    }
                    case PRODUCT: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_PRODUCT", (Object[])new Object[]{n2});
                        break;
                    }
                    case COMPONENT: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_COMPONENT", (Object[])new Object[]{n2});
                        break;
                    }
                    case PLATFORM: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_PLATFORM", (Object[])new Object[]{n2});
                        break;
                    }
                    case VERSION: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_VERSION", (Object[])new Object[]{n2});
                        break;
                    }
                    case MILESTONE: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_MILESTONE", (Object[])new Object[]{n2});
                        break;
                    }
                    case KEYWORDS: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_KEYWORDS", (Object[])new Object[]{n2});
                        break;
                    }
                    case URL: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_URL", (Object[])new Object[]{n2});
                        break;
                    }
                    case ASSIGNED_TO: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_ASSIGNEE", (Object[])new Object[]{n2});
                        break;
                    }
                    case QA_CONTACT: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCL_QA_CONTACT", (Object[])new Object[]{n2});
                        break;
                    }
                    case DEPENDS_ON: 
                    case BLOCKS: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES_INCLUSIVE_DEPENDENCE", (Object[])new Object[]{n2});
                        break;
                    }
                    default: {
                        string4 = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGES", (Object[])new Object[]{n2});
                    }
                }
                return string4;
            }
        }
        return "";
    }

    public static String getID(TaskData taskData) {
        if (taskData.isNew()) {
            return null;
        }
        return taskData.getTaskId();
    }

    TaskRepository getTaskRepository() {
        return this.repository.getTaskRepository();
    }

    BugzillaRepository getRepository() {
        return this.repository;
    }

    public String getID() {
        return BugzillaIssue.getID(this.data);
    }

    public String getSummary() {
        return this.getFieldValue(IssueField.SUMMARY);
    }

    public void setTaskData(TaskData taskData) {
        assert (!taskData.isPartial());
        this.data = taskData;
        this.attributes = null;
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            public void run() {
                ((BugzillaIssueNode)BugzillaIssue.this.getNode()).fireDataChanged();
                BugzillaIssue.this.fireDataChanged();
            }
        });
    }

    TaskData getTaskData() {
        return this.data;
    }

    String getFieldValue(IssueField issueField) {
        if (issueField.isSingleAttribute()) {
            TaskAttribute taskAttribute = this.data.getRoot().getMappedAttribute(issueField.key);
            if (taskAttribute != null && taskAttribute.getValues().size() > 1) {
                return this.listValues(taskAttribute);
            }
            return taskAttribute != null ? taskAttribute.getValue() : "";
        }
        List list = this.data.getAttributeMapper().getAttributesByType(this.data, issueField.key);
        return "" + (list != null && list.size() > 0 ? Integer.valueOf(list.size()) : "");
    }

    private String listValues(TaskAttribute taskAttribute) {
        if (taskAttribute == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        List list = taskAttribute.getValues();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            stringBuffer.append(string);
            if (i >= list.size() - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    void setFieldValue(IssueField issueField, String string) {
        if (issueField.isReadOnly()) {
            assert (false) : "can't set value into IssueField " + issueField.name();
            return;
        }
        TaskAttribute taskAttribute = this.data.getRoot().getMappedAttribute(issueField.key);
        if (taskAttribute == null) {
            taskAttribute = new TaskAttribute(this.data.getRoot(), issueField.key);
        }
        taskAttribute.setValue(string);
    }

    List<String> getFieldValues(IssueField issueField) {
        if (issueField.isSingleAttribute()) {
            TaskAttribute taskAttribute = this.data.getRoot().getMappedAttribute(issueField.key);
            if (taskAttribute != null) {
                return taskAttribute.getValues();
            }
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getFieldValue(issueField));
        return arrayList;
    }

    void setFieldValues(IssueField issueField, List<String> list) {
        TaskAttribute taskAttribute = this.data.getRoot().getMappedAttribute(issueField.key);
        if (taskAttribute == null) {
            taskAttribute = new TaskAttribute(this.data.getRoot(), issueField.key);
        }
        taskAttribute.setValues(list);
    }

    int getFieldStatus(IssueField issueField) {
        String string;
        Map<String, String> map = this.getSeenAttributes();
        String string2 = string = map != null ? map.get(issueField.key) : null;
        if (string == null) {
            string = "";
        }
        if (string.equals("") && !string.equals(this.getFieldValue(issueField))) {
            return 2;
        }
        if (!string.equals(this.getFieldValue(issueField))) {
            return 4;
        }
        return 1;
    }

    private IssueNode createNode() {
        return new BugzillaIssueNode(this);
    }

    void resolve(String string) {
        assert (!this.data.isNew());
        String string2 = this.getFieldValue(IssueField.STATUS);
        if (!string2.equals("RESOLVED")) {
            this.setOperation(BugzillaOperation.resolve);
            TaskAttribute taskAttribute = this.data.getRoot();
            TaskAttribute taskAttribute2 = taskAttribute.getMappedAttribute(BugzillaOperation.resolve.getInputId());
            assert (taskAttribute2 != null);
            if (taskAttribute2 != null) {
                taskAttribute2.setValue(string);
            } else {
                Bugzilla.LOG.warning("Can't set resolve operation for issue " + this.getID());
            }
        }
    }

    void accept() {
        this.setOperation(BugzillaOperation.accept);
    }

    void duplicate(String string) {
        this.setOperation(BugzillaOperation.duplicate);
        TaskAttribute taskAttribute = this.data.getRoot();
        TaskAttribute taskAttribute2 = taskAttribute.getMappedAttribute(BugzillaOperation.duplicate.getInputId());
        taskAttribute2.setValue(string);
    }

    void reassign(String string) {
        this.setOperation(BugzillaOperation.reassign);
        TaskAttribute taskAttribute = this.data.getRoot();
        TaskAttribute taskAttribute2 = taskAttribute.getMappedAttribute(BugzillaOperation.reassign.getInputId());
        if (taskAttribute2 != null) {
            taskAttribute2.setValue(string);
        }
        if ((taskAttribute2 = taskAttribute.getMappedAttribute(BugzillaAttribute.ASSIGNED_TO.getKey())) != null) {
            taskAttribute2.setValue(string);
        }
    }

    void verify() {
        this.setOperation(BugzillaOperation.verify);
    }

    void close() {
        this.setOperation(BugzillaOperation.close);
    }

    void reopen() {
        this.setOperation(BugzillaOperation.reopen);
    }

    private void setOperation(BugzillaOperation bugzillaOperation) {
        TaskAttribute taskAttribute = this.data.getRoot();
        TaskAttribute taskAttribute2 = taskAttribute.getMappedAttribute("task.common.operation");
        taskAttribute2.setValue(bugzillaOperation.name());
    }

    Attachment[] getAttachments() {
        List list = this.data.getAttributeMapper().getAttributesByType(this.data, "attachment");
        if (list == null) {
            return new Attachment[0];
        }
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>(list.size());
        for (TaskAttribute taskAttribute : list) {
            arrayList.add(new Attachment(taskAttribute));
        }
        return arrayList.toArray(new Attachment[arrayList.size()]);
    }

    void addAttachment(File file, final String string, String string2, String string3, boolean bl) {
        String string4;
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        final FileTaskAttachmentSource fileTaskAttachmentSource = new FileTaskAttachmentSource(file);
        if (string3 == null) {
            string4 = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)file));
            string3 = string4 != null && !"content/unknown".equals(string4) ? string4 : FileTaskAttachmentSource.getContentTypeFromFilename((String)file.getName());
        }
        fileTaskAttachmentSource.setContentType(string3);
        string4 = new TaskAttribute(this.data.getRoot(), "attachment");
        TaskAttributeMapper taskAttributeMapper = string4.getTaskData().getAttributeMapper();
        TaskAttribute taskAttribute = string4.createMappedAttribute("task.common.attachment.description");
        taskAttribute.setValue(string2);
        taskAttribute = string4.createMappedAttribute("task.common.attachment.patch");
        taskAttributeMapper.setBooleanValue(taskAttribute, Boolean.valueOf(bl));
        taskAttribute = string4.createMappedAttribute("task.common.attachment.ctype");
        taskAttribute.setValue(string3);
        BugzillaCommand bugzillaCommand = new BugzillaCommand((TaskAttribute)string4){
            final /* synthetic */ TaskAttribute val$attAttribute;
            {
                this.val$attAttribute = taskAttribute;
            }

            public void execute() throws CoreException, IOException, MalformedURLException {
                BugzillaIssue.this.refresh();
                Bugzilla.getInstance().getClient(BugzillaIssue.this.repository).postAttachment(BugzillaIssue.this.getID(), string, (AbstractTaskAttachmentSource)fileTaskAttachmentSource, this.val$attAttribute, (IProgressMonitor)new NullProgressMonitor());
                BugzillaIssue.this.refresh();
            }
        };
        this.repository.getExecutor().execute(bugzillaCommand);
    }

    Comment[] getComments() {
        List list = this.data.getAttributeMapper().getAttributesByType(this.data, "comment");
        if (list == null) {
            return new Comment[0];
        }
        ArrayList<Comment> arrayList = new ArrayList<Comment>();
        for (TaskAttribute taskAttribute : list) {
            arrayList.add(new Comment(taskAttribute));
        }
        return arrayList.toArray(new Comment[arrayList.size()]);
    }

    public void addComment(String string, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        if (string == null && !bl) {
            return;
        }
        this.refresh();
        if (bl) {
            this.resolve(RESOLVE_FIXED);
        }
        if (string != null) {
            this.addComment(string);
        }
        BugzillaCommand bugzillaCommand = new BugzillaCommand(){

            public void execute() throws CoreException, IOException, MalformedURLException {
                BugzillaIssue.this.submitAndRefresh();
            }
        };
        this.repository.getExecutor().execute(bugzillaCommand);
    }

    public void addComment(String string) {
        if (string != null) {
            TaskAttribute taskAttribute = this.data.getRoot().createMappedAttribute("task.common.comment.new");
            taskAttribute.setValue(string);
        }
    }

    public void attachPatch(File file, String string) {
        this.addAttachment(file, null, string, null, true);
    }

    boolean submitAndRefresh() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        final boolean bl = this.data.isNew();
        boolean bl2 = bl || this.repository.getIssueCache().wasSeen(this.getID());
        final RepositoryResponse[] repositoryResponseArray = new RepositoryResponse[1];
        final BugzillaCommand bugzillaCommand = new BugzillaCommand(){

            public void execute() throws CoreException, IOException, MalformedURLException {
                repositoryResponseArray[0] = Bugzilla.getInstance().getRepositoryConnector().getTaskDataHandler().postTaskData(BugzillaIssue.this.getTaskRepository(), BugzillaIssue.this.data, null, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        this.repository.getExecutor().execute(bugzillaCommand);
        BugzillaCommand bugzillaCommand2 = new BugzillaCommand(){

            public void execute() throws CoreException, IOException, MalformedURLException {
                if (!bl) {
                    BugzillaIssue.this.refresh();
                } else if (!bugzillaCommand.hasFailed()) {
                    assert (repositoryResponseArray[0] != null);
                    BugzillaIssue.this.refresh(repositoryResponseArray[0].getTaskId(), true);
                }
            }
        };
        this.repository.getExecutor().execute(bugzillaCommand2);
        if (bugzillaCommand.hasFailed()) {
            return false;
        }
        if (bl2) {
            try {
                this.repository.getIssueCache().setSeen(this.getID(), true);
            }
            catch (IOException iOException) {
                Bugzilla.LOG.log(Level.SEVERE, null, iOException);
            }
        }
        if (bl) {
            this.repository.refreshAllQueries();
        }
        this.seenAtributes = null;
        return true;
    }

    public boolean refresh() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        return this.refresh(this.getID(), false);
    }

    public boolean refresh(String string, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        try {
            TaskData taskData = BugzillaUtil.getTaskData(this.repository, string);
            if (taskData == null) {
                return false;
            }
            this.getRepository().getIssueCache().setIssueData(string, (Object)taskData, (Issue)this);
            if (this.controller != null) {
                this.controller.refreshViewData();
            }
        }
        catch (IOException iOException) {
            Bugzilla.LOG.log(Level.SEVERE, null, iOException);
        }
        return true;
    }

    private Map<String, String> getSeenAttributes() {
        if (this.seenAtributes == null) {
            this.seenAtributes = this.repository.getIssueCache().getSeenAttributes(this.getID());
            if (this.seenAtributes == null) {
                this.seenAtributes = new HashMap<String, String>();
            }
        }
        return this.seenAtributes;
    }

    private String getMappedValue(TaskAttribute taskAttribute, String string) {
        TaskAttribute taskAttribute2 = taskAttribute.getMappedAttribute(string);
        if (taskAttribute2 != null) {
            return taskAttribute2.getValue();
        }
        return null;
    }

    class Attachment {
        private final String desc;
        private final String filename;
        private final String author;
        private final Date date;
        private final String id;
        private String contentType;
        private String isDeprected;
        private String size;
        private String isPatch;
        private String url;

        public Attachment(TaskAttribute taskAttribute) {
            String string;
            this.id = taskAttribute.getValue();
            Date date = null;
            try {
                string = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.attachment.date");
                if (string != null && !string.trim().equals("")) {
                    date = CC_DATE_FORMAT.parse(string);
                }
            }
            catch (ParseException parseException) {
                Bugzilla.LOG.log(Level.SEVERE, null, parseException);
            }
            this.date = date;
            this.filename = BugzillaIssue.this.getMappedValue(taskAttribute, "filename");
            this.desc = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.attachment.description");
            string = null;
            TaskAttribute taskAttribute2 = taskAttribute.getMappedAttribute("task.common.attachment.author");
            if (taskAttribute2 != null) {
                TaskAttribute taskAttribute3 = taskAttribute2.getMappedAttribute("task.common.person.name");
                String string2 = string = taskAttribute3 != null ? taskAttribute3.getValue() : null;
            }
            if ((string == null || string.trim().equals("")) && taskAttribute2 != null) {
                string = taskAttribute2.getValue();
            }
            this.author = string;
            this.contentType = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.attachment.ctype");
            this.isDeprected = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.attachment.deprecated");
            this.isPatch = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.attachment.patch");
            this.size = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.attachment.size");
            this.url = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.attachment.url");
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getId() {
            return this.id;
        }

        public String getIsDeprected() {
            return this.isDeprected;
        }

        public String getIsPatch() {
            return this.isPatch;
        }

        public String getSize() {
            return this.size;
        }

        public String getUrl() {
            return this.url;
        }

        public void getAttachementData(final OutputStream outputStream) {
            assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
            BugzillaCommand bugzillaCommand = new BugzillaCommand(){

                public void execute() throws CoreException, IOException, MalformedURLException {
                    Bugzilla.getInstance().getClient(BugzillaIssue.this.repository).getAttachmentData(Attachment.this.id, outputStream, (IProgressMonitor)new NullProgressMonitor());
                }
            };
            BugzillaIssue.this.repository.getExecutor().execute(bugzillaCommand);
        }
    }

    class Comment {
        private final Date when;
        private final String who;
        private final Long number;
        private final String text;

        public Comment(TaskAttribute taskAttribute) {
            Object object;
            String string;
            Date date = null;
            try {
                string = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.comment.date");
                if (string != null && !string.trim().equals("")) {
                    date = CC_DATE_FORMAT.parse(string);
                }
            }
            catch (ParseException parseException) {
                Bugzilla.LOG.log(Level.SEVERE, null, parseException);
            }
            this.when = date;
            string = taskAttribute.getMappedAttribute("task.common.comment.author");
            String string2 = null;
            if (string != null) {
                object = string.getMappedAttribute("task.common.person.name");
                String string3 = string2 = object != null ? object.getValue() : null;
            }
            if ((string2 == null || string2.trim().equals("")) && string != null) {
                string2 = string.getValue();
            }
            this.who = string2;
            object = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.comment.number");
            this.number = object != null ? Long.valueOf(Long.parseLong((String)object)) : null;
            this.text = BugzillaIssue.this.getMappedValue(taskAttribute, "task.common.comment.text");
        }

        public Long getNumber() {
            return this.number;
        }

        public String getText() {
            return this.text;
        }

        public Date getWhen() {
            return this.when;
        }

        public String getWho() {
            return this.who;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IssueField
    extends Enum<IssueField> {
        public static final /* enum */ IssueField SUMMARY = new IssueField(BugzillaAttribute.SHORT_DESC.getKey(), "LBL_SUMMARY");
        public static final /* enum */ IssueField STATUS = new IssueField("task.common.status", "LBL_STATUS");
        public static final /* enum */ IssueField PRIORITY = new IssueField(BugzillaAttribute.PRIORITY.getKey(), "LBL_PRIORITY");
        public static final /* enum */ IssueField RESOLUTION = new IssueField("task.common.resolution", "LBL_RESOLUTION");
        public static final /* enum */ IssueField PRODUCT = new IssueField(BugzillaAttribute.PRODUCT.getKey(), "LBL_PRODUCT");
        public static final /* enum */ IssueField COMPONENT = new IssueField(BugzillaAttribute.COMPONENT.getKey(), "LBL_COMPONENT");
        public static final /* enum */ IssueField VERSION = new IssueField(BugzillaAttribute.VERSION.getKey(), "LBL_VERSION");
        public static final /* enum */ IssueField PLATFORM = new IssueField(BugzillaAttribute.REP_PLATFORM.getKey(), "LBL_PLATFORM");
        public static final /* enum */ IssueField OS = new IssueField(BugzillaAttribute.OP_SYS.getKey(), "LBL_OS");
        public static final /* enum */ IssueField MILESTONE = new IssueField(BugzillaAttribute.TARGET_MILESTONE.getKey(), "LBL_MILESTONE");
        public static final /* enum */ IssueField REPORTER = new IssueField(BugzillaAttribute.REPORTER.getKey(), "LBL_REPORTER");
        public static final /* enum */ IssueField REPORTER_NAME = new IssueField(BugzillaAttribute.REPORTER_NAME.getKey(), "LBL_REPORTER_NAME");
        public static final /* enum */ IssueField ASSIGNED_TO = new IssueField(BugzillaAttribute.ASSIGNED_TO.getKey(), "LBL_ASSIGNED_TO");
        public static final /* enum */ IssueField ASSIGNED_TO_NAME = new IssueField(BugzillaAttribute.ASSIGNED_TO_NAME.getKey(), "LBL_ASSIGNED_TO_NAME");
        public static final /* enum */ IssueField QA_CONTACT = new IssueField(BugzillaAttribute.QA_CONTACT.getKey(), "LBL_QA_CONTACT");
        public static final /* enum */ IssueField QA_CONTACT_NAME = new IssueField(BugzillaAttribute.QA_CONTACT_NAME.getKey(), "LBL_QA_CONTACT_NAME");
        public static final /* enum */ IssueField DEPENDS_ON = new IssueField(BugzillaAttribute.DEPENDSON.getKey(), "LBL_DEPENDS_ON");
        public static final /* enum */ IssueField BLOCKS = new IssueField(BugzillaAttribute.BLOCKED.getKey(), "LBL_BLOCKS");
        public static final /* enum */ IssueField URL = new IssueField(BugzillaAttribute.BUG_FILE_LOC.getKey(), "LBL_URL");
        public static final /* enum */ IssueField KEYWORDS = new IssueField(BugzillaAttribute.KEYWORDS.getKey(), "LBL_KEYWORDS");
        public static final /* enum */ IssueField SEVERITY = new IssueField(BugzillaAttribute.BUG_SEVERITY.getKey(), "LBL_SEVERITY");
        public static final /* enum */ IssueField DESCRIPTION = new IssueField(BugzillaAttribute.LONG_DESC.getKey(), "LBL_DESCRIPTION");
        public static final /* enum */ IssueField CREATION = new IssueField("task.common.date.created", "LBL_CREATION");
        public static final /* enum */ IssueField CC = new IssueField(BugzillaAttribute.CC.getKey(), "LBL_CC");
        public static final /* enum */ IssueField MODIFICATION = new IssueField("task.common.date.modified", null);
        public static final /* enum */ IssueField NEWCC = new IssueField(BugzillaAttribute.NEWCC.getKey(), null);
        public static final /* enum */ IssueField REMOVECC = new IssueField(BugzillaAttribute.REMOVECC.getKey(), null);
        public static final /* enum */ IssueField COMMENT_COUNT = new IssueField("comment", null, false);
        public static final /* enum */ IssueField ATTACHEMENT_COUNT = new IssueField("attachment", null, false);
        private final String key;
        private final String displayNameKey;
        private boolean singleAttribute;
        private static final /* synthetic */ IssueField[] $VALUES;

        public static IssueField[] values() {
            return (IssueField[])$VALUES.clone();
        }

        public static IssueField valueOf(String string) {
            return Enum.valueOf(IssueField.class, string);
        }

        private IssueField(String string2, String string3) {
            this(string2, string3, true);
        }

        private IssueField(String string2, String string3, boolean bl) {
            this.key = string2;
            this.singleAttribute = bl;
            this.displayNameKey = string3;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isSingleAttribute() {
            return this.singleAttribute;
        }

        public boolean isReadOnly() {
            return !this.singleAttribute;
        }

        public String getDisplayName() {
            assert (this.displayNameKey != null);
            return NbBundle.getMessage(BugzillaIssue.class, (String)this.displayNameKey);
        }

        static {
            $VALUES = new IssueField[]{SUMMARY, STATUS, PRIORITY, RESOLUTION, PRODUCT, COMPONENT, VERSION, PLATFORM, OS, MILESTONE, REPORTER, REPORTER_NAME, ASSIGNED_TO, ASSIGNED_TO_NAME, QA_CONTACT, QA_CONTACT_NAME, DEPENDS_ON, BLOCKS, URL, KEYWORDS, SEVERITY, DESCRIPTION, CREATION, CC, MODIFICATION, NEWCC, REMOVECC, COMMENT_COUNT, ATTACHEMENT_COUNT};
        }
    }
}

