/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionJList;

public class CompletionJListOperator
extends JListOperator {
    public static final String INSTANT_SUBSTITUTION = "InstantSubstitution";
    private static final Logger LOG = Logger.getLogger(CompletionJListOperator.class.getName());

    public CompletionJListOperator() {
        this(CompletionJListOperator.findCompletionJList());
    }

    private CompletionJListOperator(JList jList) {
        super(jList);
    }

    public List getCompletionItems() throws Exception {
        return CompletionJListOperator.getCompletionItems((JList)this.getSource());
    }

    private static List getCompletionItems(JList jList) throws Exception {
        ListModel listModel = jList.getModel();
        CompletionJListOperator completionJListOperator = new CompletionJListOperator(jList);
        int n = completionJListOperator.getModelSize();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(completionJListOperator.getModelElementAt(i));
        }
        return arrayList;
    }

    private static JList findCompletionJList() {
        final String string = Bundle.getStringTrimmed((String)"org.netbeans.modules.editor.completion.Bundle", (String)"completion-please-wait");
        Object object = CompletionJListOperator.waitFor(new Waitable(){

            public Object actionProduced(Object object) {
                if (DocumentWatcher.isActive() && DocumentWatcher.isModified()) {
                    return CompletionJListOperator.INSTANT_SUBSTITUTION;
                }
                try {
                    Object object2;
                    Object object3;
                    AccessibleObject accessibleObject;
                    CompletionImpl completionImpl = CompletionImpl.get();
                    Field field = CompletionImpl.class.getDeclaredField("layout");
                    field.setAccessible(true);
                    Object object4 = field.get(completionImpl);
                    Field field2 = object4.getClass().getDeclaredField("completionPopup");
                    field2.setAccessible(true);
                    Object object5 = field2.get(object4);
                    Field field3 = object5.getClass().getDeclaredField("completionScrollPane");
                    field3.setAccessible(true);
                    Object object6 = field3.get(object5);
                    if (object6 == null) {
                        return null;
                    }
                    Field field4 = completionImpl.getClass().getDeclaredField("completionResult");
                    field4.setAccessible(true);
                    Object object7 = field4.get(completionImpl);
                    if (object7 != null) {
                        accessibleObject = object7.getClass().getDeclaredMethod("getResultSets", new Class[0]);
                        ((Method)accessibleObject).setAccessible(true);
                        object3 = ((Method)accessibleObject).invoke(object7, new Object[0]);
                        object2 = completionImpl.getClass().getDeclaredMethod("isAllResultsFinished", List.class);
                        ((Method)object2).setAccessible(true);
                        Boolean bl = (Boolean)((Method)object2).invoke((Object)completionImpl, object3);
                        if (!bl.booleanValue()) {
                            LOG.fine(System.currentTimeMillis() + ": all CC Results not finished yet.");
                            return null;
                        }
                    }
                    accessibleObject = object6.getClass().getDeclaredField("view");
                    ((Field)accessibleObject).setAccessible(true);
                    object3 = (CompletionJList)((Field)accessibleObject).get(object6);
                    object2 = CompletionJListOperator.getCompletionItems((JList)object3);
                    if (object2.size() > 0 && !object2.contains(string)) {
                        LOG.fine(object2.toString());
                        return object3;
                    }
                    return null;
                }
                catch (Exception exception) {
                    throw new JemmyException("Exception when waiting for completion items.", (Throwable)exception);
                }
            }

            public String getDescription() {
                return "Wait for completion items data";
            }
        });
        if (object.equals(INSTANT_SUBSTITUTION)) {
            return null;
        }
        return (CompletionJList)object;
    }

    private static Object waitFor(Waitable waitable) {
        Waiter waiter = new Waiter(waitable);
        Timeouts timeouts = waiter.getTimeouts();
        timeouts.setTimeout("Waiter.TimeDelta", 500L);
        timeouts.setTimeout("Waiter.AfterWaitingTime", 500L);
        waiter.setTimeouts(timeouts);
        try {
            return waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException(waitable.getDescription() + " has been " + "interrupted.", (Throwable)interruptedException);
        }
    }

    public static CompletionJListOperator showCompletion() {
        CompletionJListOperator completionJListOperator = null;
        DocumentWatcher.start();
        Runnable runnable = new Runnable(){

            public void run() {
                Completion.get().showCompletion();
            }
        };
        CompletionJListOperator.runInAWT(runnable);
        JList jList = CompletionJListOperator.findCompletionJList();
        if (jList != null) {
            completionJListOperator = new CompletionJListOperator(jList);
        }
        DocumentWatcher.stop();
        return completionJListOperator;
    }

    public static void showDocumentation() {
        Runnable runnable = new Runnable(){

            public void run() {
                Completion.get().showDocumentation();
            }
        };
        CompletionJListOperator.runInAWT(runnable);
    }

    public static void showToolTipPopup() {
        Runnable runnable = new Runnable(){

            public void run() {
                Completion.get().showToolTip();
            }
        };
        CompletionJListOperator.runInAWT(runnable);
    }

    public static void hideAll() {
        Runnable runnable = new Runnable(){

            public void run() {
                Completion.get().hideAll();
            }
        };
        CompletionJListOperator.runInAWT(runnable);
    }

    public static void hideCompletion() {
        Runnable runnable = new Runnable(){

            public void run() {
                Completion.get().hideCompletion();
            }
        };
        CompletionJListOperator.runInAWT(runnable);
    }

    public static void hideDocumentation() {
        Runnable runnable = new Runnable(){

            public void run() {
                Completion.get().hideDocumentation();
            }
        };
        CompletionJListOperator.runInAWT(runnable);
    }

    public static void hideToolTipPopup() {
        Runnable runnable = new Runnable(){

            public void run() {
                Completion.get().hideToolTip();
            }
        };
        CompletionJListOperator.runInAWT(runnable);
    }

    private static void runInAWT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                throw new JemmyException("INVOKATION FAILED", (Throwable)exception);
            }
        }
    }

    private int getModelSize() {
        return this.runMapping(new Operator.MapIntegerAction("getModel().getSize()"){

            public int map() throws Exception {
                return CompletionJListOperator.this.getModel().getSize();
            }
        });
    }

    private Object getModelElementAt(final int n) {
        return this.runMapping(new Operator.MapAction("getModel().getElementAt()"){

            public Object map() throws Exception {
                return CompletionJListOperator.this.getModel().getElementAt(n);
            }
        });
    }

    public int findItemIndex(final JListOperator.ListItemChooser listItemChooser, final int n) {
        return this.runMapping(new Operator.MapIntegerAction("findItemIndex"){

            public int map() throws Exception {
                return CompletionJListOperator.super.findItemIndex(listItemChooser, n);
            }
        });
    }

    public Object clickOnItem(final String string) {
        return this.runMapping(new Operator.MapAction("clickOnItem( String )"){

            public Object map() throws Exception {
                return CompletionJListOperator.super.clickOnItem(string);
            }
        });
    }

    public Object clickOnItem(String string, Operator.StringComparator stringComparator) {
        return this.clickOnItem(string, stringComparator, 1);
    }

    public Object clickOnItem(final String string, final Operator.StringComparator stringComparator, final int n) {
        return this.runMapping(new Operator.MapAction("clickOnItem( String, Comparator )"){

            public Object map() throws Exception {
                final int n2 = CompletionJListOperator.super.findItemIndex(string, stringComparator, 0);
                if (n2 < 0 || n2 >= CompletionJListOperator.this.getModel().getSize()) {
                    throw new JListOperator.NoSuchItemException((JListOperator)CompletionJListOperator.this, n2);
                }
                return CompletionJListOperator.this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                    public Object launch() {
                        Rectangle rectangle;
                        if (((JList)CompletionJListOperator.this.getSource()).getAutoscrolls()) {
                            ((JList)CompletionJListOperator.this.getSource()).ensureIndexIsVisible(n2);
                        }
                        if ((rectangle = CompletionJListOperator.this.getCellBounds(n2, n2)) == null) {
                            return null;
                        }
                        Point point = new Point((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)(rectangle.getY() + rectangle.getHeight() / 2.0));
                        Object e = CompletionJListOperator.this.getModel().getElementAt(n2);
                        CompletionJListOperator.this.clickMouse(point.x, point.y, n);
                        return e;
                    }
                });
            }
        });
    }

    static class DocumentWatcher {
        private static BaseDocument doc;
        private static boolean modified;
        private static boolean active;
        static DocumentListener listener;

        DocumentWatcher() {
        }

        public static void start() {
            doc = Registry.getMostActiveDocument();
            doc.addDocumentListener(listener);
            modified = false;
            active = true;
        }

        public static void stop() {
            if (doc != null) {
                doc.removeDocumentListener(listener);
                doc = null;
            }
            active = false;
        }

        public static boolean isModified() {
            if (!active) {
                throw new IllegalStateException("start() must be called before this.");
            }
            return modified;
        }

        public static boolean isActive() {
            return active;
        }

        private static void setModified(boolean bl) {
            modified = bl;
            if (doc != null) {
                doc.removeDocumentListener(listener);
                doc = null;
            }
        }

        static {
            modified = false;
            active = false;
            listener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    DocumentWatcher.setModified(true);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                }
            };
        }
    }
}

