/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.stack.impl;

import java.util.Map;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCallImpl
extends FunctionCall {
    private String fileName;
    private String sourceFile;
    private final Map<FunctionMetric, Object> metrics;
    private final StringBuilder displayedName = new StringBuilder();

    public FunctionCallImpl(Function function, Map<FunctionMetric, Object> map) {
        super(function);
        this.metrics = map;
    }

    public FunctionCallImpl(Function function, long l, Map<FunctionMetric, Object> map) {
        super(function, l);
        this.metrics = map;
        this.updateDisplayedName();
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.updateDisplayedName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setSourceFile(String string) {
        this.sourceFile = string;
        this.updateDisplayedName();
    }

    public boolean hasSourceFileDefined() {
        return this.sourceFile != null;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayedName() {
        StringBuilder stringBuilder = this.displayedName;
        synchronized (stringBuilder) {
            return this.displayedName.toString();
        }
    }

    public Object getMetricValue(FunctionMetric functionMetric) {
        return this.metrics.get(functionMetric);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getFunction().toString());
        stringBuffer.append(" [ ");
        for (FunctionMetric functionMetric : this.metrics.keySet()) {
            stringBuffer.append(functionMetric.getMetricDisplayedName()).append(" == ");
            stringBuffer.append(this.metrics.get(functionMetric)).append("; ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean hasMetric(String string) {
        for (FunctionMetric functionMetric : this.metrics.keySet()) {
            if (!functionMetric.getMetricID().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Object getMetricValue(String string) {
        for (FunctionMetric functionMetric : this.metrics.keySet()) {
            if (!functionMetric.getMetricID().equals(string)) continue;
            return this.metrics.get(functionMetric);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayedName() {
        StringBuilder stringBuilder = this.displayedName;
        synchronized (stringBuilder) {
            this.displayedName.setLength(0);
            Function function = this.getFunction();
            if (function != null) {
                this.displayedName.append(function.getName());
            } else {
                this.displayedName.append("<unknown>");
            }
            if (this.fileName != null) {
                this.displayedName.append(", " + this.fileName);
                if (this.hasOffset()) {
                    this.displayedName.append(":").append(this.getOffset());
                }
            }
            if (this.displayedName.length() == 0) {
                this.displayedName.append(super.getDisplayedName());
            }
        }
    }
}

