/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DtraceParser {
    private static final Logger log = DLightLogger.getLogger(DtraceParser.class);
    private DataTableMetadata metadata;
    private List<String> colnames;

    public DtraceParser(DataTableMetadata dataTableMetadata) {
        this.metadata = dataTableMetadata;
        this.colnames = new ArrayList<String>(dataTableMetadata.getColumnsCount());
        for (DataTableMetadata.Column column : dataTableMetadata.getColumns()) {
            this.colnames.add(column.getColumnName());
        }
    }

    private List<String> parse(String string) {
        return this.parse(string, this.metadata.getColumnsCount());
    }

    protected List<String> parse(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        if (arrayList.size() < n) {
            log.info("^^^^^Line:" + string + " lines array size is " + "less than medatadat.getCoulmnsCount() columnsCount=" + this.metadata.getColumnsCount() + " lines splited=" + arrayList.size());
            return null;
        }
        List list = this.metadata.getColumns();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            Class clazz = ((DataTableMetadata.Column)list.get(i)).getColumnClass();
            if (clazz == String.class) {
                String string2 = (String)arrayList.get(i);
                if (string2 != null && string2.startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2 != null && string2.endsWith("\"")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string2 = "'" + string2.replaceAll("'", "\"") + "'";
                arrayList2.add(i, string2);
                continue;
            }
            arrayList2.add(i, (String)arrayList.get(i));
        }
        return arrayList2;
    }

    public DataRow process(String string) {
        List<String> list = this.parse(string);
        if (list == null) {
            return null;
        }
        return new DataRow(this.colnames, list);
    }
}

