/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.acl.NotOwnerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceDataAndStackParser;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceParser;
import org.netbeans.modules.dlight.dtrace.collector.support.ProcessLineCallback;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupportProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DtraceDataCollector
extends IndicatorDataProvider<DTDCConfiguration>
implements DataCollector<DTDCConfiguration> {
    private static final List<String> ultimateDTracePrivilegesList = Arrays.asList("dtrace_kernel", "dtrace_proc", "dtrace_user");
    private static final String cmd_dtrace = "/usr/sbin/dtrace";
    private static final Logger log = DLightLogger.getLogger(DtraceDataCollector.class);
    private List<String> requiredPrivilegesList;
    private DataTableMetadata tableMetaData = null;
    private String localScriptPath;
    private String extraArgs;
    private String scriptPath;
    private Future<Integer> dtraceTask = null;
    private DTDCConfiguration configuration;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());
    private String command = "/usr/sbin/dtrace";
    private String argsTemplate = null;
    private DataStorage storage;
    private List<DataTableMetadata> dataTablesMetadata;
    private DtraceParser parser;
    private final List<DataRow> indicatorDataBuffer = new ArrayList<DataRow>();
    private boolean isSlave;
    private int indicatorFiringFactor;
    private ProcessLineCallback callback = new ProcessLineCallBackImpl();
    private IndicatorDataProvideHandler handler;

    DtraceDataCollector(DTDCConfiguration dTDCConfiguration) {
        DTDCConfigurationAccessor dTDCConfigurationAccessor = DTDCConfigurationAccessor.getDefault();
        this.dataTablesMetadata = dTDCConfigurationAccessor.getDatatableMetadata(dTDCConfiguration);
        DataTableMetadata dataTableMetadata = this.tableMetaData = this.dataTablesMetadata != null && this.dataTablesMetadata.size() > 0 ? this.dataTablesMetadata.get(0) : null;
        this.parser = dTDCConfigurationAccessor.isStackSupportEnabled(dTDCConfiguration) ? new DtraceDataAndStackParser(this.tableMetaData) : (dTDCConfigurationAccessor.getParser(dTDCConfiguration) == null ? (this.tableMetaData != null ? new DtraceParser(this.tableMetaData) : (DtraceParser)null) : dTDCConfigurationAccessor.getParser(dTDCConfiguration));
        this.localScriptPath = dTDCConfigurationAccessor.getScriptPath(dTDCConfiguration);
        this.extraArgs = dTDCConfigurationAccessor.getArgs(dTDCConfiguration);
        this.requiredPrivilegesList = dTDCConfigurationAccessor.getRequiredPrivileges(dTDCConfiguration) == null ? ultimateDTracePrivilegesList : dTDCConfigurationAccessor.getRequiredPrivileges(dTDCConfiguration);
        this.configuration = dTDCConfiguration;
        this.indicatorFiringFactor = dTDCConfigurationAccessor.getIndicatorFiringFactor(dTDCConfiguration);
    }

    void setIndicatorDataProviderHanlder(IndicatorDataProvideHandler indicatorDataProvideHandler) {
        this.handler = indicatorDataProvideHandler;
    }

    public String getName() {
        return "DTrace";
    }

    void setProcessLineCallback(ProcessLineCallback processLineCallback) {
        this.callback = processLineCallback;
    }

    void setSlave(boolean bl) {
        this.isSlave = bl;
    }

    String getLocalScriptPath() {
        return this.localScriptPath;
    }

    void setLocalScriptPath(String string) {
        this.localScriptPath = string;
    }

    ProcessLineCallback getProcessLineCallback() {
        return this.callback;
    }

    protected DataStorage getStorage() {
        return this.storage;
    }

    public Collection<DataStorageType> getSupportedDataStorageTypes() {
        DataStorageTypeFactory dataStorageTypeFactory = DataStorageTypeFactory.getInstance();
        DataStorageType dataStorageType = dataStorageTypeFactory.getDataStorageType("db:sql");
        return Arrays.asList(dataStorageType);
    }

    public boolean isAttachable() {
        return true;
    }

    public void init(DataStorage dataStorage, DLightTarget dLightTarget) {
        this.storage = dataStorage;
        if (this.isSlave) {
            return;
        }
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        if (executionEnvironment.isLocal()) {
            this.scriptPath = this.localScriptPath;
            Util.setExecutionPermissions(Arrays.asList(this.scriptPath));
        } else {
            File file = new File(this.localScriptPath);
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
                this.scriptPath = hostInfo.getTempDir() + "/" + file.getName();
                Future future = CommonTasksSupport.uploadFile((String)this.localScriptPath, (ExecutionEnvironment)executionEnvironment, (String)this.scriptPath, (int)511, null);
                future.get();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (CancellationException cancellationException) {
                Exceptions.printStackTrace((Throwable)cancellationException);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
        }
    }

    public String getCmd() {
        return this.command;
    }

    public String[] getArgs() {
        return null;
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        return this.dataTablesMetadata;
    }

    protected String getCollectorTaskExtraParams() {
        return this.extraArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget dLightTarget) {
        if (!this.isSlave && this.dtraceTask != null && !this.dtraceTask.isDone()) {
            log.fine("Stopping DtraceDataCollector: " + this.dtraceTask.toString());
            this.dtraceTask.cancel(true);
            this.dtraceTask = null;
        }
        List<DataRow> list = this.indicatorDataBuffer;
        synchronized (list) {
            if (!this.indicatorDataBuffer.isEmpty()) {
                if (this.isSlave) {
                    if (this.handler != null) {
                        this.handler.notify(this.indicatorDataBuffer);
                    }
                } else {
                    this.notifyIndicators(this.indicatorDataBuffer);
                }
                this.indicatorDataBuffer.clear();
            }
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(DtraceDataCollector.class, (String)string, (Object[])stringArray);
    }

    private ValidationStatus doValidation(DLightTarget dLightTarget) {
        Object object;
        ConnectionManager connectionManager;
        DLightLogger.assertNonUiThread();
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        ValidationStatus validationStatus = null;
        boolean bl = false;
        boolean bl2 = true;
        String string = "";
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (hostInfo == null || hostInfo.getOSFamily() != HostInfo.OSFamily.SUNOS) {
            return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.DtraceIsSupportedOnSunOSOnly"));
        }
        try {
            bl = HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)this.command);
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            bl2 = false;
        }
        if (bl2) {
            validationStatus = bl ? ValidationStatus.validStatus() : ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.CommandNotFound", this.command));
        } else {
            connectionManager = ConnectionManager.getInstance();
            Runnable runnable = new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            object = connectionManager.getConnectToAction(executionEnvironment, runnable);
            validationStatus = ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("ValidationStatus.ErrorWhileValidation", string), (AsynchronousAction)object);
        }
        if (!validationStatus.isValid()) {
            return validationStatus;
        }
        connectionManager = SolarisPrivilegesSupportProvider.getSupportFor((ExecutionEnvironment)executionEnvironment);
        if (connectionManager == null) {
            return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.NoPrivSupport", (Object)executionEnvironment.toString()));
        }
        boolean bl3 = connectionManager.hasPrivileges(this.requiredPrivilegesList);
        if (!bl3) {
            try {
                connectionManager.requestPrivileges(this.requiredPrivilegesList, false);
                bl3 = true;
            }
            catch (NotOwnerException notOwnerException) {
                // empty catch block
            }
        }
        if (!bl3) {
            object = new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction asynchronousAction = connectionManager.getRequestPrivilegesAction(this.requiredPrivilegesList, (Runnable)object);
            validationStatus = validationStatus.merge(ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("DTraceDataCollector_Status_NotEnoughPrivileges", new String[0]), (AsynchronousAction)asynchronousAction));
        }
        return validationStatus;
    }

    public ValidationStatus validate(DLightTarget dLightTarget) {
        return this.validate(dLightTarget, (Validateable)this, true);
    }

    ValidationStatus validate(DLightTarget dLightTarget, Validateable validateable, boolean bl) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus validationStatus = this.validationStatus;
        ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
        if (bl) {
            this.notifyStatusChanged(validateable, validationStatus, validationStatus2);
        }
        this.validationStatus = validationStatus2;
        return validationStatus2;
    }

    public void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    private void targetStarted(DLightTarget dLightTarget) {
        Object object;
        if (this.isSlave) {
            return;
        }
        String string = this.scriptPath;
        if (dLightTarget instanceof AttachableTarget) {
            object = (AttachableTarget)dLightTarget;
            string = string + " " + object.getPID();
        }
        if ((object = this.getCollectorTaskExtraParams()) != null) {
            string = string + " " + (String)object;
        }
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)dLightTarget.getExecEnv());
        nativeProcessBuilder.setCommandLine(string);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor();
        executionDescriptor = executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new DtraceInputProcessorFactory());
        executionDescriptor = executionDescriptor.errProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new StdErrRedirectorFactory());
        executionDescriptor = executionDescriptor.inputOutput(InputOutput.NULL);
        ExecutionService executionService = ExecutionService.newService((Callable)nativeProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)("DTraceDataCollector " + string));
        this.dtraceTask = executionService.run();
        log.fine("DtraceDataCollector (" + this.dtraceTask.toString() + ") for " + string + " STARTED");
    }

    public void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    void notifyStatusChanged(Validateable object, ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus.equals((Object)validationStatus2)) {
            return;
        }
        ValidationListener[] validationListenerArray = this.validationListeners.toArray(new ValidationListener[0]);
        if (object == null) {
            object = this;
        }
        for (ValidationListener validationListener : validationListenerArray) {
            validationListener.validationStateChanged(object, validationStatus, validationStatus2);
        }
    }

    protected void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        this.notifyStatusChanged((Validateable)this, validationStatus, validationStatus2);
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                break;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    public void dataFiltersChanged(List<DataFilter> list) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface IndicatorDataProvideHandler {
        public void notify(List<DataRow> var1);
    }

    private static class StdErrRedirectorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private StdErrRedirectorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            return InputProcessors.copying((Writer)new OutputStreamWriter(System.err));
        }
    }

    private class DtraceInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private DtraceInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String string) {
                    DtraceDataCollector.this.callback.processLine(string);
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }
    }

    private final class ProcessLineCallBackImpl
    implements ProcessLineCallback {
        private long maxTimestamp;

        private ProcessLineCallBackImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String string) {
            DataRow dataRow = DtraceDataCollector.this.parser.process(string);
            if (dataRow != null) {
                long l;
                if (DtraceDataCollector.this.storage != null && DtraceDataCollector.this.tableMetaData != null) {
                    DtraceDataCollector.this.storage.addData(DtraceDataCollector.this.tableMetaData.getName(), Arrays.asList(dataRow));
                }
                if ((l = this.getTimestamp(dataRow)) == -1L || this.maxTimestamp < l) {
                    List list = DtraceDataCollector.this.indicatorDataBuffer;
                    synchronized (list) {
                        if (l != -1L) {
                            this.maxTimestamp = l;
                        }
                        DtraceDataCollector.this.indicatorDataBuffer.add(dataRow);
                        if (DtraceDataCollector.this.indicatorDataBuffer.size() >= DtraceDataCollector.this.indicatorFiringFactor) {
                            if (DtraceDataCollector.this.isSlave) {
                                if (DtraceDataCollector.this.handler != null) {
                                    DtraceDataCollector.this.handler.notify(DtraceDataCollector.this.indicatorDataBuffer);
                                }
                            } else {
                                DtraceDataCollector.this.notifyIndicators(DtraceDataCollector.this.indicatorDataBuffer);
                            }
                            DtraceDataCollector.this.indicatorDataBuffer.clear();
                        }
                    }
                }
            }
        }

        private long getTimestamp(DataRow dataRow) {
            Object object = dataRow.getData("timestamp");
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            if (object instanceof String) {
                try {
                    return Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1L;
        }
    }
}

