/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.dd.api.web.SessionConfig;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class OverviewPanel
extends SectionInnerPanel
implements ItemListener {
    DDDataObject dObj;
    WebApp webApp;
    private JLabel descriptionLabel;
    private JTextArea descriptionTA;
    private JLabel dispNameLabel;
    private JTextField dispNameTF;
    private JPanel filler;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel stLabel;
    private JTextField stTF;

    public OverviewPanel(SectionView sectionView, DDDataObject dDDataObject) {
        super(sectionView);
        this.dObj = dDDataObject;
        this.webApp = dDDataObject.getWebApp();
        this.initComponents();
        this.dispNameTF.setText(this.webApp.getDefaultDisplayName());
        this.addModifier(this.dispNameTF);
        Utils.makeTextAreaLikeTextField((JTextArea)this.descriptionTA, (JTextField)this.dispNameTF);
        this.descriptionTA.setText(this.webApp.getDefaultDescription());
        this.addModifier(this.descriptionTA);
        this.jCheckBox1.setSelected(this.webApp.isDistributable());
        this.jCheckBox1.addItemListener(this);
        this.stTF.setText(this.getSessionTimeout());
        this.addValidatee(this.stTF);
    }

    private String getSessionTimeout() {
        SessionConfig sessionConfig = this.webApp.getSingleSessionConfig();
        if (sessionConfig == null) {
            return "";
        }
        BigInteger bigInteger = sessionConfig.getSessionTimeout();
        return bigInteger == null ? "" : bigInteger.toString();
    }

    private void setSessionTimeout(String string) {
        String string2 = string.trim();
        SessionConfig sessionConfig = this.webApp.getSingleSessionConfig();
        if (sessionConfig != null) {
            if (string.length() == 0) {
                this.webApp.setSessionConfig(null);
            } else {
                sessionConfig.setSessionTimeout(new BigInteger(string2));
            }
        } else if (string.length() > 0) {
            try {
                SessionConfig sessionConfig2 = (SessionConfig)this.webApp.createBean("SessionConfig");
                sessionConfig2.setSessionTimeout(new BigInteger(string2));
                this.webApp.setSessionConfig(sessionConfig2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.stTF) {
            String string2 = string.trim();
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().clearError();
            } else {
                BigInteger bigInteger = null;
                try {
                    bigInteger = new BigInteger(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (bigInteger == null) {
                    this.getSectionView().getErrorPanel().setError(new Error(0, 0, "Invalid Value : " + string2, (JComponent)this.stTF));
                    return;
                }
                this.getSectionView().getErrorPanel().clearError();
            }
        }
    }

    public void setValue(JComponent jComponent, Object object) {
        String string = ((String)object).trim();
        if (jComponent == this.dispNameTF) {
            this.webApp.setDisplayName(string.length() == 0 ? null : string);
        } else if (jComponent == this.descriptionTA) {
            this.webApp.setDescription(string.length() == 0 ? null : string);
        } else if (jComponent == this.stTF) {
            this.setSessionTimeout(string);
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.stTF) {
            this.stTF.setText(this.getSessionTimeout());
        }
    }

    public void linkButtonPressed(Object object, String string) {
    }

    private void initComponents() {
        this.filler = new JPanel();
        this.dispNameLabel = new JLabel();
        this.dispNameTF = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTA = new JTextArea();
        this.jCheckBox1 = new JCheckBox();
        this.stLabel = new JLabel();
        this.stTF = new JTextField();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.filler.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
        this.dispNameLabel.setLabelFor(this.dispNameTF);
        Mnemonics.setLocalizedText((JLabel)this.dispNameLabel, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_displayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.dispNameLabel, gridBagConstraints);
        this.dispNameTF.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.dispNameTF, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTA);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.descriptionLabel, gridBagConstraints);
        this.descriptionTA.setRows(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.add(this.descriptionTA, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_distributable"));
        this.jCheckBox1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.jCheckBox1, gridBagConstraints);
        this.stLabel.setLabelFor(this.stTF);
        Mnemonics.setLocalizedText((JLabel)this.stLabel, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_sessionTimeout"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add(this.stLabel, gridBagConstraints);
        this.stTF.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add(this.stTF, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_min"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add(this.jLabel1, gridBagConstraints);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jCheckBox1) {
            this.dObj.modelUpdatedFromUI();
            this.dObj.setChangedFromUI(true);
            this.webApp.setDistributable(this.jCheckBox1.isSelected());
            this.dObj.setChangedFromUI(false);
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }
}

