/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class MainClassChooser
extends JPanel {
    private ChangeListener changeListener;
    private Collection<ElementHandle<TypeElement>> possibleMainClasses;
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private ButtonGroup buttonGroup1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;
    private JLabel lblMainClass;
    JRadioButton rbPermanent;
    JRadioButton rbSession;

    MainClassChooser(FileObject ... fileObjectArray) {
        this.initComponents();
        this.jMainClassList.setCellRenderer(new MainClassRenderer());
        this.initClassesView(fileObjectArray);
    }

    private void initClassesView(final FileObject ... fileObjectArray) {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(listSelectionEvent));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(mouseEvent));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                MainClassChooser.this.possibleMainClasses = SourceUtils.getMainClasses((FileObject[])fileObjectArray);
                if (MainClassChooser.this.possibleMainClasses.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainClassChooser.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                        }
                    });
                } else {
                    final ElementHandle[] elementHandleArray = MainClassChooser.this.possibleMainClasses.toArray(new ElementHandle[MainClassChooser.this.possibleMainClasses.size()]);
                    Arrays.sort(elementHandleArray, new MainClassComparator());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainClassChooser.this.jMainClassList.setListData(elementHandleArray);
                            MainClassChooser.this.jMainClassList.setSelectedIndex(0);
                        }
                    });
                }
            }
        });
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_WARMUP_MESSAGE")};
    }

    private boolean isValidMainClassName(Object object) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(object);
    }

    String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue())) {
            return ((ElementHandle)this.jMainClassList.getSelectedValue()).getQualifiedName();
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListener = null;
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        if (unitTestingSupport_hasMainMethodResult != null) {
            return unitTestingSupport_hasMainMethodResult;
        }
        if (fileObject == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fileObject).isEmpty();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblMainClass = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.rbSession = new JRadioButton();
        this.rbPermanent = new JRadioButton();
        this.setPreferredSize(new Dimension(380, 300));
        this.lblMainClass.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.lblMainClass, (String)NbBundle.getMessage(MainClassChooser.class, (String)"CTL_AvaialableMainClasses"));
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"AD_jMainClassList"));
        this.buttonGroup1.add(this.rbSession);
        this.rbSession.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSession, (String)NbBundle.getMessage(MainClassChooser.class, (String)"MainClassChooser.rbSession.text"));
        this.buttonGroup1.add(this.rbPermanent);
        Mnemonics.setLocalizedText((AbstractButton)this.rbPermanent, (String)NbBundle.getMessage(MainClassChooser.class, (String)"MainClassChooser.rbPermanent.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rbPermanent).add((Component)this.rbSession).add((Component)this.jScrollPane1, -1, 356, Short.MAX_VALUE).add((Component)this.lblMainClass)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lblMainClass, -2, 15, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 173, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.rbSession).addPreferredGap(0).add((Component)this.rbPermanent).addContainerGap()));
        this.lblMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"AD_jMainClassList"));
        this.getAccessibleContext().setAccessibleDescription("null");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MainClassComparator
    implements Comparator<ElementHandle> {
        private MainClassComparator() {
        }

        @Override
        public int compare(ElementHandle elementHandle, ElementHandle elementHandle2) {
            return elementHandle.getQualifiedName().compareTo(elementHandle2.getQualifiedName());
        }
    }

    private static final class MainClassRenderer
    extends DefaultListCellRenderer {
        private MainClassRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object instanceof String) {
                string = (String)object;
            }
            string = object instanceof ElementHandle ? ((ElementHandle)object).getQualifiedName() : object.toString();
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }
}

