/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import hidden.org.codehaus.plexus.util.StringUtils;
import hidden.org.codehaus.plexus.util.cli.Arg;
import hidden.org.codehaus.plexus.util.cli.CommandLineException;
import hidden.org.codehaus.plexus.util.cli.CommandLineUtils;
import hidden.org.codehaus.plexus.util.cli.Commandline;
import hidden.org.codehaus.plexus.util.cli.StreamConsumer;
import java.io.File;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class MavenSettings {
    public static final String PROP_DEFAULT_OPTIONS = "defaultOptions";
    public static final String PROP_SYNCH_PROXY = "synchronizeProxySettings";
    public static final String PROP_USE_COMMANDLINE = "useCommandLineMaven";
    public static final String PROP_COMMANDLINE_PATH = "commandLineMavenPath";
    public static final String PROP_SHOW_RUN_DIALOG = "showRunDialog";
    public static final String PROP_SOURCE_DOWNLOAD = "sourceDownload";
    public static final String PROP_JAVADOC_DOWNLOAD = "javadocDownload";
    public static final String PROP_BINARY_DOWNLOAD = "binaryDownload";
    public static final String PROP_LAST_ARCHETYPE_GROUPID = "lastArchetypeGroupId";
    public static final String PROP_CUSTOM_LOCAL_REPOSITORY = "localRepository";
    public static final String PROP_SKIP_TESTS = "skipTests";
    private static final String PROP_DEBUG = "showDebug";
    private static final String PROP_ERRORS = "showErrors";
    private static final String PROP_CHECKSUM_POLICY = "checksumPolicy";
    private static final String PROP_PLUGIN_POLICY = "pluginUpdatePolicy";
    private static final String PROP_FAILURE_BEHAVIOUR = "failureBehaviour";
    private static final String PROP_USE_REGISTRY = "usePluginRegistry";
    private static final MavenSettings INSTANCE = new MavenSettings();
    private static Boolean cachedMaven = null;

    public static MavenSettings getDefault() {
        return INSTANCE;
    }

    public boolean isInteractive() {
        return !this.hasOption("--batch", "-B");
    }

    public Boolean isOffline() {
        if (this.hasOption("--offline", "-o")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean isShowDebug() {
        return this.hasOption("--debug", "-X");
    }

    public boolean isShowErrors() {
        return this.hasOption("--errors", "-e");
    }

    public boolean isUpdateSnapshots() {
        return this.hasOption("--update-snapshots", "-U");
    }

    public boolean hasOption(String string, String string2) {
        String string3 = this.getDefaultOptions();
        if (string3 != null) {
            try {
                String[] stringArray;
                for (String string4 : stringArray = CommandLineUtils.translateCommandline((String)string3)) {
                    if (!(string4 = string4.trim()).startsWith(string2) && !string4.startsWith(string)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(MavenSettings.class.getName()).fine("Error parsing global options:" + string3);
                return string3.contains(string) || string3.contains(string2);
            }
        }
        return false;
    }

    protected final Preferences getPreferences() {
        return NbPreferences.forModule(MavenSettings.class);
    }

    protected final String putProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string2 != null) {
            this.getPreferences().put(string, string2);
        } else {
            this.getPreferences().remove(string);
        }
        return string3;
    }

    protected final String getProperty(String string) {
        return this.getPreferences().get(string, null);
    }

    private MavenSettings() {
        String string = this.getPreferences().get(PROP_DEFAULT_OPTIONS, null);
        if (string == null) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            string = "";
            String string7 = this.getPreferences().get(PROP_DEBUG, null);
            if (string7 != null) {
                boolean bl = Boolean.parseBoolean(string7);
                if (bl) {
                    string = string + " --debug";
                }
                this.getPreferences().remove(PROP_DEBUG);
            }
            if ((string6 = this.getPreferences().get(PROP_ERRORS, null)) != null) {
                boolean bl = Boolean.parseBoolean(string6);
                if (bl) {
                    string = string + " --errors";
                }
                this.getPreferences().remove(PROP_ERRORS);
            }
            if ((string5 = this.getPreferences().get(PROP_CHECKSUM_POLICY, null)) != null) {
                if ("fail".equals(string5)) {
                    string = string + " --strict-checksums";
                } else if ("warn".equals(string5)) {
                    string = string + " --lax-checksums";
                }
                this.getPreferences().remove(PROP_CHECKSUM_POLICY);
            }
            if ((string4 = this.getPreferences().get(PROP_FAILURE_BEHAVIOUR, null)) != null) {
                if ("fail-never".equals(string4)) {
                    string = string + " --fail-never";
                } else if ("fail-fast".equals(string4)) {
                    string = string + " --fail-fast";
                } else if ("fail-at-end".equals(string4)) {
                    string = string + " --fail-at-end";
                }
                this.getPreferences().remove(PROP_FAILURE_BEHAVIOUR);
            }
            if ((string3 = this.getPreferences().get(PROP_PLUGIN_POLICY, null)) != null) {
                string = Boolean.parseBoolean(string3) ? string + " --check-plugin-updates" : string + " --no-plugin-updates";
                this.getPreferences().remove(PROP_PLUGIN_POLICY);
            }
            if ((string2 = this.getPreferences().get(PROP_USE_REGISTRY, null)) != null) {
                if (!Boolean.parseBoolean(string2)) {
                    string = string + " --no-plugin-registry";
                }
                this.getPreferences().remove(PROP_USE_REGISTRY);
            }
            this.setDefaultOptions(string);
            try {
                this.getPreferences().flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    public String getDefaultOptions() {
        return this.getPreferences().get(PROP_DEFAULT_OPTIONS, "");
    }

    public void setDefaultOptions(String string) {
        this.putProperty(PROP_DEFAULT_OPTIONS, string);
    }

    public String getLastArchetypeGroupId() {
        return this.getPreferences().get(PROP_LAST_ARCHETYPE_GROUPID, "com.mycompany");
    }

    public void setLastArchetypeGroupId(String string) {
        this.putProperty(PROP_LAST_ARCHETYPE_GROUPID, string);
    }

    public void setSynchronizeProxy(boolean bl) {
        this.getPreferences().putBoolean(PROP_SYNCH_PROXY, bl);
    }

    public boolean isSynchronizeProxy() {
        return this.getPreferences().getBoolean(PROP_SYNCH_PROXY, true);
    }

    public void setCustomLocalRepository(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        String string2 = this.getCustomLocalRepository();
        this.putProperty(PROP_CUSTOM_LOCAL_REPOSITORY, string);
        if (!StringUtils.equals((String)string2, (String)string)) {
            EmbedderFactory.resetProjectEmbedder();
        }
    }

    public String getCustomLocalRepository() {
        return this.getPreferences().get(PROP_CUSTOM_LOCAL_REPOSITORY, null);
    }

    public File getCommandLinePath() {
        String string = this.getPreferences().get(PROP_COMMANDLINE_PATH, null);
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        return null;
    }

    public void setCommandLinePath(File file) {
        if (file == null) {
            this.getPreferences().remove(PROP_COMMANDLINE_PATH);
        } else {
            this.putProperty(PROP_COMMANDLINE_PATH, FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }

    public boolean isShowRunDialog() {
        return this.getPreferences().getBoolean(PROP_SHOW_RUN_DIALOG, false);
    }

    public void setShowRunDialog(boolean bl) {
        this.getPreferences().putBoolean(PROP_SHOW_RUN_DIALOG, bl);
    }

    public boolean isSkipTests() {
        return this.getPreferences().getBoolean(PROP_SKIP_TESTS, false);
    }

    public void setSkipTests(boolean bl) {
        this.getPreferences().putBoolean(PROP_SKIP_TESTS, bl);
    }

    public DownloadStrategy getSourceDownloadStrategy() {
        String string = this.getPreferences().get(PROP_SOURCE_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setSourceDownloadStrategy(DownloadStrategy downloadStrategy) {
        if (downloadStrategy != null) {
            this.getPreferences().put(PROP_SOURCE_DOWNLOAD, downloadStrategy.name());
        } else {
            this.getPreferences().remove(PROP_SOURCE_DOWNLOAD);
        }
    }

    public DownloadStrategy getJavadocDownloadStrategy() {
        String string = this.getPreferences().get(PROP_JAVADOC_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setJavadocDownloadStrategy(DownloadStrategy downloadStrategy) {
        if (downloadStrategy != null) {
            this.getPreferences().put(PROP_JAVADOC_DOWNLOAD, downloadStrategy.name());
        } else {
            this.getPreferences().remove(PROP_JAVADOC_DOWNLOAD);
        }
    }

    public DownloadStrategy getBinaryDownloadStrategy() {
        String string = this.getPreferences().get(PROP_BINARY_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setBinaryDownloadStrategy(DownloadStrategy downloadStrategy) {
        if (downloadStrategy != null) {
            this.getPreferences().put(PROP_BINARY_DOWNLOAD, downloadStrategy.name());
        } else {
            this.getPreferences().remove(PROP_BINARY_DOWNLOAD);
        }
    }

    public static boolean canFindExternalMaven() {
        Object object;
        String string;
        File file = MavenSettings.getDefault().getCommandLinePath();
        String string2 = string = Utilities.isWindows() ? "mvn.bat" : "mvn";
        if (file != null && file.exists() && ((File)(object = new File(file, "bin" + File.separator + string))).exists()) {
            return true;
        }
        if (cachedMaven != null) {
            return cachedMaven;
        }
        object = new Commandline();
        object.setExecutable(string);
        Arg arg = object.createArg();
        arg.setValue("--version");
        object.addArg(arg);
        RegExpConsumer regExpConsumer = new RegExpConsumer();
        try {
            int n = CommandLineUtils.executeCommandLine((Commandline)object, (StreamConsumer)regExpConsumer, (StreamConsumer)regExpConsumer);
            cachedMaven = regExpConsumer.hasMavenAround;
            return regExpConsumer.hasMavenAround;
        }
        catch (CommandLineException commandLineException) {
            Exceptions.printStackTrace((Throwable)commandLineException);
            cachedMaven = false;
            return false;
        }
    }

    static String getDefaultMavenInstanceVersion() {
        String string = Utilities.isWindows() ? "mvn.bat" : "mvn";
        return MavenSettings.getMavenVersion(string);
    }

    private static String getMavenVersion(String string) {
        Commandline commandline = new Commandline();
        commandline.setExecutable(string);
        Arg arg = commandline.createArg();
        arg.setValue("--version");
        commandline.addArg(arg);
        RegExpConsumer regExpConsumer = new RegExpConsumer();
        try {
            int n = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)regExpConsumer, (StreamConsumer)regExpConsumer);
            return regExpConsumer.version != null ? regExpConsumer.version.trim() : null;
        }
        catch (CommandLineException commandLineException) {
            Exceptions.printStackTrace((Throwable)commandLineException);
            return null;
        }
    }

    public static String getCommandLineMavenVersion() {
        File file = MavenSettings.getDefault().getCommandLinePath();
        if (file == null) {
            return MavenSettings.getDefaultMavenInstanceVersion();
        }
        String string = file.getAbsolutePath() + File.separator + "bin" + File.separator + (Utilities.isWindows() ? "mvn.bat" : "mvn");
        String string2 = MavenSettings.getMavenVersion(string);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    private static class RegExpConsumer
    implements StreamConsumer {
        private static final Pattern PATTERN = Pattern.compile("^Maven version:(.*)");
        private static final Pattern PATTERN_210 = Pattern.compile("^Apache Maven ([0-9\\.]*) .*");
        boolean hasMavenAround = false;
        String version = null;

        private RegExpConsumer() {
        }

        public void consumeLine(String string) {
            Matcher matcher = PATTERN.matcher(string);
            if (!matcher.matches()) {
                matcher = PATTERN_210.matcher(string);
            }
            if (matcher.matches()) {
                this.hasMavenAround = true;
                this.version = matcher.group(1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownloadStrategy {
        NEVER,
        FIRST_OPEN,
        EVERY_OPEN;

    }
}

