/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.ProjectState;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationsImpl
implements DeleteOperationImplementation,
MoveOperationImplementation,
CopyOperationImplementation {
    protected NbMavenProjectImpl project;
    private ProjectState state;

    public OperationsImpl(NbMavenProjectImpl nbMavenProjectImpl, ProjectState projectState) {
        this.project = nbMavenProjectImpl;
        this.state = projectState;
    }

    protected static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        OperationsImpl.addFile(fileObject, "pom.xml", arrayList);
        OperationsImpl.addFile(fileObject, "profiles.xml", arrayList);
        OperationsImpl.addFile(fileObject, "nbactions.xml", arrayList);
        OperationsImpl.addFile(fileObject, "nb-configuration.xml", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        OperationsImpl.addFile(this.project.getProjectDirectory(), "src", arrayList);
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
        BeanRunConfig beanRunConfig = new BeanRunConfig();
        beanRunConfig.setExecutionDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        beanRunConfig.setGoals(Collections.singletonList("clean"));
        beanRunConfig.setRecursive(false);
        beanRunConfig.setProject(this.project);
        beanRunConfig.setExecutionName(NbBundle.getMessage(OperationsImpl.class, (String)"NotifyDeleting.execute"));
        beanRunConfig.setUpdateSnapshots(false);
        beanRunConfig.setTaskDisplayName(NbBundle.getMessage(OperationsImpl.class, (String)"NotifyDeleting.execute"));
        ExecutorTask executorTask = RunUtils.executeMaven(beanRunConfig);
        executorTask.result();
        this.checkParentProject(this.project.getProjectDirectory(), true, null, null);
        beanRunConfig.setProject(null);
    }

    public void notifyDeleted() throws IOException {
        this.state.notifyDeleted();
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, final String string) throws IOException {
        if (project == null) {
            this.state.notifyDeleted();
            return;
        }
        if (project.getProjectDirectory().equals(this.project.getProjectDirectory())) {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    pOMModel.getProject().setName(string);
                    pOMModel.endTransaction();
                }
            };
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
            NbMavenProject.fireMavenProjectReload(this.project);
        }
        this.checkParentProject(this.project.getProjectDirectory(), false, string, file.getName());
    }

    public void notifyCopying() throws IOException {
    }

    public void notifyCopied(Project project, File file, String string) throws IOException {
        if (project != null) {
            this.checkParentProject(this.project.getProjectDirectory(), false, string, file.getName());
        }
    }

    private void checkParentProject(FileObject fileObject, final boolean bl, final String string, final String string2) throws IOException {
        NbMavenProjectImpl nbMavenProjectImpl;
        final String string3 = fileObject.getNameExt();
        FileObject fileObject2 = fileObject.getParent();
        Project project = ProjectManager.getDefault().findProject(fileObject2);
        if (project != null && (nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            FileObject fileObject3 = nbMavenProjectImpl.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    MavenProject mavenProject = nbMavenProjectImpl.getOriginalMavenProject();
                    if ((mavenProject.getModules() != null && mavenProject.getModules().contains(string3)) == bl) {
                        if (bl) {
                            pOMModel.getProject().removeModule(string3);
                        } else {
                            pOMModel.getProject().addModule(string3);
                        }
                    }
                    if (string != null && string2 != null && string2.equals(pOMModel.getProject().getArtifactId())) {
                        pOMModel.getProject().setArtifactId(string);
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)fileObject3, Collections.singletonList(modelOperation));
        }
    }
}

