/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.maven.LogicalViewProviderImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.maven.nodes.OthersRootChildren;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class OthersRootNode
extends AnnotatedAbstractNode {
    private FileObject file;

    OthersRootNode(NbMavenProjectImpl nbMavenProjectImpl, boolean bl, FileObject fileObject) {
        super((Children)new OthersRootChildren(nbMavenProjectImpl, bl), Lookups.fixed((Object[])new Object[]{fileObject, DataFolder.findFolder((FileObject)fileObject), new ChildDelegateFind()}));
        this.setName(bl ? "OtherTestRoots" : "OtherRoots");
        this.setDisplayName(bl ? NbBundle.getMessage(OthersRootNode.class, (String)"LBL_Other_Test_Sources") : NbBundle.getMessage(OthersRootNode.class, (String)"LBL_Other_Sources"));
        this.file = fileObject;
    }

    public Action[] getActions(boolean bl) {
        List<Action> list = Arrays.asList(super.getActions(bl));
        ArrayList<Action> arrayList = new ArrayList<Action>(list.size() + 5);
        arrayList.addAll(list);
        Action[] actionArray = new Action[arrayList.size()];
        actionArray = arrayList.toArray(actionArray);
        return actionArray;
    }

    private Image getIcon(boolean bl) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/others-badge.png", (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(bl), (Image)image, (int)8, (int)8);
    }

    protected Image getIconImpl(int n) {
        return this.getIcon(false);
    }

    protected Image getOpenedIconImpl(int n) {
        return this.getIcon(true);
    }

    public String getDisplayName() {
        String string = super.getDisplayName();
        try {
            string = this.file.getFileSystem().getStatus().annotateName(string, Collections.singleton(this.file));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return string;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status status = this.file.getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string = htmlStatus.annotateNameHtml(super.getDisplayName(), Collections.singleton(this.file));
                if (!super.getDisplayName().equals(string)) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return super.getHtmlDisplayName();
    }

    static class ChildDelegateFind
    implements LogicalViewProviderImpl.FindDelegate {
        ChildDelegateFind() {
        }

        public Node[] getDelegates(Node node) {
            return node.getChildren().getNodes(true);
        }
    }
}

