/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.openide.filesystems.FileObject;

public class UserActionGoalProvider
extends AbstractMavenActionsProvider {
    public static final String FILENAME = "nbactions.xml";
    private NbMavenProjectImpl project;
    private Date lastModified = new Date();
    private boolean lastTimeExists = true;

    public UserActionGoalProvider(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    public InputStream getActionDefinitionStream() {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(FILENAME);
        boolean bl = this.lastTimeExists = fileObject != null;
        if (fileObject != null) {
            try {
                this.lastModified = fileObject.lastModified();
                return fileObject.getInputStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        this.lastModified = new Date();
        return null;
    }

    public NetbeansActionMapping[] getCustomMappings() {
        NetbeansActionMapping[] netbeansActionMappingArray = new NetbeansActionMapping[]{};
        try {
            ArrayList<NetbeansActionMapping> arrayList = new ArrayList<NetbeansActionMapping>();
            Reader reader = this.performDynamicSubstitutions(Collections.EMPTY_MAP, this.getRawMappingsAsString());
            ActionToGoalMapping actionToGoalMapping = this.reader.read(reader);
            List<NetbeansActionMapping> list = actionToGoalMapping.getActions();
            if (list != null) {
                for (NetbeansActionMapping netbeansActionMapping : list) {
                    if (!netbeansActionMapping.getActionName().startsWith("CUSTOM-")) continue;
                    arrayList.add(netbeansActionMapping);
                }
            }
            return arrayList.toArray(new NetbeansActionMapping[arrayList.size()]);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return netbeansActionMappingArray;
    }

    protected boolean reloadStream() {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(FILENAME);
        boolean bl = this.lastTimeExists;
        this.lastTimeExists = fileObject != null;
        return fileObject == null && bl || fileObject != null && fileObject.lastModified().after(this.lastModified);
    }
}

