/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.configurations.NewConfigurationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConfigurationsPanel
extends JPanel {
    private NbMavenProjectImpl project;
    private ModelHandle handle;
    List<ModelHandle.Configuration> lastNonProfileList = new ArrayList<ModelHandle.Configuration>();
    private JButton btnActivate;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JCheckBox cbEnable;
    private JCheckBox cbProfiles;
    private JScrollPane jScrollPane1;
    private JLabel lblConfigurations;
    private JList lstConfigurations;

    private ConfigurationsPanel() {
        this.initComponents();
    }

    ConfigurationsPanel(ModelHandle modelHandle, NbMavenProjectImpl nbMavenProjectImpl) {
        this();
        this.handle = modelHandle;
        this.project = nbMavenProjectImpl;
        this.cbEnable.setSelected(modelHandle.isConfigurationsEnabled());
        this.cbProfiles.setSelected(true);
        this.cbProfiles.setEnabled(false);
        this.initUI(modelHandle.isConfigurationsEnabled());
        this.lstConfigurations.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                ModelHandle.Configuration configuration = (ModelHandle.Configuration)object;
                if (configuration == ConfigurationsPanel.this.handle.getActiveConfiguration()) {
                    component.setFont(component.getFont().deriveFont(1));
                }
                return component;
            }
        });
        this.lstConfigurations.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConfigurationsPanel.this.checkButtonEnablement();
            }
        });
        this.createListModel();
    }

    private void checkButtonEnablement() {
        ModelHandle.Configuration configuration = (ModelHandle.Configuration)this.lstConfigurations.getSelectedValue();
        if (configuration == null || configuration.isProfileBased() || configuration.isDefault()) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
        }
    }

    private void createListModel() {
        DefaultListModel<ModelHandle.Configuration> defaultListModel = new DefaultListModel<ModelHandle.Configuration>();
        if (this.handle.getConfigurations() != null) {
            for (ModelHandle.Configuration configuration : this.handle.getConfigurations()) {
                defaultListModel.addElement(configuration);
            }
        }
        this.lstConfigurations.setModel(defaultListModel);
        this.lstConfigurations.setSelectedValue(this.handle.getActiveConfiguration(), true);
        this.cbProfiles.setSelected(true);
    }

    private void initComponents() {
        this.cbEnable = new JCheckBox();
        this.cbProfiles = new JCheckBox();
        this.lblConfigurations = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstConfigurations = new JList();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnActivate = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnable, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.cbEnable.text"));
        this.cbEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationsPanel.this.cbEnableActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbProfiles, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.cbProfiles.text"));
        this.cbProfiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationsPanel.this.cbProfilesActionPerformed(actionEvent);
            }
        });
        this.lblConfigurations.setLabelFor(this.lstConfigurations);
        Mnemonics.setLocalizedText((JLabel)this.lblConfigurations, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.lblConfigurations.text"));
        this.lstConfigurations.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.lstConfigurations.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstConfigurations);
        this.lstConfigurations.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.lstConfigurations.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationsPanel.this.btnAddActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnEdit.text"));
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationsPanel.this.btnEditActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationsPanel.this.btnRemoveActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnActivate, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnActivate.text"));
        this.btnActivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationsPanel.this.btnActivateActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbEnable).add(2, (Component)this.cbProfiles, -1, -1, Short.MAX_VALUE).add((Component)this.lblConfigurations)).add(6, 6, 6)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(0))).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.btnAdd).add((Component)this.btnActivate).add((Component)this.btnEdit)).add((Component)this.btnRemove)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.btnActivate, this.btnAdd, this.btnEdit, this.btnRemove}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbEnable).add(8, 8, 8).add((Component)this.cbProfiles).add(18, 18, 18).add((Component)this.lblConfigurations).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnActivate).add(18, 18, 18).add((Component)this.btnAdd).addPreferredGap(0).add((Component)this.btnEdit).addPreferredGap(0).add((Component)this.btnRemove).addContainerGap(81, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 203, Short.MAX_VALUE))));
        this.cbEnable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.cbEnable.AccessibleContext.accessibleDescription"));
        this.cbProfiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.cbProfiles.AccessibleContext.accessibleDescription"));
        this.btnAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnAdd.AccessibleContext.accessibleDescription"));
        this.btnEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnEdit.AccessibleContext.accessibleDescription"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnRemove.AccessibleContext.accessibleDescription"));
        this.btnActivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnActivate.AccessibleContext.accessibleDescription"));
    }

    private void cbEnableActionPerformed(ActionEvent actionEvent) {
        this.initUI(this.cbEnable.isSelected());
        this.handle.setConfigurationsEnabled(this.cbEnable.isSelected());
    }

    private void cbProfilesActionPerformed(ActionEvent actionEvent) {
        this.initListUI(this.cbProfiles.isSelected());
    }

    private void btnAddActionPerformed(ActionEvent actionEvent) {
        NewConfigurationPanel newConfigurationPanel = new NewConfigurationPanel();
        newConfigurationPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ACSD_Add_Config"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newConfigurationPanel, NbBundle.getMessage(ConfigurationsPanel.class, (String)"TIT_Add_Config"));
        newConfigurationPanel.attachDescriptor(dialogDescriptor);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION) {
            ModelHandle.Configuration configuration = ModelHandle.createCustomConfiguration(newConfigurationPanel.getConfigurationId());
            configuration.setShared(newConfigurationPanel.isShared());
            configuration.setActivatedProfiles(newConfigurationPanel.getProfiles());
            this.handle.addConfiguration(configuration);
            this.handle.markAsModified(this.handle.getConfigurations());
            this.createListModel();
            this.lstConfigurations.setSelectedValue(configuration, true);
        }
    }

    private void btnEditActionPerformed(ActionEvent actionEvent) {
        ModelHandle.Configuration configuration = (ModelHandle.Configuration)this.lstConfigurations.getSelectedValue();
        if (configuration != null) {
            NewConfigurationPanel newConfigurationPanel = new NewConfigurationPanel();
            newConfigurationPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ACSD_Edit_Config"));
            newConfigurationPanel.setConfigurationId(configuration.getId());
            newConfigurationPanel.setProfiles(configuration.getActivatedProfiles());
            newConfigurationPanel.setShared(configuration.isShared());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newConfigurationPanel, NbBundle.getMessage(ConfigurationsPanel.class, (String)"TIT_Edit_Config"));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == DialogDescriptor.OK_OPTION) {
                configuration.setShared(newConfigurationPanel.isShared());
                configuration.setActivatedProfiles(newConfigurationPanel.getProfiles());
                this.handle.markAsModified(this.handle.getConfigurations());
                this.createListModel();
                this.lstConfigurations.setSelectedValue(configuration, true);
            }
        }
    }

    private void btnRemoveActionPerformed(ActionEvent actionEvent) {
        ModelHandle.Configuration configuration = (ModelHandle.Configuration)this.lstConfigurations.getSelectedValue();
        if (configuration != null) {
            this.handle.removeConfiguration(configuration);
            this.createListModel();
        }
    }

    private void btnActivateActionPerformed(ActionEvent actionEvent) {
        ModelHandle.Configuration configuration = (ModelHandle.Configuration)this.lstConfigurations.getSelectedValue();
        if (configuration != null) {
            this.handle.setActiveConfiguration(configuration);
        }
        this.lstConfigurations.repaint();
    }

    private void initListUI(boolean bl) {
        this.lstConfigurations.setEnabled(bl);
        this.btnActivate.setEnabled(bl);
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
    }

    private void initUI(boolean bl) {
        this.initListUI(bl);
        if (bl) {
            this.checkButtonEnablement();
        }
    }
}

