/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.IdFunctionObject;
import org.mozilla.nb.javascript.IdScriptableObject;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeBoolean
extends IdScriptableObject {
    static final long serialVersionUID = -3716996899943880933L;
    private static final Object BOOLEAN_TAG = "Boolean";
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private boolean booleanValue;

    static void init(Scriptable scriptable, boolean bl) {
        NativeBoolean nativeBoolean = new NativeBoolean(false);
        nativeBoolean.exportAsJSClass(4, scriptable, bl);
    }

    private NativeBoolean(boolean bl) {
        this.booleanValue = bl;
    }

    @Override
    public String getClassName() {
        return "Boolean";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == ScriptRuntime.BooleanClass) {
            return ScriptRuntime.wrapBoolean(this.booleanValue);
        }
        return super.getDefaultValue(clazz);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 4: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(BOOLEAN_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(BOOLEAN_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n == 1) {
            boolean bl;
            if (objectArray.length == 0) {
                bl = false;
            } else {
                boolean bl2 = bl = objectArray[0] instanceof ScriptableObject && ((ScriptableObject)objectArray[0]).avoidObjectDetection() ? true : ScriptRuntime.toBoolean(objectArray[0]);
            }
            if (scriptable2 == null) {
                return new NativeBoolean(bl);
            }
            return ScriptRuntime.wrapBoolean(bl);
        }
        if (!(scriptable2 instanceof NativeBoolean)) {
            throw NativeBoolean.incompatibleCallError(idFunctionObject);
        }
        boolean bl = ((NativeBoolean)scriptable2).booleanValue;
        switch (n) {
            case 2: {
                return bl ? "true" : "false";
            }
            case 3: {
                return bl ? "(new Boolean(true))" : "(new Boolean(false))";
            }
            case 4: {
                return ScriptRuntime.wrapBoolean(bl);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block8: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 7) {
                string2 = "valueOf";
                n = 4;
            } else if (n2 == 8) {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 3;
                } else if (c == 't') {
                    string2 = "toString";
                    n = 2;
                }
            } else if (n2 == 11) {
                string2 = "constructor";
                n = 1;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block8;
            n = 0;
        }
        return n;
    }
}

